/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.workflow;

import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceOpenedPluginEvent;
import ghidra.app.services.DebuggerBot;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerWorkflowService;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.framework.main.FrontEndOnly;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginEventListener;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.datastruct.CollectionChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@PluginInfo(shortDescription="Debugger workflow service", description="Manage automatic debugging actions and analysis", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, servicesProvided={DebuggerWorkflowService.class})
public class DebuggerWorkflowServicePlugin
extends Plugin
implements DebuggerWorkflowService,
FrontEndOnly,
OptionsChangeListener {
    private DebuggerModelService modelService;
    private AutoService.Wiring autoServiceWiring;
    private final ChangeListener botsChangeListener = this::botsChanged;
    private final Map<PluginTool, ForTrackingOpenStuffPluginEventListener> trackStuffListenersByTool = new HashMap<PluginTool, ForTrackingOpenStuffPluginEventListener>();
    final List<DebuggerBot> allBots = new ArrayList<DebuggerBot>();
    private final ToolOptions options;
    protected final FrontEndTool tool;
    private ForBotsModelsChangeListener modelsChangedListener = new ForBotsModelsChangeListener();

    public DebuggerWorkflowServicePlugin(PluginTool tool) {
        super(tool);
        this.tool = (FrontEndTool)tool;
        this.autoServiceWiring = AutoService.wireServicesProvidedAndConsumed((Plugin)this);
        this.options = tool.getOptions("Debugger.Workflow");
        this.options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    protected void init() {
        super.init();
        ClassSearcher.addChangeListener((ChangeListener)this.botsChangeListener);
        this.refreshBots();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        ClassSearcher.removeChangeListener((ChangeListener)this.botsChangeListener);
        Map<PluginTool, ForTrackingOpenStuffPluginEventListener> map = this.trackStuffListenersByTool;
        synchronized (map) {
            for (ForTrackingOpenStuffPluginEventListener l : this.trackStuffListenersByTool.values()) {
                l.dispose();
            }
            this.trackStuffListenersByTool.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(Consumer<DebuggerBot> evt) {
        List<DebuggerBot> list = this.allBots;
        synchronized (list) {
            for (DebuggerBot bot : this.allBots) {
                if (!bot.isEnabled()) continue;
                evt.accept(bot);
            }
        }
    }

    private void botsChanged(ChangeEvent evt) {
        this.refreshBots();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshBots() {
        List<DebuggerBot> list = this.allBots;
        synchronized (list) {
            ArrayList<DebuggerBot> removed = new ArrayList<DebuggerBot>(this.allBots);
            this.allBots.clear();
            this.allBots.addAll(ClassSearcher.getInstances(DebuggerBot.class));
            ArrayList<DebuggerBot> added = new ArrayList<DebuggerBot>(this.allBots);
            added.removeAll(removed);
            removed.removeAll(this.allBots);
            for (DebuggerBot bot : removed) {
                this.options.removeOption(bot.getDescription());
            }
            for (DebuggerBot bot : added) {
                this.options.registerOption(bot.getDescription(), OptionType.BOOLEAN_TYPE, (Object)bot.isEnabledByDefault(), bot.getHelpLocation(), bot.getDetails());
            }
            for (DebuggerBot bot : removed) {
                try {
                    if (!bot.isEnabled()) continue;
                    bot.disable();
                }
                catch (Throwable t) {
                    Msg.error((Object)this, (Object)("Failed to disable debugger bot: " + bot), (Throwable)t);
                }
            }
            if (SystemUtilities.isInTestingMode()) {
                return;
            }
            for (DebuggerBot bot : added) {
                try {
                    boolean enabled = this.options.getBoolean(bot.getDescription(), bot.isEnabledByDefault());
                    bot.setEnabled(this, enabled);
                }
                catch (Throwable t) {
                    Msg.error((Object)this, (Object)("Failed to enable debugger bot: " + bot), (Throwable)t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optionsChanged(ToolOptions opts, String optionName, Object oldValue, Object newValue) {
        assert (this.options == opts);
        if (SystemUtilities.isInTestingMode()) {
            return;
        }
        List<DebuggerBot> list = this.allBots;
        synchronized (list) {
            for (DebuggerBot bot : this.allBots) {
                if (!optionName.equals(bot.getDescription())) continue;
                boolean enabled = (Boolean)newValue;
                if (bot.isEnabled() == enabled) continue;
                bot.setEnabled(this, enabled);
            }
        }
    }

    public void pluginToolAdded(PluginTool t) {
        this.trackToolEvents(t);
    }

    public void pluginToolRemoved(PluginTool t) {
        this.untrackToolEvents(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackToolEvents(PluginTool t) {
        Map<PluginTool, ForTrackingOpenStuffPluginEventListener> map = this.trackStuffListenersByTool;
        synchronized (map) {
            ForTrackingOpenStuffPluginEventListener old = this.trackStuffListenersByTool.put(t, new ForTrackingOpenStuffPluginEventListener(t));
            if (old != null) {
                old.dispose();
                Msg.warn((Object)this, (Object)("Tracking a tool twice: " + this.tool));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void untrackToolEvents(PluginTool t) {
        Map<PluginTool, ForTrackingOpenStuffPluginEventListener> map = this.trackStuffListenersByTool;
        synchronized (map) {
            ForTrackingOpenStuffPluginEventListener removed = this.trackStuffListenersByTool.remove(t);
            if (removed != null) {
                removed.dispose();
            } else {
                Msg.warn((Object)this, (Object)("Never tracked a tool: " + this.tool));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PluginTool> getProxyingPluginTools() {
        Map<PluginTool, ForTrackingOpenStuffPluginEventListener> map = this.trackStuffListenersByTool;
        synchronized (map) {
            return List.copyOf(this.trackStuffListenersByTool.keySet());
        }
    }

    @AutoServiceConsumed
    private void setModelService(DebuggerModelService modelService) {
        if (this.modelService != null) {
            this.modelService.removeModelsChangedListener(this.modelsChangedListener);
        }
        this.modelService = modelService;
        if (this.modelService != null) {
            this.modelService.addModelsChangedListener(this.modelsChangedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<DebuggerBot> getAllBots() {
        List<DebuggerBot> list = this.allBots;
        synchronized (list) {
            return Set.copyOf(this.allBots);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<DebuggerBot> getEnabledBots() {
        List<DebuggerBot> list = this.allBots;
        synchronized (list) {
            return this.allBots.stream().filter(a -> a.isEnabled()).collect(Collectors.toSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<DebuggerBot> getDisabledBots() {
        List<DebuggerBot> list = this.allBots;
        synchronized (list) {
            return this.allBots.stream().filter(a -> !a.isEnabled()).collect(Collectors.toSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableBots(Set<DebuggerBot> bots) {
        List<DebuggerBot> list = this.allBots;
        synchronized (list) {
            for (DebuggerBot bot : bots) {
                if (!this.allBots.contains(bot)) {
                    Msg.error((Object)this, (Object)("Ignoring request to enable non-discoverable bot " + bot));
                    continue;
                }
                if (bot.isEnabled()) continue;
                try {
                    bot.enable(this);
                }
                catch (Throwable e) {
                    Msg.error((Object)this, (Object)("Error enabling " + bot), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableBots(Set<DebuggerBot> bots) {
        List<DebuggerBot> list = this.allBots;
        synchronized (list) {
            for (DebuggerBot bot : bots) {
                if (!this.allBots.contains(bot)) {
                    Msg.error((Object)this, (Object)("Ignoring request to disable non-discoverable bot " + bot));
                    continue;
                }
                if (!bot.isEnabled()) continue;
                try {
                    bot.disable();
                }
                catch (Throwable e) {
                    Msg.error((Object)this, (Object)("Error disabling " + bot), (Throwable)e);
                }
            }
        }
    }

    protected class ForTrackingOpenStuffPluginEventListener
    implements PluginEventListener {
        private final PluginTool t;
        private final Set<Class<? extends PluginEvent>> types = Set.of(ProgramOpenedPluginEvent.class, ProgramClosedPluginEvent.class, TraceOpenedPluginEvent.class, TraceClosedPluginEvent.class);

        public ForTrackingOpenStuffPluginEventListener(PluginTool tool) {
            this.t = tool;
            for (Class<? extends PluginEvent> cls : this.types) {
                tool.addEventListener(cls, (PluginEventListener)this);
            }
        }

        private void dispose() {
            for (Class<? extends PluginEvent> cls : this.types) {
                this.t.removeEventListener(cls, (PluginEventListener)this);
            }
        }

        public void eventSent(PluginEvent event) {
            Object evt;
            if (event instanceof ProgramOpenedPluginEvent) {
                evt = (ProgramOpenedPluginEvent)event;
                DebuggerWorkflowServicePlugin.this.dispatch(arg_0 -> this.lambda$eventSent$0((ProgramOpenedPluginEvent)evt, arg_0));
            }
            if (event instanceof ProgramClosedPluginEvent) {
                evt = (ProgramClosedPluginEvent)event;
                DebuggerWorkflowServicePlugin.this.dispatch(arg_0 -> this.lambda$eventSent$1((ProgramClosedPluginEvent)evt, arg_0));
            }
            if (event instanceof TraceOpenedPluginEvent) {
                evt = (TraceOpenedPluginEvent)event;
                DebuggerWorkflowServicePlugin.this.dispatch(arg_0 -> this.lambda$eventSent$2((TraceOpenedPluginEvent)((Object)evt), arg_0));
            }
            if (event instanceof TraceClosedPluginEvent) {
                evt = (TraceClosedPluginEvent)event;
                DebuggerWorkflowServicePlugin.this.dispatch(arg_0 -> this.lambda$eventSent$3((TraceClosedPluginEvent)((Object)evt), arg_0));
            }
        }

        private /* synthetic */ void lambda$eventSent$3(TraceClosedPluginEvent evt, DebuggerBot a) {
            a.traceClosed(this.t, evt.getTrace());
        }

        private /* synthetic */ void lambda$eventSent$2(TraceOpenedPluginEvent evt, DebuggerBot a) {
            a.traceOpened(this.t, evt.getTrace());
        }

        private /* synthetic */ void lambda$eventSent$1(ProgramClosedPluginEvent evt, DebuggerBot a) {
            a.programClosed(this.t, evt.getProgram());
        }

        private /* synthetic */ void lambda$eventSent$0(ProgramOpenedPluginEvent evt, DebuggerBot a) {
            a.programOpened(this.t, evt.getProgram());
        }
    }

    protected class ForBotsModelsChangeListener
    implements CollectionChangeListener<DebuggerObjectModel> {
        protected ForBotsModelsChangeListener() {
        }

        public void elementAdded(DebuggerObjectModel element) {
            DebuggerWorkflowServicePlugin.this.dispatch(a -> a.modelAdded(element));
        }

        public void elementRemoved(DebuggerObjectModel element) {
            DebuggerWorkflowServicePlugin.this.dispatch(a -> a.modelRemoved(element));
        }
    }
}

