/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangVariableDecl;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;

public class ClangSyntaxToken
extends ClangToken {
    private int open = -1;
    private int close = -1;

    public ClangSyntaxToken(ClangNode par) {
        super(par);
    }

    public ClangSyntaxToken(ClangNode par, String txt) {
        super(par, txt);
    }

    public ClangSyntaxToken(ClangNode par, String txt, String col) {
        super(par, txt, col);
    }

    @Override
    public boolean isVariableRef() {
        return this.Parent() instanceof ClangVariableDecl;
    }

    @Override
    public void restoreFromXML(XmlElement el, XmlElement end, PcodeFactory pfactory) {
        super.restoreFromXML(el, end, pfactory);
        String str = el.getAttribute("open");
        if (str != null) {
            this.open = SpecXmlUtils.decodeInt((String)str);
        }
        if ((str = el.getAttribute("close")) != null) {
            this.close = SpecXmlUtils.decodeInt((String)str);
        }
    }

    public int getOpen() {
        return this.open;
    }

    public int getClose() {
        return this.close;
    }
}

