/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangBreak;
import ghidra.app.decompiler.ClangCommentToken;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangFunction;
import ghidra.app.decompiler.ClangLabelToken;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangOpToken;
import ghidra.app.decompiler.ClangSyntaxToken;
import ghidra.app.decompiler.ClangTypeToken;
import ghidra.app.decompiler.ClangVariableDecl;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.awt.Color;
import java.util.List;

public class ClangToken
implements ClangNode {
    public static final int KEYWORD_COLOR = 0;
    public static final int TYPE_COLOR = 1;
    public static final int FUNCTION_COLOR = 2;
    public static final int COMMENT_COLOR = 3;
    public static final int VARIABLE_COLOR = 4;
    public static final int CONST_COLOR = 5;
    public static final int PARAMETER_COLOR = 6;
    public static final int GLOBAL_COLOR = 7;
    public static final int DEFAULT_COLOR = 8;
    private ClangNode parent;
    private ClangLine lineparent;
    private String text;
    private int syntax_type;
    private Color highlight;
    private boolean matchingToken;

    public ClangToken(ClangNode par) {
        this.parent = par;
        this.text = null;
        this.highlight = null;
        this.syntax_type = ClangToken.getColor(null);
        this.lineparent = null;
    }

    public ClangToken(ClangNode par, String txt) {
        this.parent = par;
        this.text = txt;
        this.highlight = null;
        this.syntax_type = ClangToken.getColor(null);
    }

    public ClangToken(ClangNode par, String txt, String col) {
        this.parent = par;
        this.text = txt;
        this.highlight = null;
        this.syntax_type = ClangToken.getColor(col);
    }

    @Override
    public ClangNode Parent() {
        return this.parent;
    }

    public ClangLine getLineParent() {
        return this.lineparent;
    }

    public void setLineParent(ClangLine line) {
        this.lineparent = line;
    }

    @Override
    public Address getMinAddress() {
        return null;
    }

    @Override
    public Address getMaxAddress() {
        return null;
    }

    @Override
    public int numChildren() {
        return 0;
    }

    @Override
    public ClangNode Child(int i) {
        return null;
    }

    @Override
    public ClangFunction getClangFunction() {
        if (this.parent != null) {
            return this.parent.getClangFunction();
        }
        return null;
    }

    @Override
    public void setHighlight(Color val) {
        this.highlight = val;
    }

    public Color getHighlight() {
        return this.highlight;
    }

    public void setMatchingToken(boolean matchingToken) {
        this.matchingToken = matchingToken;
    }

    public boolean isMatchingToken() {
        return this.matchingToken;
    }

    public boolean isVariableRef() {
        return false;
    }

    public int getSyntaxType() {
        return this.syntax_type;
    }

    void setSyntaxType(int syntax_type) {
        this.syntax_type = syntax_type;
    }

    public String getText() {
        return this.text;
    }

    void setText(String text) {
        this.text = text;
    }

    public void restoreFromXML(XmlElement el, XmlElement end, PcodeFactory pfactory) {
        this.text = end.getText();
        String col = el.getAttribute("color");
        this.syntax_type = ClangToken.getColor(col);
    }

    @Override
    public void flatten(List<ClangNode> list) {
        list.add(this);
    }

    public static ClangToken buildToken(ClangNode par, XmlPullParser parser, PcodeFactory pfactory) {
        XmlElement node = parser.start(new String[]{"variable", "op", "syntax", "break", "funcname", "type", "comment", "label", "field"});
        ClangToken token = null;
        if (node.getName().equals("variable")) {
            token = new ClangVariableToken(par);
        } else if (node.getName().equals("op")) {
            token = new ClangOpToken(par);
        } else if (node.getName().equals("syntax")) {
            token = new ClangSyntaxToken(par);
        } else if (node.getName().equals("break")) {
            token = new ClangBreak(par);
        } else if (node.getName().equals("funcname")) {
            token = new ClangFuncNameToken(par, null);
        } else if (node.getName().equals("type")) {
            token = new ClangTypeToken(par);
        } else if (node.getName().equals("comment")) {
            token = new ClangCommentToken(par);
        } else if (node.getName().equals("label")) {
            token = new ClangLabelToken(par);
        } else if (node.getName().equals("field")) {
            token = new ClangFieldToken(par);
        }
        XmlElement end = parser.end(node);
        if (token != null) {
            ((ClangToken)token).restoreFromXML(node, end, pfactory);
        }
        return token;
    }

    public static int getColor(String col) {
        if (col != null) {
            if (col.equals("keyword")) {
                return 0;
            }
            if (col.equals("var")) {
                return 4;
            }
            if (col.equals("const")) {
                return 5;
            }
            if (col.equals("param")) {
                return 6;
            }
            if (col.equals("global")) {
                return 7;
            }
            if (col.equals("type")) {
                return 1;
            }
            if (col.equals("comment")) {
                return 3;
            }
            if (col.equals("funcname")) {
                return 2;
            }
        }
        return 8;
    }

    public static ClangToken buildSpacer(ClangNode par, int indent, String indentStr) {
        Object spacing = new String();
        for (int i = 0; i < indent; ++i) {
            spacing = (String)spacing + indentStr;
        }
        return new ClangSyntaxToken(par, (String)spacing);
    }

    public String toString() {
        return this.text;
    }

    public HighVariable getHighVariable() {
        if (this.Parent() instanceof ClangVariableDecl) {
            return ((ClangVariableDecl)this.Parent()).getHighVariable();
        }
        return null;
    }

    public Varnode getVarnode() {
        return null;
    }

    public PcodeOp getPcodeOp() {
        return null;
    }
}

