/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;

public class RetypeFieldAction
extends AbstractDecompilerAction {
    public RetypeFieldAction() {
        super("Retype Field");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionRetypeField"));
        this.setPopupMenuData(new MenuData(new String[]{"Retype Field"}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData(76, 128));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = context.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return false;
        }
        if (tokenAtCursor instanceof ClangFieldToken) {
            Structure dt = RetypeFieldAction.getStructDataType(tokenAtCursor);
            return dt != null;
        }
        return false;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        DataType originalType;
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        Structure struct = RetypeFieldAction.getStructDataType(tokenAtCursor);
        if (struct == null) {
            Msg.showError((Object)((Object)this), null, (String)"Retype Failed", (Object)"Failed to retype structure field");
            return;
        }
        int offset = ((ClangFieldToken)tokenAtCursor).getOffset();
        if (offset < 0 || offset >= struct.getLength()) {
            Msg.showError((Object)((Object)this), null, (String)"Retype Failed", (Object)("Failed to retype structure field at offset " + offset + ": " + struct.getName()));
            return;
        }
        DataTypeComponent comp = struct.getComponentContaining(offset);
        if (comp != null && comp.getOffset() != offset) {
            Msg.showError((Object)((Object)this), null, (String)"Retype Failed", (Object)"Retype offset does not correspond to start of field");
            return;
        }
        DataType dataType = originalType = comp != null ? comp.getDataType() : DataType.DEFAULT;
        if (originalType instanceof BitFieldDataType) {
            Msg.showError((Object)((Object)this), null, (String)"Retype Failed", (Object)"Retype of defind bit-field is not supported.");
            return;
        }
        Program program = context.getProgram();
        DataType newType = this.chooseDataType(context.getTool(), program, originalType);
        if (newType == null || newType.isEquivalent(originalType)) {
            return;
        }
        if (newType instanceof FactoryDataType || newType.getLength() <= 0) {
            Msg.showError((Object)((Object)this), null, (String)"Retype Failed", (Object)("Failed to retype structure field '" + newType.getName() + "' - data type is not allowed."));
            return;
        }
        this.replaceType(program, struct, offset, comp, originalType, newType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceType(Program program, Structure struct, int offset, DataTypeComponent comp, DataType originalType, DataType newType) {
        int transaction = program.startTransaction("Retype Structure Field");
        try {
            int nextOffset;
            ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
            newType = dtm.resolve(newType, null);
            int newDtLength = newType.getLength();
            if (DataTypeComponent.usesZeroLengthComponent((DataType)newType)) {
                Msg.showError((Object)((Object)this), null, (String)"Retype Failed", (Object)("Failed to retype structure field '" + newType.getName() + "' - zero-length component is not allowed."));
                return;
            }
            String fieldName = null;
            String comment = null;
            if (comp == null) {
                nextOffset = offset + 1;
            } else {
                fieldName = comp.getFieldName();
                comment = comp.getComment();
                nextOffset = comp.getEndOffset() + 1;
            }
            if (originalType != DataType.DEFAULT && newDtLength == originalType.getLength()) {
                struct.replace(comp.getOrdinal(), newType, -1, fieldName, comment);
                return;
            }
            int available = nextOffset - offset;
            if (newDtLength > available) {
                int endOffset;
                DataTypeComponent nextComp = struct.getDefinedComponentAtOrAfterOffset(nextOffset);
                int n = endOffset = nextComp == null ? struct.getLength() : nextComp.getOffset();
                if (newDtLength > (available += endOffset - nextOffset)) {
                    Msg.showError((Object)((Object)this), null, (String)"Retype Failed", (Object)("Failed to retype structure field in '" + struct.getName() + "' - datatype will not fit"));
                    return;
                }
            }
            if (!this.verifyPacking(struct, offset, comp, newType)) {
                return;
            }
            struct.replaceAtOffset(offset, newType, -1, fieldName, comment);
        }
        catch (IllegalArgumentException e) {
            Msg.showError((Object)((Object)this), null, (String)"Retype Failed", (Object)("Failed to retype structure field in '" + struct.getName() + "':" + e.getMessage()), (Throwable)e);
        }
        finally {
            program.endTransaction(transaction, true);
        }
    }

    private boolean verifyPacking(Structure struct, int offset, DataTypeComponent comp, DataType dataType) {
        if (!struct.isPackingEnabled()) {
            return true;
        }
        if (this.isAlignmentMaintained(comp, dataType, offset)) {
            return true;
        }
        int choice = OptionDialog.showOptionDialogWithCancelAsDefaultButton(null, (String)"Disable Structure Packing", (String)"Containing structure currently has packing enabled.  Packing will be disabled if you continue.", (String)"Continue", (int)2);
        if (choice != 1) {
            return false;
        }
        int alignment = struct.getAlignment();
        struct.setPackingEnabled(false);
        struct.setExplicitMinimumAlignment(alignment);
        return true;
    }

    private boolean isAlignmentMaintained(DataTypeComponent comp, DataType dataType, int offset) {
        if (comp == null) {
            return false;
        }
        int align = comp.getDataType().getAlignment();
        if (align != dataType.getAlignment()) {
            return false;
        }
        return offset % align == 0;
    }
}

