/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.KeyBindingPrecedence;
import docking.Tool;
import docking.action.DockingActionIf;
import docking.actions.KeyBindingUtils;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public abstract class DockingKeyBindingAction
extends AbstractAction {
    private DockingActionIf docakbleAction;
    protected final KeyStroke keyStroke;
    protected final Tool tool;

    public DockingKeyBindingAction(Tool tool, DockingActionIf action, KeyStroke keyStroke) {
        super(KeyBindingUtils.parseKeyStroke(keyStroke));
        this.tool = tool;
        this.docakbleAction = action;
        this.keyStroke = keyStroke;
    }

    KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public abstract KeyBindingPrecedence getKeyBindingPrecedence();

    public boolean isReservedKeybindingPrecedence() {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.tool.setStatusInfo("");
        ComponentProvider provider = this.tool.getActiveComponentProvider();
        ActionContext context = this.getLocalContext(provider);
        context.setSourceObject(e.getSource());
        this.docakbleAction.actionPerformed(context);
    }

    protected ActionContext getLocalContext(ComponentProvider localProvider) {
        if (localProvider == null) {
            return new ActionContext();
        }
        ActionContext actionContext = localProvider.getActionContext(null);
        if (actionContext != null) {
            return actionContext;
        }
        return new ActionContext(localProvider, null);
    }
}

