/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.AbstractErrDialog;
import docking.ErrorReporter;
import docking.widgets.ScrollableTextArea;
import docking.widgets.label.GHtmlLabel;
import docking.widgets.label.GIconLabel;
import docking.widgets.table.AbstractDynamicTableColumnStub;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableFilterPanel;
import docking.widgets.table.TableColumnDescriptor;
import generic.json.Json;
import generic.util.WindowUtilities;
import ghidra.docking.settings.Settings;
import ghidra.framework.Application;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.ServiceProviderStub;
import ghidra.util.HTMLUtilities;
import ghidra.util.Swing;
import ghidra.util.table.column.DefaultTimestampRenderer;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import utilities.util.reflection.ReflectionUtilities;

public class ErrLogDialog
extends AbstractErrDialog {
    private static final int TEXT_ROWS = 20;
    private static final int TEXT_COLUMNS = 80;
    private static final String SEND = "Log Error...";
    private static final String DETAIL = "Details >>>";
    private static final String CLOSE = "<<< Close";
    private static final String EOL = "\n";
    private static final String SEPARATOR_LINE = "---------------------------------------------------";
    private static boolean isShowingDetails = false;
    private int errorId = 0;
    private ErrorDetailsSplitPane detailsPane;
    private JButton detailsButton;
    private JButton sendButton;
    private JPanel mainPanel;
    private static ErrorReporter errorReporter;
    private List<ErrorEntry> errors = new ArrayList<ErrorEntry>();
    private String baseTitle = this.getTitle();

    public static ErrLogDialog createExceptionDialog(String title, String message, Throwable t) {
        return new ErrLogDialog(title, message, t);
    }

    private ErrLogDialog(String title, String message, Throwable throwable) {
        super(title != null ? title : "Error");
        ErrorEntry error = new ErrorEntry(message, throwable);
        this.errors.add(error);
        this.setRememberSize(false);
        this.setRememberLocation(false);
        this.buildMainPanel(message);
    }

    private String addUsefulReportingInfo(String details) {
        StringBuilder sb = new StringBuilder(details);
        sb.append(EOL);
        sb.append(SEPARATOR_LINE);
        sb.append(EOL);
        sb.append("Build Date: ");
        sb.append(Application.getBuildDate());
        sb.append(EOL);
        sb.append(Application.getName());
        sb.append(" Version: ");
        sb.append(Application.getApplicationVersion());
        sb.append(EOL);
        sb.append("Java Home: ");
        sb.append(System.getProperty("java.home"));
        sb.append(EOL);
        sb.append("JVM Version: ");
        sb.append(System.getProperty("java.vendor"));
        sb.append(" ");
        sb.append(System.getProperty("java.version"));
        sb.append(EOL);
        sb.append("OS: ");
        sb.append(System.getProperty("os.name"));
        sb.append(" ");
        sb.append(System.getProperty("os.version"));
        sb.append(" ");
        sb.append(System.getProperty("os.arch"));
        sb.append(EOL);
        String hostname = this.getHostnameString();
        if (hostname != null) {
            sb.append(hostname);
            sb.append(EOL);
        }
        return sb.toString();
    }

    private String getHostnameString() {
        String name = null;
        Map<String, String> env = System.getenv();
        if (env.containsKey("COMPUTERNAME")) {
            name = env.get("COMPUTERNAME");
        } else if (env.containsKey("HOSTNAME")) {
            name = env.get("HOSTNAME");
        }
        if (name == null) {
            return null;
        }
        return "Workstation: " + name;
    }

    public static void setErrorReporter(ErrorReporter errorReporter) {
        ErrLogDialog.errorReporter = errorReporter;
    }

    public static ErrorReporter getErrorReporter() {
        return errorReporter;
    }

    private void buildMainPanel(String message) {
        JPanel introPanel = new JPanel(new BorderLayout(10, 10));
        introPanel.add((Component)new GIconLabel(UIManager.getIcon("OptionPane.errorIcon"), 4), "West");
        String html = HTMLUtilities.toHTML((String)message);
        introPanel.add((Component)new GHtmlLabel(html){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width = 300;
                return size;
            }
        }, "Center");
        this.mainPanel = new JPanel(new BorderLayout(10, 20));
        this.mainPanel.add((Component)introPanel, "North");
        this.sendButton = new JButton(SEND);
        this.sendButton.addActionListener(e -> this.sendDetails());
        this.detailsButton = new JButton(isShowingDetails ? CLOSE : DETAIL);
        this.detailsButton.addActionListener(e -> {
            String label = this.detailsButton.getText();
            this.showDetails(label.equals(DETAIL));
        });
        this.detailsPane = new ErrorDetailsSplitPane();
        JPanel sideButtonPanel = new JPanel(new FlowLayout(3, 5, 5));
        sideButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (errorReporter != null) {
            sideButtonPanel.add(this.sendButton);
        }
        sideButtonPanel.add(this.detailsButton);
        introPanel.add((Component)sideButtonPanel, "East");
        this.mainPanel.add((Component)this.detailsPane, "Center");
        this.addWorkPanel(this.mainPanel);
        this.addOKButton();
        this.setDefaultButton(this.okButton);
        this.detailsPane.setVisible(isShowingDetails);
        this.detailsPane.selectFirstError();
    }

    @Override
    protected void cancelCallback() {
        this.close();
    }

    @Override
    protected void okCallback() {
        this.cancelCallback();
    }

    private void sendDetails() {
        String details = this.detailsPane.getDetails();
        String title = this.getTitle();
        this.close();
        errorReporter.report(this.rootPanel, title, details);
    }

    private void showDetails(boolean visible) {
        isShowingDetails = visible;
        String label = visible ? CLOSE : DETAIL;
        this.detailsButton.setText(label);
        this.detailsPane.setVisible(visible);
        this.repack();
    }

    @Override
    public String getMessage() {
        return this.detailsPane.getMessage();
    }

    @Override
    protected void dialogShown() {
        WindowUtilities.ensureOnScreen((Component)this.getDialog());
        Swing.runLater(() -> this.okButton.requestFocusInWindow());
    }

    @Override
    void addException(String message, Throwable t) {
        int n = this.errors.size();
        if (n > 100) {
            return;
        }
        this.errors.add(new ErrorEntry(message, t));
        this.detailsPane.update();
        this.updateTitle();
    }

    @Override
    int getExceptionCount() {
        return this.errors.size();
    }

    @Override
    String getBaseTitle() {
        return this.baseTitle;
    }

    private class ErrEntryTableModel
    extends GDynamicColumnTableModel<ErrorEntry, Object> {
        public ErrEntryTableModel() {
            super((ServiceProvider)new ServiceProviderStub());
        }

        @Override
        protected TableColumnDescriptor<ErrorEntry> createTableColumnDescriptor() {
            TableColumnDescriptor<ErrorEntry> descriptor = new TableColumnDescriptor<ErrorEntry>();
            descriptor.addVisibleColumn(new IdColumn(), 1, true);
            descriptor.addVisibleColumn(new MessageColumn());
            descriptor.addHiddenColumn(new DetailsColumn());
            descriptor.addVisibleColumn(new TimestampColumn());
            return descriptor;
        }

        @Override
        public String getName() {
            return "Unexpectd Errors";
        }

        @Override
        public List<ErrorEntry> getModelData() {
            return ErrLogDialog.this.errors;
        }

        @Override
        public Object getDataSource() {
            return null;
        }

        private class TimestampColumn
        extends AbstractDynamicTableColumnStub<ErrorEntry, Date> {
            private GColumnRenderer<Date> renderer = new DefaultTimestampRenderer();

            private TimestampColumn() {
            }

            @Override
            public Date getValue(ErrorEntry rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
                return rowObject.getTimestamp();
            }

            @Override
            public String getColumnName() {
                return "Time";
            }

            @Override
            public GColumnRenderer<Date> getColumnRenderer() {
                return this.renderer;
            }
        }

        private class DetailsColumn
        extends AbstractDynamicTableColumnStub<ErrorEntry, String> {
            private DetailsColumn() {
            }

            @Override
            public String getValue(ErrorEntry rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
                return rowObject.getDetails();
            }

            @Override
            public String getColumnName() {
                return "Details";
            }
        }

        private class MessageColumn
        extends AbstractDynamicTableColumnStub<ErrorEntry, String> {
            private MessageColumn() {
            }

            @Override
            public String getValue(ErrorEntry rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
                return rowObject.getMessage();
            }

            @Override
            public String getColumnName() {
                return "Message";
            }
        }

        private class IdColumn
        extends AbstractDynamicTableColumnStub<ErrorEntry, Integer> {
            private IdColumn() {
            }

            @Override
            public Integer getValue(ErrorEntry rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
                return rowObject.getId();
            }

            @Override
            public String getColumnName() {
                return "#";
            }

            @Override
            public int getColumnPreferredWidth() {
                return 40;
            }
        }
    }

    private class ErrorEntry {
        private String message;
        private String details;
        private Date timestamp = new Date();
        private int myId;

        ErrorEntry(String message, Throwable t) {
            this.myId = ++ErrLogDialog.this.errorId;
            String updated = message;
            if (HTMLUtilities.isHTML((String)updated)) {
                updated = HTMLUtilities.fromHTML((String)updated);
            }
            this.message = updated;
            if (t != null) {
                this.details = ReflectionUtilities.stackTraceToString((Throwable)t);
            }
        }

        int getId() {
            return this.myId;
        }

        String getMessage() {
            return this.message;
        }

        Date getTimestamp() {
            return this.timestamp;
        }

        String getDetailsText() {
            if (this.details == null) {
                return this.message;
            }
            return this.details;
        }

        String getDetails() {
            return this.details;
        }

        public String toString() {
            return Json.toString((Object)this);
        }
    }

    private class ErrorDetailsPanel
    extends JPanel {
        private ScrollableTextArea textDetails;
        private ErrorEntry error;

        private ErrorDetailsPanel() {
            super(new BorderLayout(0, 0));
            this.textDetails = new ScrollableTextArea(20, 80);
            this.textDetails.setEditable(false);
            this.add((Component)this.textDetails, "Center");
            this.validate();
            this.textDetails.scrollToBottom();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.width = Math.min(size.width, 1000);
            return size;
        }

        void setError(ErrorEntry e) {
            this.error = e;
            this.setExceptionMessage(e.getDetailsText());
        }

        private void setExceptionMessage(String message) {
            String updated = ErrLogDialog.this.addUsefulReportingInfo(message);
            this.textDetails.setText(updated);
            this.textDetails.scrollToTop();
        }

        String getDetails() {
            return this.textDetails.getText();
        }

        String getMessage() {
            return this.error.getMessage();
        }
    }

    private class ErrorDetailsTablePanel
    extends JPanel {
        private ErrEntryTableModel model;
        private GTable errorsTable;
        private GTableFilterPanel<ErrorEntry> tableFilterPanel;

        ErrorDetailsTablePanel() {
            this.setLayout(new BorderLayout());
            this.model = new ErrEntryTableModel();
            this.errorsTable = new GTable(this.model);
            this.tableFilterPanel = new GTableFilterPanel<ErrorEntry>(this.errorsTable, this.model);
            this.errorsTable.getSelectionManager().addListSelectionListener(e -> {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int firstIndex = this.errorsTable.getSelectedRow();
                if (firstIndex == -1) {
                    return;
                }
                ErrorEntry err = this.tableFilterPanel.getRowObject(firstIndex);
                ErrLogDialog.this.detailsPane.setError(err);
            });
            JPanel tablePanel = new JPanel(new BorderLayout());
            tablePanel.add((Component)new JScrollPane(this.errorsTable), "Center");
            tablePanel.add(this.tableFilterPanel, "South");
            this.add((Component)tablePanel, "Center");
            this.setPreferredSize(new Dimension(400, 100));
        }

        void selectFirstError() {
            this.errorsTable.selectRow(0);
        }

        void update() {
            this.model.fireTableDataChanged();
        }
    }

    private class ErrorDetailsSplitPane
    extends JSplitPane {
        private final double TOP_PREFERRED_RESIZE_WEIGHT = 0.8;
        private ErrorDetailsPanel detailsPanel;
        private ErrorDetailsTablePanel tablePanel;
        private Dimension openedSize;

        ErrorDetailsSplitPane() {
            super(0);
            this.TOP_PREFERRED_RESIZE_WEIGHT = 0.8;
            this.setResizeWeight(0.8);
            this.detailsPanel = new ErrorDetailsPanel();
            this.tablePanel = new ErrorDetailsTablePanel();
            this.setTopComponent(this.detailsPanel);
            this.setBottomComponent(this.tablePanel);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent event) {
                    if (!ErrorDetailsSplitPane.this.isShowing()) {
                        return;
                    }
                    Rectangle localBounds = ErrorDetailsSplitPane.this.getBounds();
                    if (!ErrLogDialog.this.detailsButton.getText().equals(ErrLogDialog.DETAIL)) {
                        ErrorDetailsSplitPane.this.openedSize = new Dimension(localBounds.width, localBounds.height);
                    }
                }
            });
        }

        void selectFirstError() {
            this.tablePanel.selectFirstError();
        }

        String getDetails() {
            return this.detailsPanel.getDetails();
        }

        String getMessage() {
            return this.detailsPanel.getMessage();
        }

        void setError(ErrorEntry err) {
            this.detailsPanel.setError(err);
        }

        void update() {
            this.tablePanel.update();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension superSize = super.getPreferredSize();
            if (ErrLogDialog.this.detailsButton.getText().equals(ErrLogDialog.DETAIL)) {
                return superSize;
            }
            if (this.openedSize == null) {
                return superSize;
            }
            return this.openedSize;
        }
    }
}

