/*
 * Decompiled with CFR 0.152.
 */
package docking.menu;

import docking.util.GraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;

public class DockingMenuItemUI
extends MenuItemUI {
    private static final String TABULATOR_PROPERTIES = "menuItemTabulator";
    private static final int COLUMN_PADDING = 20;
    protected MenuItemUI ui;

    public static ComponentUI createUI(JComponent c) {
        DockingMenuItemUI result = new DockingMenuItemUI();
        result.ui = (MenuItemUI)UIManager.getDefaults().getUI(c);
        return result;
    }

    @Override
    public void installUI(JComponent c) {
        this.ui.installUI(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.ui.uninstallUI(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (((JMenuItem)c).getText().indexOf(9) != -1) {
            MenuTabulator tabulator = MenuTabulator.get((JMenuItem)c);
            SwitchGraphics2D sg = new SwitchGraphics2D((Graphics2D)g);
            sg.setDoText(false);
            this.ui.paint(sg, c);
            this.paintText(sg, (JMenuItem)c, tabulator);
        } else {
            this.ui.paint(g, c);
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (((JMenuItem)c).getText().indexOf(9) != -1) {
            MenuTabulator tabulator = MenuTabulator.get((JMenuItem)c);
            SwitchGraphics2D sg = new SwitchGraphics2D((Graphics2D)g);
            sg.setDoText(false);
            this.ui.update(sg, c);
            this.paintText(sg, (JMenuItem)c, tabulator);
        } else {
            this.ui.update(g, c);
        }
    }

    public void paintText(SwitchGraphics2D sg, JMenuItem c, MenuTabulator t) {
        SwitchGraphics2D sg2 = (SwitchGraphics2D)sg.create();
        sg2.setDoDraw(false);
        sg2.setDoFill(false);
        sg2.setDoText(true);
        sg2.setDoImage(false);
        Icon origIcon = c.getIcon();
        int iconWidth = 0;
        if (origIcon != null) {
            iconWidth = origIcon.getIconWidth();
        }
        String origText = c.getText();
        KeyStroke origAcc = c.getAccelerator();
        String[] parts = origText.split("\t");
        for (int i = 0; i < parts.length; ++i) {
            c.setText(parts[i]);
            this.ui.paint(sg2, c);
            sg2.translate(iconWidth + t.columns.get(i) + 20, 0);
            iconWidth = 0;
            c.setIcon(null);
            c.setAccelerator(null);
        }
        c.setIcon(origIcon);
        c.setText(origText);
        c.setAccelerator(origAcc);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension uiPref = this.ui.getPreferredSize(c);
        String text = ((JMenuItem)c).getText();
        if (text.indexOf(9) == -1) {
            return uiPref;
        }
        int extra = uiPref.width - DockingMenuItemUI.textWidth(c, text);
        MenuTabulator tabulator = MenuTabulator.tabulate((JMenuItem)c);
        return new Dimension(tabulator.getWidth() + extra, uiPref.height);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.ui.getMinimumSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.ui.getMaximumSize(c);
    }

    private static int textWidth(JComponent c, String text) {
        return GraphicsUtils.stringWidth(c, c.getFontMetrics(c.getFont()), text);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return this.ui.contains(c, x, y);
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        return this.ui.getBaseline(c, width, height);
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent c) {
        return this.ui.getBaselineResizeBehavior(c);
    }

    @Override
    public int getAccessibleChildrenCount(JComponent c) {
        return this.ui.getAccessibleChildrenCount(c);
    }

    @Override
    public Accessible getAccessibleChild(JComponent c, int i) {
        return this.ui.getAccessibleChild(c, i);
    }

    public static class SwitchGraphics2D
    extends Graphics2D {
        protected boolean doDraw = true;
        protected boolean doFill = true;
        protected boolean doText = true;
        protected boolean doImage = true;
        protected Graphics2D g;

        public SwitchGraphics2D(Graphics2D g) {
            this.g = g;
        }

        public void setDoDraw(boolean doDraw) {
            this.doDraw = doDraw;
        }

        public void setDoFill(boolean doFill) {
            this.doFill = doFill;
        }

        public void setDoText(boolean doText) {
            this.doText = doText;
        }

        public void setDoImage(boolean doImage) {
            this.doImage = doImage;
        }

        @Override
        public Graphics create() {
            return new SwitchGraphics2D((Graphics2D)this.g.create());
        }

        @Override
        public Graphics create(int x, int y, int width, int height) {
            return new SwitchGraphics2D((Graphics2D)this.g.create(x, y, width, height));
        }

        @Override
        public void drawLine(int x1, int y1, int x2, int y2) {
            if (this.doDraw) {
                this.g.drawLine(x1, y1, x2, y2);
            }
        }

        @Override
        public void fillRect(int x, int y, int width, int height) {
            if (this.doFill) {
                this.g.fillRect(x, y, width, height);
            }
        }

        @Override
        public void clearRect(int x, int y, int width, int height) {
            if (this.doFill) {
                this.g.clearRect(x, y, width, height);
            }
        }

        @Override
        public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
            if (this.doDraw) {
                this.g.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
            }
        }

        @Override
        public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
            if (this.doFill) {
                this.g.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
            }
        }

        @Override
        public void drawOval(int x, int y, int width, int height) {
            if (this.doDraw) {
                this.g.drawOval(x, y, width, height);
            }
        }

        @Override
        public void fillOval(int x, int y, int width, int height) {
            if (this.doFill) {
                this.g.fillOval(x, y, width, height);
            }
        }

        @Override
        public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
            if (this.doDraw) {
                this.g.drawArc(x, y, width, height, startAngle, arcAngle);
            }
        }

        @Override
        public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
            if (this.doFill) {
                this.g.fillArc(x, y, width, height, startAngle, arcAngle);
            }
        }

        @Override
        public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
            if (this.doDraw) {
                this.g.drawPolyline(xPoints, yPoints, nPoints);
            }
        }

        @Override
        public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
            if (this.doDraw) {
                this.g.drawPolygon(xPoints, yPoints, nPoints);
            }
        }

        @Override
        public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
            if (this.doFill) {
                this.g.fillPolygon(xPoints, yPoints, nPoints);
            }
        }

        @Override
        public void drawString(String str, int x, int y) {
            if (this.doText) {
                this.g.drawString(str, x, y);
            }
        }

        @Override
        public void drawString(AttributedCharacterIterator iterator, int x, int y) {
            if (this.doText) {
                this.g.drawString(iterator, x, y);
            }
        }

        @Override
        public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
            if (this.doImage) {
                return this.g.drawImage(img, x, y, observer);
            }
            return true;
        }

        @Override
        public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
            if (this.doImage) {
                return this.g.drawImage(img, x, y, width, height, observer);
            }
            return true;
        }

        @Override
        public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
            if (this.doImage) {
                return this.g.drawImage(img, x, y, bgcolor, observer);
            }
            return true;
        }

        @Override
        public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
            if (this.doImage) {
                return this.g.drawImage(img, x, y, width, height, bgcolor, observer);
            }
            return true;
        }

        @Override
        public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
            if (this.doImage) {
                return this.g.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
            }
            return true;
        }

        @Override
        public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
            if (this.doImage) {
                return this.g.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
            }
            return true;
        }

        @Override
        public void translate(int x, int y) {
            this.g.translate(x, y);
        }

        @Override
        public Color getColor() {
            return this.g.getColor();
        }

        @Override
        public void setColor(Color c) {
            this.g.setColor(c);
        }

        @Override
        public void setPaintMode() {
            this.g.setPaintMode();
        }

        @Override
        public void setXORMode(Color c1) {
            this.g.setXORMode(c1);
        }

        @Override
        public Font getFont() {
            return this.g.getFont();
        }

        @Override
        public void setFont(Font font) {
            this.g.setFont(font);
        }

        @Override
        public FontMetrics getFontMetrics(Font f) {
            return this.g.getFontMetrics(f);
        }

        @Override
        public Rectangle getClipBounds() {
            return this.g.getClipBounds();
        }

        @Override
        public void clipRect(int x, int y, int width, int height) {
            this.g.clipRect(x, y, width, height);
        }

        @Override
        public void setClip(int x, int y, int width, int height) {
            this.g.setClip(x, y, width, height);
        }

        @Override
        public Shape getClip() {
            return this.g.getClip();
        }

        @Override
        public void setClip(Shape clip) {
            this.g.setClip(clip);
        }

        @Override
        public void copyArea(int x, int y, int width, int height, int dx, int dy) {
            this.g.copyArea(x, y, width, height, dx, dy);
        }

        @Override
        public void dispose() {
        }

        @Override
        public void draw(Shape s) {
            if (this.doDraw) {
                this.g.draw(s);
            }
        }

        @Override
        public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
            if (this.doImage) {
                return this.g.drawImage(img, xform, obs);
            }
            return true;
        }

        @Override
        public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
            if (this.doImage) {
                this.g.drawImage(img, op, x, y);
            }
        }

        @Override
        public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
            if (this.doImage) {
                this.g.drawRenderedImage(img, xform);
            }
        }

        @Override
        public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
            if (this.doImage) {
                this.g.drawRenderableImage(img, xform);
            }
        }

        @Override
        public void drawString(String str, float x, float y) {
            if (this.doText) {
                this.g.drawString(str, x, y);
            }
        }

        @Override
        public void drawString(AttributedCharacterIterator iterator, float x, float y) {
            if (this.doText) {
                this.g.drawString(iterator, x, y);
            }
        }

        @Override
        public void drawGlyphVector(GlyphVector gv, float x, float y) {
            if (this.doText) {
                this.g.drawGlyphVector(gv, x, y);
            }
        }

        @Override
        public void fill(Shape s) {
            if (this.doFill) {
                this.g.fill(s);
            }
        }

        @Override
        public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
            return this.g.hit(rect, s, onStroke);
        }

        @Override
        public GraphicsConfiguration getDeviceConfiguration() {
            return this.g.getDeviceConfiguration();
        }

        @Override
        public void setComposite(Composite comp) {
            this.g.setComposite(comp);
        }

        @Override
        public void setPaint(Paint paint) {
            this.g.setPaint(paint);
        }

        @Override
        public void setStroke(Stroke s) {
            this.g.setStroke(s);
        }

        @Override
        public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
            this.g.setRenderingHint(hintKey, hintValue);
        }

        @Override
        public Object getRenderingHint(RenderingHints.Key hintKey) {
            return this.g.getRenderingHint(hintKey);
        }

        @Override
        public void setRenderingHints(Map<?, ?> hints) {
            this.g.setRenderingHints(hints);
        }

        @Override
        public void addRenderingHints(Map<?, ?> hints) {
            this.g.addRenderingHints(hints);
        }

        @Override
        public RenderingHints getRenderingHints() {
            return this.g.getRenderingHints();
        }

        @Override
        public void translate(double tx, double ty) {
            this.g.translate(tx, ty);
        }

        @Override
        public void rotate(double theta) {
            this.g.rotate(theta);
        }

        @Override
        public void rotate(double theta, double x, double y) {
            this.g.rotate(theta, x, y);
        }

        @Override
        public void scale(double sx, double sy) {
            this.g.scale(sx, sy);
        }

        @Override
        public void shear(double shx, double shy) {
            this.g.shear(shx, shy);
        }

        @Override
        public void transform(AffineTransform Tx) {
            this.g.transform(Tx);
        }

        @Override
        public void setTransform(AffineTransform Tx) {
            this.g.setTransform(Tx);
        }

        @Override
        public AffineTransform getTransform() {
            return this.g.getTransform();
        }

        @Override
        public Paint getPaint() {
            return this.g.getPaint();
        }

        @Override
        public Composite getComposite() {
            return this.g.getComposite();
        }

        @Override
        public void setBackground(Color color) {
            this.g.setBackground(color);
        }

        @Override
        public Color getBackground() {
            return this.g.getBackground();
        }

        @Override
        public Stroke getStroke() {
            return this.g.getStroke();
        }

        @Override
        public void clip(Shape s) {
            this.g.clip(s);
        }

        @Override
        public FontRenderContext getFontRenderContext() {
            return this.g.getFontRenderContext();
        }
    }

    public static class MenuTabulator {
        private ArrayList<Integer> columns = new ArrayList();

        public static MenuTabulator tabulate(JMenuItem c) {
            MenuTabulator tabulator = MenuTabulator.get(c);
            if (tabulator == null) {
                tabulator = new MenuTabulator();
                JComponent p = (JComponent)c.getParent();
                p.putClientProperty(DockingMenuItemUI.TABULATOR_PROPERTIES, tabulator);
            }
            tabulator.tabulate(c, c.getText());
            return tabulator;
        }

        public static MenuTabulator get(JMenuItem c) {
            JComponent p = (JComponent)c.getParent();
            return (MenuTabulator)p.getClientProperty(DockingMenuItemUI.TABULATOR_PROPERTIES);
        }

        public void tabulate(JComponent c, String tabularText) {
            String[] parts = tabularText.split("\t");
            for (int i = 0; i < parts.length; ++i) {
                int candWidth = DockingMenuItemUI.textWidth(c, parts[i]);
                if (i < this.columns.size()) {
                    int width = this.columns.get(i);
                    this.columns.set(i, Math.max(width, candWidth));
                    continue;
                }
                this.columns.add(candWidth);
            }
        }

        public int getWidth() {
            int total = 0;
            for (Integer i : this.columns) {
                total += i.intValue();
            }
            return total += (this.columns.size() - 1) * 20;
        }
    }
}

