/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.DialogRememberOption;
import docking.widgets.MultiLineLabel;
import docking.widgets.OptionDialogBuilder;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.dialogs.InputDialog;
import docking.widgets.dialogs.InputWithChoicesDialog;
import docking.widgets.dialogs.MultiLineInputDialog;
import docking.widgets.label.GHtmlLabel;
import docking.widgets.label.GIconLabel;
import ghidra.util.HTMLUtilities;
import ghidra.util.Swing;
import ghidra.util.exception.AssertException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class OptionDialog
extends DialogComponentProvider {
    public static final String MESSAGE_COMPONENT_NAME = "MESSAGE-COMPONENT";
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;
    public static final int CANCEL_OPTION = 0;
    public static final int YES_OPTION = 1;
    public static final int NO_OPTION = 2;
    public static final int OPTION_ONE = 1;
    public static final int OPTION_TWO = 2;
    public static final int OPTION_THREE = 3;
    private int result = 0;
    private DialogRememberOption rememberOption;
    private JCheckBox rememberOptionCheckBox;
    private String dialogMessage;

    protected OptionDialog(String title, String message, int messageType, Icon icon) {
        this(title, message, null, null, messageType, icon, false, null);
    }

    protected OptionDialog(String title, String message, String option1, String option2, int messageType, Icon icon, boolean addCancel) {
        super(title, true, false, true, false);
        this.setTransient(true);
        this.buildMainPanel(message, messageType, icon, null);
        this.buildButtons(OptionDialog.toList(option1, option2), addCancel, null);
    }

    protected OptionDialog(String title, String message, String option1, String option2, int messageType, Icon icon, boolean addCancel, String defaultButtonName) {
        super(title, true, false, true, false);
        this.setTransient(true);
        this.buildMainPanel(message, messageType, icon, null);
        this.buildButtons(OptionDialog.toList(option1, option2), addCancel, defaultButtonName);
    }

    protected OptionDialog(String title, String message, String option1, int messageType, Icon icon) {
        this(title, message, option1, null, messageType, icon, true, null);
    }

    protected OptionDialog(String title, String message, String option1, int messageType, Icon icon, String defaultButtonName) {
        this(title, message, option1, null, messageType, icon, true, defaultButtonName);
    }

    protected OptionDialog(String title, String message, String option1, String option2, String option3, int messageType, Icon icon, boolean addCancel) {
        super(title, true, false, true, false);
        this.setTransient(true);
        this.buildMainPanel(message, messageType, icon, null);
        this.buildButtons(OptionDialog.toList(option1, option2, option3), addCancel, null);
    }

    OptionDialog(String title, String message, int messageType, Icon icon, boolean addCancelButton, DialogRememberOption savedDialogChoice, List<String> options, String defaultOption) {
        super(title, true, false, true, false);
        this.setTransient(true);
        this.buildMainPanel(message, messageType, icon, savedDialogChoice);
        this.buildButtons(options, addCancelButton, defaultOption);
    }

    private static List<String> toList(String ... option) {
        ArrayList<String> options = new ArrayList<String>();
        for (String string : option) {
            if (string == null) continue;
            options.add(string);
        }
        return options;
    }

    private void buildMainPanel(String message, int messageType, Icon icon, DialogRememberOption rememberOptionChoice) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel messagePanel = this.buildMessagePanel(message, messageType, icon);
        panel.add((Component)messagePanel, "Center");
        JPanel savedDialogChoicePanel = this.buildRememberOptionChoicePanel(rememberOptionChoice);
        if (savedDialogChoicePanel != null) {
            panel.add((Component)savedDialogChoicePanel, "South");
        }
        this.addWorkPanel(panel);
        this.setRememberLocation(false);
        this.setRememberSize(false);
    }

    private JPanel buildRememberOptionChoicePanel(DialogRememberOption rememberOptionChoice) {
        if (rememberOptionChoice == null) {
            this.rememberOption = new DoNothingDialogRememberOption();
            this.rememberOptionCheckBox = new GCheckBox();
            return null;
        }
        this.rememberOption = rememberOptionChoice;
        this.rememberOptionCheckBox = new GCheckBox(rememberOptionChoice.getDescription());
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        panel.add((Component)this.rememberOptionCheckBox, "South");
        return panel;
    }

    private JPanel buildMessagePanel(String message, int messageType, Icon icon) {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel textPanel = this.createTextPanel(message);
        textPanel.setMaximumSize(textPanel.getPreferredSize());
        panel.add((Component)new GIconLabel(icon == null ? OptionDialog.getIconForMessageType(messageType) : icon), "West");
        panel.add((Component)textPanel, "Center");
        return panel;
    }

    private void buildButtons(List<String> options, boolean addCancel, String defaultButtonName) {
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        for (String option : options) {
            JButton button = this.createOptionButton(option, buttons.size() + 1);
            button.setName(option);
            this.addButton(button);
            buttons.add(button);
        }
        if (options.size() == 0) {
            JButton button = this.createOptionButton("OK", 1);
            button.setName("OK");
            this.addButton(button);
            buttons.add(button);
        }
        if (addCancel) {
            this.addCancelButton();
            buttons.add(this.cancelButton);
            if (options.size() == 1 && options.get(0).equals("Yes")) {
                this.setCancelButtonText("No");
            }
        }
        this.initializeDefaultButton(defaultButtonName, buttons);
    }

    private void initializeDefaultButton(String defaultButtonName, List<JButton> buttons) {
        if (buttons.isEmpty()) {
            return;
        }
        if (defaultButtonName == null) {
            this.setFocusComponent(buttons.get(0));
            this.setDefaultButton(buttons.get(0));
            return;
        }
        for (JButton jButton : buttons) {
            if (!defaultButtonName.equals(jButton.getText())) continue;
            this.setFocusComponent(jButton);
            this.setDefaultButton(jButton);
            return;
        }
        throw new AssertException("No button exists to make default for name: " + defaultButtonName);
    }

    private JButton createOptionButton(String optionName, int callbackValue) {
        int ampLoc = ((String)optionName).indexOf(38);
        char mnemonicKey = '\u0000';
        if (ampLoc >= 0 && ampLoc < ((String)optionName).length() - 1) {
            mnemonicKey = ((String)optionName).charAt(ampLoc + 1);
            optionName = ((String)optionName).substring(0, ampLoc) + ((String)optionName).substring(ampLoc + 1);
        }
        JButton button = new JButton((String)optionName);
        if (mnemonicKey != '\u0000') {
            button.setMnemonic(mnemonicKey);
        }
        button.addActionListener(ev -> {
            this.result = callbackValue;
            this.okCallback();
        });
        return button;
    }

    protected JPanel createTextPanel(String message) {
        this.dialogMessage = message;
        if (HTMLUtilities.isHTML((String)this.dialogMessage)) {
            GHtmlLabel messageLabel = new GHtmlLabel(this.dialogMessage);
            messageLabel.setName(MESSAGE_COMPONENT_NAME);
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            panel.add(messageLabel);
            return panel;
        }
        MultiLineLabel label = new MultiLineLabel(this.dialogMessage);
        label.setName(MESSAGE_COMPONENT_NAME);
        return label;
    }

    public String getMessage() {
        return this.dialogMessage;
    }

    public int show() {
        return this.show(null);
    }

    public int show(Component parent) {
        if (this.rememberOption.hasRememberedResult()) {
            this.result = this.rememberOption.getRememberedResult();
            return this.result;
        }
        DockingWindowManager.showDialog(parent, this);
        return this.result;
    }

    public static OptionDialogBuilder createBuilder(String title, String message) {
        return new OptionDialogBuilder(title, message);
    }

    public static int showOptionDialog(Component parent, String title, String message, String option1) {
        return OptionDialog.showOptionDialog(parent, title, message, option1, -1);
    }

    public static int showOptionDialogWithCancelAsDefaultButton(Component parent, String title, String message, String option1) {
        return (Integer)Swing.runNow(() -> {
            OptionDialog info = new OptionDialog(title, message, option1, 3, null, "Cancel");
            return info.show(parent);
        });
    }

    public static int showOptionDialogWithCancelAsDefaultButton(Component parent, String title, String message, String option1, int messageType) {
        String defaultButton = option1.equals("Yes") ? "No" : "Cancel";
        return (Integer)Swing.runNow(() -> {
            OptionDialog info = new OptionDialog(title, message, option1, messageType, null, defaultButton);
            return info.show(parent);
        });
    }

    public static int showOptionDialog(Component parent, String title, String message, String option1, int messageType) {
        return (Integer)Swing.runNow(() -> {
            OptionDialog info = new OptionDialog(title, message, option1, messageType, null);
            return info.show(parent);
        });
    }

    public static int showOptionDialog(Component parent, String title, String message, String option1, int messageType, String defaultButtonName) {
        return (Integer)Swing.runNow(() -> {
            OptionDialog info = new OptionDialog(title, message, option1, messageType, null, defaultButtonName);
            return info.show(parent);
        });
    }

    public static int showOptionDialog(Component parent, String title, String message, String option1, Icon icon) {
        return (Integer)Swing.runNow(() -> {
            OptionDialog info = new OptionDialog(title, message, option1, -1, icon);
            return info.show(parent);
        });
    }

    public static int showOptionDialog(Component parent, String title, String message, String option1, String option2, String option3, int messageType) {
        return (Integer)Swing.runNow(() -> {
            OptionDialog dialog = new OptionDialog(title, message, option1, option2, option3, messageType, null, true);
            return dialog.show(parent);
        });
    }

    public static int showOptionDialog(Component parent, String title, String message, String option1, String option2) {
        return OptionDialog.showOptionDialog(parent, title, message, option1, option2, -1);
    }

    public static int showOptionDialog(Component parent, String title, String message, String option1, String option2, int messageType) {
        return (Integer)Swing.runNow(() -> {
            OptionDialog info = new OptionDialog(title, message, option1, option2, messageType, null, true);
            return info.show(parent);
        });
    }

    public static int showOptionDialog(Component parent, String title, String message, String option1, String option2, Icon icon) {
        return (Integer)Swing.runNow(() -> {
            OptionDialog info = new OptionDialog(title, message, option1, option2, -1, icon, true);
            return info.show(parent);
        });
    }

    public static int showOptionNoCancelDialog(Component parent, String title, String message, String option1, String option2, int messageType) {
        return (Integer)Swing.runNow(() -> {
            OptionDialog info = new OptionDialog(title, message, option1, option2, messageType, null, false);
            return info.show(parent);
        });
    }

    public static int showOptionNoCancelDialog(Component parent, String title, String message, String option1, String option2, Icon icon) {
        return (Integer)Swing.runNow(() -> {
            OptionDialog info = new OptionDialog(title, message, option1, option2, -1, icon, false);
            return info.show();
        });
    }

    public static int showOptionNoCancelDialog(Component parent, String title, String message, String option1, String option2, String option3, int messageType) {
        return (Integer)Swing.runNow(() -> {
            OptionDialog info = new OptionDialog(title, message, option1, option2, option3, messageType, null, false);
            return info.show();
        });
    }

    public static int showYesNoDialog(Component parent, String title, String message) {
        return OptionDialog.showOptionNoCancelDialog(parent, title, message, "&Yes", "&No", 3);
    }

    public static int showYesNoDialogWithNoAsDefaultButton(Component parent, String title, String message) {
        return (Integer)Swing.runNow(() -> {
            OptionDialog info = new OptionDialog(title, message, "&Yes", "&No", 3, null, false, "No");
            return info.show(parent);
        });
    }

    public static int showYesNoCancelDialog(Component parent, String title, String message) {
        return OptionDialog.showOptionDialog(parent, title, message, "&Yes", "&No", 3);
    }

    public static String showInputSingleLineDialog(Component parent, String title, String label, String initialValue) {
        return (String)Swing.runNow(() -> {
            InputDialog dialog = new InputDialog(title, label, initialValue, true);
            dialog.setRememberLocation(false);
            dialog.setRememberSize(false);
            DockingWindowManager.showDialog(parent, dialog);
            if (dialog.isCanceled()) {
                return null;
            }
            return dialog.getValue();
        });
    }

    public static String showInputMultilineDialog(Component parent, String title, String label, String initialValue) {
        return (String)Swing.runNow(() -> {
            Icon icon = OptionDialog.getIconForMessageType(3);
            MultiLineInputDialog dialog = new MultiLineInputDialog(title, label, initialValue, icon);
            DockingWindowManager.showDialog(parent, dialog);
            if (dialog.isCanceled()) {
                return null;
            }
            return dialog.getValue();
        });
    }

    public static String showInputChoiceDialog(Component parent, String title, String label, String[] selectableValues, String initialValue, int messageType) {
        return (String)Swing.runNow(() -> {
            Icon icon = OptionDialog.getIconForMessageType(messageType);
            InputWithChoicesDialog dialog = new InputWithChoicesDialog(title, label, selectableValues, initialValue, icon);
            DockingWindowManager.showDialog(parent, dialog);
            if (dialog.isCanceled()) {
                return null;
            }
            return dialog.getValue();
        });
    }

    public static String showEditableInputChoiceDialog(Component parent, String title, String label, String[] selectableValues, String initialValue, int messageType) {
        Icon icon = OptionDialog.getIconForMessageType(messageType);
        return (String)Swing.runNow(() -> {
            InputWithChoicesDialog dialog = new InputWithChoicesDialog(title, label, selectableValues, initialValue, true, icon);
            DockingWindowManager.showDialog(parent, dialog);
            if (dialog.isCanceled()) {
                return null;
            }
            return dialog.getValue();
        });
    }

    public final int getResult() {
        return this.result;
    }

    @Override
    protected void okCallback() {
        if (this.rememberOptionCheckBox.isSelected()) {
            this.rememberOption.rememberResult(this.result);
        }
        this.close();
    }

    @Override
    protected void cancelCallback() {
        this.result = 0;
        this.okCallback();
    }

    public static Icon getIconForMessageType(int messageType) {
        switch (messageType) {
            case -1: {
                return null;
            }
            case 0: {
                return UIManager.getIcon("OptionPane.errorIcon");
            }
            case 1: {
                return UIManager.getIcon("OptionPane.informationIcon");
            }
            case 2: {
                return UIManager.getIcon("OptionPane.warningIcon");
            }
            case 3: {
                return UIManager.getIcon("OptionPane.questionIcon");
            }
        }
        throw new IllegalArgumentException("Invalid message type given in OptionDialog.getIconForMessageType()");
    }

    private static class DoNothingDialogRememberOption
    extends DialogRememberOption {
        public DoNothingDialogRememberOption() {
            super(null);
        }

        @Override
        public void rememberResult(int rememberedResult) {
            throw new UnsupportedOperationException("Can't rememberResult in dummy class");
        }
    }
}

