/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint;

import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.StringColumnConstraint;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class StringMatcherColumnConstraint
extends StringColumnConstraint {
    public StringMatcherColumnConstraint(String spec) {
        super(spec, "Please enter a regular expression.");
    }

    @Override
    public String getName() {
        return "Matches Regex";
    }

    @Override
    public ColumnConstraint<String> copy(String newPatternString) {
        return new StringMatcherColumnConstraint(newPatternString);
    }

    @Override
    protected Pattern generateMatchesPattern(String patternString) {
        return Pattern.compile("^" + patternString.trim() + "$");
    }

    @Override
    public boolean isValidPatternString(String value) {
        if (!super.isValidPatternString(value)) {
            return false;
        }
        try {
            Pattern.compile(value);
            return true;
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    @Override
    protected Pattern generateFindsPattern() {
        return Pattern.compile("(.*)");
    }
}

