/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint.provider;

import docking.widgets.table.constraint.AtLeastColumnConstraint;
import docking.widgets.table.constraint.AtMostColumnConstraint;
import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.ColumnConstraintProvider;
import docking.widgets.table.constraint.ColumnData;
import docking.widgets.table.constraint.InRangeColumnConstraint;
import docking.widgets.table.constraint.NotInRangeColumnConstraint;
import docking.widgets.table.constraint.provider.EditorProvider;
import docking.widgets.table.constraint.provider.IntegerEditorProvider;
import docking.widgets.table.constraint.provider.IntegerRangeEditorProvider;
import docking.widgets.table.constraint.provider.LongEditorProvider;
import docking.widgets.table.constraint.provider.LongRangeEditorProvider;
import docking.widgets.table.constrainteditor.ColumnConstraintEditor;
import docking.widgets.table.constrainteditor.DoubleRangeConstraintEditor;
import docking.widgets.table.constrainteditor.DoubleValueConstraintEditor;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;

public class NumberColumnConstraintProvider
implements ColumnConstraintProvider {
    @Override
    public Collection<ColumnConstraint<?>> getColumnConstraints() {
        ArrayList list = new ArrayList();
        list.add(new AtLeastColumnConstraint<Byte>((byte)0, new ByteEditorProvider()));
        list.add(new AtLeastColumnConstraint<Short>((short)0, new ShortEditorProvider()));
        list.add(new AtLeastColumnConstraint<Integer>(0, new IntEditorProvider()));
        list.add(new AtLeastColumnConstraint<Long>(0L, new LongEditorProvider()));
        list.add(new AtLeastColumnConstraint<Double>(0.0, new FloatingEditorProvider()));
        list.add(new AtMostColumnConstraint<Byte>((byte)0, new ByteEditorProvider()));
        list.add(new AtMostColumnConstraint<Short>((short)0, new ShortEditorProvider()));
        list.add(new AtMostColumnConstraint<Integer>(0, new IntEditorProvider()));
        list.add(new AtMostColumnConstraint<Long>(0L, new LongEditorProvider()));
        list.add(new AtMostColumnConstraint<Double>(0.0, new FloatingEditorProvider()));
        list.add(new InRangeColumnConstraint<Byte>((byte)0, (byte)0, new ByteRangeEditorProvider()));
        list.add(new InRangeColumnConstraint<Short>((short)0, (short)0, new ShortRangeEditorProvider()));
        list.add(new InRangeColumnConstraint<Integer>(0, 0, new IntRangeEditorProvider()));
        list.add(new InRangeColumnConstraint<Long>(0L, 0L, new LongRangeEditorProvider()));
        list.add(new InRangeColumnConstraint<Double>(0.0, 0.0, new FloatingRangeEditorProvider()));
        list.add(new NotInRangeColumnConstraint<Byte>((byte)0, (byte)0, new ByteRangeEditorProvider()));
        list.add(new NotInRangeColumnConstraint<Short>((short)0, (short)0, new ShortRangeEditorProvider()));
        list.add(new NotInRangeColumnConstraint<Integer>(0, 0, new IntRangeEditorProvider()));
        list.add(new NotInRangeColumnConstraint<Long>(0L, 0L, new LongRangeEditorProvider()));
        list.add(new NotInRangeColumnConstraint<Double>(0.0, 0.0, new FloatingRangeEditorProvider()));
        return list;
    }

    static class FloatingRangeEditorProvider
    implements EditorProvider<Double> {
        FloatingRangeEditorProvider() {
        }

        @Override
        public ColumnConstraintEditor<Double> getEditor(ColumnConstraint<Double> columnConstraint, ColumnData<Double> columnDataSource) {
            return new DoubleRangeConstraintEditor(columnConstraint);
        }

        @Override
        public Double parseValue(String value, Object dataSource) {
            return Double.parseDouble(value);
        }

        @Override
        public String toString(Double value) {
            return new DecimalFormat("0.##########;-0.##########").format(value);
        }
    }

    static class FloatingEditorProvider
    implements EditorProvider<Double> {
        FloatingEditorProvider() {
        }

        @Override
        public ColumnConstraintEditor<Double> getEditor(ColumnConstraint<Double> columnConstraint, ColumnData<Double> columnDataSource) {
            return new DoubleValueConstraintEditor(columnConstraint);
        }

        @Override
        public Double parseValue(String value, Object dataSource) {
            return Double.parseDouble(value);
        }

        @Override
        public String toString(Double value) {
            return new DecimalFormat("0.##########;-0.##########").format(value);
        }
    }

    static class IntRangeEditorProvider
    extends IntegerRangeEditorProvider<Integer> {
        public IntRangeEditorProvider() {
            super(v -> (int)v);
        }
    }

    static class ShortRangeEditorProvider
    extends IntegerRangeEditorProvider<Short> {
        public ShortRangeEditorProvider() {
            super(v -> (short)v);
        }
    }

    static class ByteRangeEditorProvider
    extends IntegerRangeEditorProvider<Byte> {
        public ByteRangeEditorProvider() {
            super(v -> (byte)v);
        }
    }

    static class IntEditorProvider
    extends IntegerEditorProvider<Integer> {
        public IntEditorProvider() {
            super(v -> (int)v);
        }
    }

    static class ShortEditorProvider
    extends IntegerEditorProvider<Short> {
        public ShortEditorProvider() {
            super(v -> (short)v);
        }
    }

    static class ByteEditorProvider
    extends IntegerEditorProvider<Byte> {
        ByteEditorProvider() {
            super(v -> (byte)v);
        }
    }
}

