/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.textfield;

import ghidra.util.NumericUtilities;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class GValidatedTextField
extends JTextField {
    public GValidatedTextField(List<TextValidator> validators, String value, int columns) {
        super(new ValidatedDocument(validators), value, columns);
    }

    public GValidatedTextField(String value, int columns) {
        this((List<TextValidator>)null, value, columns);
    }

    public void addValidator(TextValidator validator) {
        ValidatedDocument d = (ValidatedDocument)this.getDocument();
        d.addValidator(validator);
    }

    public void removeValidator(TextValidator validator) {
        ValidatedDocument d = (ValidatedDocument)this.getDocument();
        d.removeValidator(validator);
    }

    public void addValidationMessageListener(ValidationMessageListener listener) {
        ValidatedDocument d = (ValidatedDocument)this.getDocument();
        d.addValidationMessageListener(listener);
    }

    public void removeValidationMessageListener(ValidationMessageListener listener) {
        ValidatedDocument d = (ValidatedDocument)this.getDocument();
        d.removeValidationMessageListener(listener);
    }

    public static class MaxLengthField
    extends GValidatedTextField {
        public MaxLengthField(List<TextValidator> validators, String value, int columns) {
            super(validators, value, columns);
            this.setDocument(new MaxLengthDocument(validators));
        }

        public MaxLengthField(String value, int columns) {
            this((List<TextValidator>)null, value, columns);
        }

        public MaxLengthField(int columns) {
            this((List<TextValidator>)null, (String)null, columns);
        }

        protected class MaxLengthDocument
        extends ValidatedDocument {
            public MaxLengthDocument(List<TextValidator> validators) {
                super(validators);
            }

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (str == null) {
                    return;
                }
                int oldLength = this.getLength();
                int max = MaxLengthField.this.getColumns();
                if (oldLength + str.length() > max) {
                    this.toolkit.beep();
                    this.message("Exceeded " + max + " characters.");
                    str = str.substring(0, max - oldLength);
                }
                super.insertString(offs, str, a);
            }
        }
    }

    public static class LongField
    extends GValidatedTextField {
        public LongField(List<TextValidator> validators, String value, int columns) {
            super(validators, value, columns);
            boolean hasLongValidator = false;
            if (validators != null) {
                for (TextValidator v : validators) {
                    if (!(v instanceof LongValidator)) continue;
                    hasLongValidator = true;
                }
            }
            if (!hasLongValidator) {
                this.addValidator(new LongValidator());
            }
        }

        public LongField(String value, int columns) {
            this((List<TextValidator>)null, value, columns);
        }

        public LongField(String value) {
            this((List<TextValidator>)null, value, 0);
        }

        public LongField(int columns) {
            this((List<TextValidator>)null, "0", columns);
        }

        public long getValue() {
            return NumericUtilities.parseLong((String)this.getText());
        }

        public static class LongValidator
        implements TextValidator {
            @Override
            public void validate(String oldText, String newText) throws ValidationFailedException {
                try {
                    long oldLong = NumericUtilities.parseLong((String)oldText);
                    long newLong = NumericUtilities.parseLong((String)newText);
                    this.validateLong(oldLong, newLong);
                }
                catch (NumberFormatException e) {
                    throw new ValidationFailedException(e);
                }
            }

            public void validateLong(long oldLong, long newLong) throws ValidationFailedException {
            }
        }
    }

    public static class ValidationFailedException
    extends Exception {
        public ValidationFailedException(String msg) {
            super(msg);
        }

        public ValidationFailedException(Throwable cause) {
            super(cause.getMessage(), cause);
        }

        public ValidationFailedException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    public static interface ValidationMessageListener {
        public void message(String var1);
    }

    public static interface TextValidator {
        public void validate(String var1, String var2) throws ValidationFailedException;
    }

    public static class ValidatedDocument
    extends PlainDocument {
        protected Toolkit toolkit = Toolkit.getDefaultToolkit();
        private List<TextValidator> validators = new ArrayList<TextValidator>();
        private List<ValidationMessageListener> listeners = new ArrayList<ValidationMessageListener>();

        public ValidatedDocument(List<TextValidator> validators) {
            if (validators != null) {
                this.validators.addAll(validators);
            }
        }

        public ValidatedDocument() {
            this((List<TextValidator>)null);
        }

        public void addValidator(TextValidator validator) {
            this.validators.add(0, validator);
        }

        public void removeValidator(TextValidator validator) {
            this.validators.remove(validator);
        }

        public void addValidationMessageListener(ValidationMessageListener listener) {
            this.listeners.add(listener);
        }

        public void removeValidationMessageListener(ValidationMessageListener listener) {
            this.listeners.add(listener);
        }

        protected void validate(String oldText, String newText) throws ValidationFailedException {
            for (TextValidator v : this.validators) {
                v.validate(oldText, newText);
            }
        }

        protected void message(String msg) {
            for (ValidationMessageListener l : this.listeners) {
                l.message(msg);
            }
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            String oldText = this.getText(0, this.getLength());
            String newText = oldText.substring(0, offs) + str + oldText.substring(offs);
            try {
                this.validate(oldText, newText);
                super.insertString(offs, str, a);
                this.message("");
            }
            catch (ValidationFailedException e) {
                this.message(e.getMessage());
                this.toolkit.beep();
            }
        }
    }
}

