/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.tasks;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeTask;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.UnknownProgressWrappingTaskMonitor;
import java.util.List;
import javax.swing.tree.TreePath;

public class GTreeCollapseAllTask
extends GTreeTask {
    private final GTreeNode root;

    public GTreeCollapseAllTask(GTree tree, GTreeNode node) {
        super(tree);
        this.root = node;
    }

    public void run(TaskMonitor monitor) {
        int max = 100;
        UnknownProgressWrappingTaskMonitor monitorWrapper = new UnknownProgressWrappingTaskMonitor(monitor, (long)max);
        monitorWrapper.initialize((long)max);
        monitorWrapper.setMessage("Collapsing nodes...");
        try {
            this.collapseNode(this.root, (TaskMonitor)monitorWrapper);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    protected void collapseNode(GTreeNode node, TaskMonitor monitor) throws CancelledException {
        if (node.isLeaf()) {
            return;
        }
        monitor.checkCanceled();
        List<GTreeNode> allChildren = node.getChildren();
        if (allChildren.size() == 0) {
            return;
        }
        TreePath treePath = node.getTreePath();
        if (this.jTree.isExpanded(treePath)) {
            this.collapsePath(treePath, monitor);
        }
        for (GTreeNode child : allChildren) {
            monitor.checkCanceled();
            this.collapseNode(child, monitor);
        }
        monitor.incrementProgress(1L);
    }

    private void collapsePath(TreePath treePath, TaskMonitor monitor) {
        this.runOnSwingThread(() -> {
            if (monitor.isCancelled()) {
                return;
            }
            this.jTree.collapsePath(treePath);
        });
    }
}

