/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import SWIG.SBCommandReturnObject;
import SWIG.SBDebugger;
import agent.lldb.lldb.DebugClientImpl;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.cmd.LldbPendingCommand;
import agent.lldb.manager.impl.LldbManagerImpl;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class LldbListAvailableProcessesCommand
extends AbstractLldbCommand<List<Pair<String, String>>> {
    private String output;

    public LldbListAvailableProcessesCommand(LldbManagerImpl manager) {
        super(manager);
    }

    @Override
    public List<Pair<String, String>> complete(LldbPendingCommand<?> pending) {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        String[] lines = this.output.split("\n");
        for (int i = 3; i < lines.length; ++i) {
            String[] fields = lines[i].split("\\s+");
            try {
                result.add((Pair<String, String>)new ImmutablePair((Object)fields[0], (Object)fields[fields.length - 1]));
                continue;
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)e.getMessage());
            }
        }
        return result;
    }

    @Override
    public void invoke() {
        DebugClientImpl client = (DebugClientImpl)this.manager.getClient();
        SBDebugger sbd = client.getDebugger();
        SBCommandReturnObject obj = new SBCommandReturnObject();
        sbd.GetCommandInterpreter().HandleCommand("platform process list", obj);
        this.output = obj.GetOutput();
    }
}

