/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.generic;

import ghidra.app.plugin.processors.generic.BinaryExpression;
import ghidra.app.plugin.processors.generic.ExpressionValue;
import ghidra.app.plugin.processors.generic.Offset;
import ghidra.app.plugin.processors.generic.Operand;
import ghidra.app.plugin.processors.generic.SledException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.mem.MemBuffer;
import java.io.Serializable;
import java.util.Hashtable;

public class ExpressionTerm
implements Serializable {
    private ExpressionValue val;
    private Offset offset;

    public ExpressionTerm(ExpressionValue v, Offset off) {
        this.val = v;
        this.offset = off;
    }

    public long longValue(MemBuffer buf, int off) throws Exception {
        return this.val.longValue(buf, this.offset.getOffset(buf, off));
    }

    public int length(MemBuffer buf, int off) throws Exception {
        int o = this.offset.getOffset(buf, off);
        return o - off + this.val.length(buf, o);
    }

    public void linkRelativeOffsets(Hashtable<String, Operand> opHash) {
        if (this.val.getClass() == BinaryExpression.class) {
            ((BinaryExpression)this.val).linkRelativeOffsets(opHash);
        } else {
            this.offset.setRelativeOffset(opHash);
        }
    }

    public ExpressionValue getValue() {
        return this.val;
    }

    public void setSpace(AddressSpace space) throws SledException {
        if (this.val.getClass() != BinaryExpression.class) {
            throw new SledException("Can't add space to an ExpressionTerm that does not contain a BinaryExpression");
        }
        ((BinaryExpression)this.val).setSpace(space);
    }
}

