/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.opbehavior;

import ghidra.pcode.opbehavior.BinaryOpBehavior;
import ghidra.pcode.utils.Utils;
import java.math.BigInteger;

public class OpBehaviorIntLessEqual
extends BinaryOpBehavior {
    public OpBehaviorIntLessEqual() {
        super(16);
    }

    @Override
    public long evaluateBinary(int sizeout, int sizein, long in1, long in2) {
        long res;
        if (sizein <= 0) {
            res = 0L;
        } else {
            long mask = Utils.calc_mask(sizein);
            if ((in1 &= mask) == (in2 &= mask)) {
                res = 1L;
            } else if (sizein < 8) {
                res = in1 < in2 ? 1L : 0L;
            } else {
                long bit2;
                mask = 128L;
                long bit1 = in1 & (mask <<= 8 * (sizein - 1));
                res = bit1 != (bit2 = in2 & mask) ? (bit1 != 0L ? 0L : 1L) : (in1 < in2 ? 1L : 0L);
            }
        }
        return res;
    }

    @Override
    public BigInteger evaluateBinary(int sizeout, int sizein, BigInteger in1, BigInteger in2) {
        BigInteger res = in1.compareTo(in2) <= 0 ? BigInteger.ONE : BigInteger.ZERO;
        return res;
    }
}

