/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import generic.stl.IteratorSTL;
import generic.stl.Pair;
import generic.stl.VectorSTL;
import ghidra.pcodeCPort.context.ParserWalker;
import ghidra.pcodeCPort.error.LowlevelError;
import ghidra.pcodeCPort.slghpattern.DisjointPattern;
import ghidra.pcodeCPort.slghsymbol.Constructor;
import ghidra.pcodeCPort.slghsymbol.DecisionProperties;
import ghidra.pcodeCPort.slghsymbol.SubtableSymbol;
import ghidra.pcodeCPort.translate.BadDataError;
import ghidra.pcodeCPort.utils.XmlUtils;
import java.io.PrintStream;
import java.util.List;
import org.jdom.Element;

public class DecisionNode {
    private VectorSTL<Pair<DisjointPattern, Constructor>> list = new VectorSTL();
    private VectorSTL<DecisionNode> children = new VectorSTL();
    private int num;
    private boolean contextdecision;
    private int startbit;
    private int bitsize;
    private DecisionNode parent;

    public DecisionNode() {
    }

    public DecisionNode(DecisionNode p) {
        this.parent = p;
        this.num = 0;
        this.startbit = 0;
        this.bitsize = 0;
        this.contextdecision = false;
    }

    public void dispose() {
        IteratorSTL iter = this.children.begin();
        while (!iter.isEnd()) {
            ((DecisionNode)iter.get()).dispose();
            iter.increment();
        }
        IteratorSTL piter = this.list.begin();
        while (!piter.isEnd()) {
            ((DisjointPattern)((Pair)piter.get()).first).dispose();
            piter.increment();
        }
    }

    public void addConstructorPair(DisjointPattern pat, Constructor ct) {
        DisjointPattern clone = (DisjointPattern)pat.simplifyClone();
        this.list.push_back((Object)new Pair((Object)clone, (Object)ct));
        ++this.num;
    }

    private int getMaximumLength(boolean context) {
        int max = 0;
        for (int i = 0; i < this.list.size(); ++i) {
            int val = ((DisjointPattern)((Pair)this.list.get((int)i)).first).getLength(context);
            if (val <= max) continue;
            max = val;
        }
        return max;
    }

    private int getNumFixed(int low, int size, boolean context) {
        int count = 0;
        long m = size == 64 ? 0L : 1L << size;
        --m;
        for (int i = 0; i < this.list.size(); ++i) {
            long mask = ((DisjointPattern)((Pair)this.list.get((int)i)).first).getMask(low, size, context);
            if ((mask & m) != m) continue;
            ++count;
        }
        return count;
    }

    private double getScore(int low, int size, boolean context) {
        int i;
        int numBins = 1 << size;
        long m = size == 64 ? 0L : 1L << size;
        --m;
        int total = 0;
        int[] count = new int[numBins];
        for (i = 0; i < this.list.size(); ++i) {
            long mask = ((DisjointPattern)((Pair)this.list.get((int)i)).first).getMask(low, size, context);
            if ((mask & m) != m) continue;
            int val = ((DisjointPattern)((Pair)this.list.get((int)i)).first).getValue(low, size, context);
            ++total;
            int n = val;
            count[n] = count[n] + 1;
        }
        if (total <= 0) {
            return -1.0;
        }
        double sc = 0.0;
        for (i = 0; i < numBins; ++i) {
            if (count[i] <= 0) continue;
            if (count[i] >= this.list.size()) {
                return -1.0;
            }
            double p = (double)count[i] / (double)total;
            sc -= p * Math.log(p);
        }
        return sc / Math.log(2.0);
    }

    private void chooseOptimalField() {
        double sc;
        int sbit;
        int maxlength;
        double score = 0.0;
        int maxfixed = 1;
        boolean context = true;
        do {
            maxlength = 8 * this.getMaximumLength(context);
            for (sbit = 0; sbit < maxlength; ++sbit) {
                int numfixed = this.getNumFixed(sbit, 1, context);
                if (numfixed < maxfixed) continue;
                sc = this.getScore(sbit, 1, context);
                if (numfixed > maxfixed && sc > 0.0) {
                    score = sc;
                    maxfixed = numfixed;
                    this.startbit = sbit;
                    this.bitsize = 1;
                    this.contextdecision = context;
                    continue;
                }
                if (!(sc > score)) continue;
                score = sc;
                this.startbit = sbit;
                this.bitsize = 1;
                this.contextdecision = context;
            }
        } while (!(context = !context));
        context = true;
        do {
            maxlength = 8 * this.getMaximumLength(context);
            for (int size = 2; size <= 8; ++size) {
                for (sbit = 0; sbit < maxlength - size + 1; ++sbit) {
                    if (this.getNumFixed(sbit, size, context) < maxfixed || !((sc = this.getScore(sbit, size, context)) > score)) continue;
                    score = sc;
                    this.startbit = sbit;
                    this.bitsize = size;
                    this.contextdecision = context;
                }
            }
        } while (!(context = !context));
        if (score <= 0.0) {
            this.bitsize = 0;
        }
    }

    private void consistentValues(VectorSTL<Integer> bins, DisjointPattern pat) {
        long m = this.bitsize == 32 ? 0L : (long)(1 << this.bitsize);
        int commonMask = (int)(--m & (long)pat.getMask(this.startbit, this.bitsize, this.contextdecision));
        int commonValue = commonMask & pat.getValue(this.startbit, this.bitsize, this.contextdecision);
        long dontCareMask = m ^ (long)commonMask;
        int i = 0;
        while ((long)i <= dontCareMask) {
            if (((long)i & dontCareMask) == (long)i) {
                bins.push_back((Object)(commonValue | i));
            }
            ++i;
        }
    }

    void split(DecisionProperties props) {
        int i;
        if (this.list.size() <= 1) {
            this.bitsize = 0;
            return;
        }
        this.chooseOptimalField();
        if (this.bitsize == 0) {
            this.orderPatterns(props);
            return;
        }
        if (this.parent != null && this.list.size() >= this.parent.num) {
            throw new LowlevelError("Child has as many Patterns as parent");
        }
        int numChildren = 1 << this.bitsize;
        for (i = 0; i < numChildren; ++i) {
            DecisionNode nd = new DecisionNode(this);
            this.children.push_back((Object)nd);
        }
        for (i = 0; i < this.list.size(); ++i) {
            VectorSTL vals = new VectorSTL();
            this.consistentValues((VectorSTL<Integer>)vals, (DisjointPattern)((Pair)this.list.get((int)i)).first);
            for (int j = 0; j < vals.size(); ++j) {
                ((DecisionNode)this.children.get(((Integer)vals.get(j)).intValue())).addConstructorPair((DisjointPattern)((Pair)this.list.get((int)i)).first, (Constructor)((Pair)this.list.get((int)i)).second);
            }
            ((DisjointPattern)((Pair)this.list.get((int)i)).first).dispose();
        }
        this.list.clear();
        for (i = 0; i < numChildren; ++i) {
            ((DecisionNode)this.children.get(i)).split(props);
        }
    }

    public void orderPatterns(DecisionProperties props) {
        DisjointPattern jpat;
        DisjointPattern ipat;
        int j;
        int i;
        VectorSTL newlist = this.list.copy();
        VectorSTL conflictlist = new VectorSTL();
        for (i = 0; i < this.list.size(); ++i) {
            for (j = 0; j < i; ++j) {
                ipat = (DisjointPattern)((Pair)this.list.get((int)i)).first;
                jpat = (DisjointPattern)((Pair)this.list.get((int)j)).first;
                if (!ipat.identical(jpat)) continue;
                props.identicalPattern((Constructor)((Pair)this.list.get((int)i)).second, (Constructor)((Pair)this.list.get((int)j)).second);
            }
        }
        for (i = 0; i < this.list.size(); ++i) {
            for (j = 0; j < i && !(ipat = (DisjointPattern)((Pair)newlist.get((int)i)).first).specializes(jpat = (DisjointPattern)((Pair)this.list.get((int)j)).first); ++j) {
                Constructor jconst;
                Constructor iconst;
                if (jpat.specializes(ipat) || (iconst = (Constructor)((Pair)newlist.get((int)i)).second).equals(jconst = (Constructor)((Pair)this.list.get((int)j)).second)) continue;
                conflictlist.push_back((Object)new Pair((Object)ipat, (Object)iconst));
                conflictlist.push_back((Object)new Pair((Object)jpat, (Object)jconst));
            }
            for (int k = i - 1; k >= j; --k) {
                this.list.set(k + 1, (Object)((Pair)this.list.get(k)));
            }
            this.list.set(j, (Object)((Pair)newlist.get(i)));
        }
        for (i = 0; i < conflictlist.size(); i += 2) {
            DisjointPattern pat1 = (DisjointPattern)((Pair)conflictlist.get((int)i)).first;
            Constructor const1 = (Constructor)((Pair)conflictlist.get((int)i)).second;
            DisjointPattern pat2 = (DisjointPattern)((Pair)conflictlist.get((int)(i + 1))).first;
            Constructor const2 = (Constructor)((Pair)conflictlist.get((int)(i + 1))).second;
            boolean resolved = false;
            for (j = 0; j < this.list.size(); ++j) {
                DisjointPattern tpat = (DisjointPattern)((Pair)this.list.get((int)j)).first;
                Constructor tconst = (Constructor)((Pair)this.list.get((int)j)).second;
                if (tpat.equals(pat1) && tconst.equals(const1) || tpat == pat2 && tconst == const2) break;
                if (!tpat.resolvesIntersect(pat1, pat2)) continue;
                resolved = true;
                break;
            }
            if (resolved) continue;
            props.conflictingPattern(pat1, const1, pat2, const2);
        }
    }

    Constructor resolve(ParserWalker pos) {
        if (this.bitsize == 0) {
            IteratorSTL iter = this.list.begin();
            while (!iter.isEnd()) {
                if (((DisjointPattern)((Pair)iter.get()).first).isMatch(pos)) {
                    return (Constructor)((Pair)iter.get()).second;
                }
                iter.increment();
            }
            throw new BadDataError(pos.getAddr().getShortcut() + pos.getAddr().toString() + ": Unable to resolve constructor");
        }
        int val = this.contextdecision ? pos.getContextBits(this.startbit, this.bitsize) : pos.getInstructionBits(this.startbit, this.bitsize);
        return ((DecisionNode)this.children.get(val)).resolve(pos);
    }

    void saveXml(PrintStream s) {
        int i;
        s.append("<decision");
        s.append(" number=\"");
        s.print(this.num);
        s.append("\"");
        s.append(" context=\"");
        if (this.contextdecision) {
            s.append("true\"");
        } else {
            s.append("false\"");
        }
        s.append(" start=\"");
        s.print(this.startbit);
        s.append("\"");
        s.append(" size=\"");
        s.print(this.bitsize);
        s.append("\"");
        s.append(">\n");
        for (i = 0; i < this.list.size(); ++i) {
            s.append("<pair id=\"");
            s.print(((Constructor)((Pair)this.list.get((int)i)).second).getId());
            s.append("\">\n");
            ((DisjointPattern)((Pair)this.list.get((int)i)).first).saveXml(s);
            s.append("</pair>\n");
        }
        for (i = 0; i < this.children.size(); ++i) {
            ((DecisionNode)this.children.get(i)).saveXml(s);
        }
        s.append("</decision>\n");
    }

    void restoreXml(Element el, DecisionNode par, SubtableSymbol sub) {
        this.parent = par;
        this.num = XmlUtils.decodeUnknownInt(el.getAttributeValue("number"));
        this.contextdecision = XmlUtils.decodeBoolean(el.getAttributeValue("context"));
        this.startbit = XmlUtils.decodeUnknownInt(el.getAttributeValue("start"));
        this.bitsize = XmlUtils.decodeUnknownInt(el.getAttributeValue("size"));
        List childlist = el.getChildren();
        for (Element child : childlist) {
            if (child.getName().equals("pair")) {
                int id = XmlUtils.decodeUnknownInt(child.getAttributeValue("id"));
                Constructor ct = sub.getConstructor(id);
                DisjointPattern pat = DisjointPattern.restoreDisjoint((Element)child.getChildren().get(0));
                this.list.push_back((Object)new Pair((Object)pat, (Object)ct));
                continue;
            }
            if (!child.getName().equals("decision")) continue;
            DecisionNode subnode = new DecisionNode();
            subnode.restoreXml(child, this, sub);
            this.children.push_back((Object)subnode);
        }
    }
}

