/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.Schema;
import ghidra.program.database.data.EnumDBAdapterNoTable;
import ghidra.program.database.data.EnumDBAdapterV0;
import ghidra.program.database.data.EnumDBAdapterV1;
import ghidra.util.UniversalID;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class EnumDBAdapter {
    static final String ENUM_TABLE_NAME = "Enumeration Data Types";
    static final Schema ENUM_SCHEMA = EnumDBAdapterV1.V1_ENUM_SCHEMA;
    static final int ENUM_NAME_COL = 0;
    static final int ENUM_COMMENT_COL = 1;
    static final int ENUM_CAT_COL = 2;
    static final int ENUM_SIZE_COL = 3;
    static final int ENUM_SOURCE_ARCHIVE_ID_COL = 4;
    static final int ENUM_UNIVERSAL_DT_ID_COL = 5;
    static final int ENUM_SOURCE_SYNC_TIME_COL = 6;
    static final int ENUM_LAST_CHANGE_TIME_COL = 7;

    EnumDBAdapter() {
    }

    static EnumDBAdapter getAdapter(DBHandle handle, int openMode, TaskMonitor monitor) throws VersionException, IOException {
        if (openMode == 0) {
            return new EnumDBAdapterV1(handle, true);
        }
        try {
            return new EnumDBAdapterV1(handle, false);
        }
        catch (VersionException e) {
            EnumDBAdapter adapter = EnumDBAdapter.findReadOnlyAdapter(handle);
            if (openMode == 3) {
                adapter = EnumDBAdapter.upgrade(handle, adapter);
            }
            return adapter;
        }
    }

    static EnumDBAdapter findReadOnlyAdapter(DBHandle handle) throws VersionException {
        try {
            return new EnumDBAdapterV0(handle);
        }
        catch (VersionException e) {
            if (!e.isUpgradable()) {
                throw e;
            }
            return new EnumDBAdapterNoTable(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EnumDBAdapter upgrade(DBHandle handle, EnumDBAdapter oldAdapter) throws VersionException, IOException {
        DBHandle tmpHandle = new DBHandle();
        long id = tmpHandle.startTransaction();
        EnumDBAdapterV1 tmpAdapter = null;
        try {
            tmpAdapter = new EnumDBAdapterV1(tmpHandle, true);
            RecordIterator it = oldAdapter.getRecords();
            while (it.hasNext()) {
                DBRecord rec = it.next();
                ((EnumDBAdapter)tmpAdapter).updateRecord(rec, false);
            }
            oldAdapter.deleteTable(handle);
            EnumDBAdapterV1 newAdapter = new EnumDBAdapterV1(handle, true);
            it = ((EnumDBAdapter)tmpAdapter).getRecords();
            while (it.hasNext()) {
                DBRecord rec = it.next();
                newAdapter.updateRecord(rec, false);
            }
            EnumDBAdapterV1 enumDBAdapterV1 = newAdapter;
            return enumDBAdapterV1;
        }
        finally {
            tmpHandle.endTransaction(id, true);
            tmpHandle.close();
        }
    }

    abstract DBRecord createRecord(String var1, String var2, long var3, byte var5, long var6, long var8, long var10) throws IOException;

    abstract DBRecord getRecord(long var1) throws IOException;

    abstract RecordIterator getRecords() throws IOException;

    abstract void updateRecord(DBRecord var1, boolean var2) throws IOException;

    abstract boolean removeRecord(long var1) throws IOException;

    abstract void deleteTable(DBHandle var1) throws IOException;

    abstract Field[] getRecordIdsInCategory(long var1) throws IOException;

    abstract Field[] getRecordIdsForSourceArchive(long var1) throws IOException;

    abstract DBRecord getRecordWithIDs(UniversalID var1, UniversalID var2) throws IOException;
}

