/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.IntField;
import db.LongField;
import db.RecordIterator;
import db.RecordTranslator;
import db.Schema;
import db.StringField;
import db.Table;
import db.TranslatedRecordIterator;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.FunctionParameterAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class FunctionParameterAdapterV0
extends FunctionParameterAdapter
implements RecordTranslator {
    static final int VERSION = 0;
    static final int V0_PARAMETER_PARENT_ID_COL = 0;
    static final int V0_PARAMETER_DT_ID_COL = 1;
    static final int V0_PARAMETER_NAME_COL = 2;
    static final int V0_PARAMETER_COMMENT_COL = 3;
    static final int V0_PARAMETER_ORDINAL_COL = 4;
    static final Schema V0_PARAMETER_SCHEMA = new Schema(0, "Parameter ID", new Field[]{LongField.INSTANCE, LongField.INSTANCE, StringField.INSTANCE, StringField.INSTANCE, IntField.INSTANCE}, new String[]{"Parent ID", "Data Type ID", "Name", "Comment", "Ordinal"});
    private Table parameterTable;

    public FunctionParameterAdapterV0(DBHandle handle) throws VersionException {
        this.parameterTable = handle.getTable("Function Parameters");
        if (this.parameterTable == null) {
            throw new VersionException(true);
        }
        int version = this.parameterTable.getSchema().getVersion();
        if (version != 0) {
            String msg = "Expected version 0 for table Function Parameters but got " + this.parameterTable.getSchema().getVersion();
            if (version < 0) {
                throw new VersionException(msg, 1, true);
            }
            throw new VersionException(msg, 2, false);
        }
    }

    @Override
    public DBRecord createRecord(long dataTypeID, long parentID, int ordinal, String name, String comment, int dtLength) throws IOException {
        long tableKey = this.parameterTable.getKey();
        long key = DataTypeManagerDB.createKey(7, tableKey);
        DBRecord record = V0_PARAMETER_SCHEMA.createRecord(key);
        record.setLongValue(0, parentID);
        record.setLongValue(1, dataTypeID);
        record.setString(2, name);
        record.setString(3, comment);
        record.setIntValue(4, ordinal);
        this.parameterTable.putRecord(record);
        return record;
    }

    @Override
    public DBRecord getRecord(long parameterID) throws IOException {
        return this.translateRecord(this.parameterTable.getRecord(parameterID));
    }

    @Override
    protected RecordIterator getRecords() throws IOException {
        return new TranslatedRecordIterator(this.parameterTable.iterator(), (RecordTranslator)this);
    }

    @Override
    public void updateRecord(DBRecord record) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeRecord(long parameterID) throws IOException {
        return false;
    }

    @Override
    protected void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable("Function Parameters");
    }

    @Override
    public Field[] getParameterIdsInFunctionDef(long functionDefID) throws IOException {
        return this.parameterTable.findRecords((Field)new LongField(functionDefID), 0);
    }

    public DBRecord translateRecord(DBRecord oldRec) {
        if (oldRec == null) {
            return null;
        }
        DBRecord rec = FunctionParameterAdapter.PARAMETER_SCHEMA.createRecord(oldRec.getKey());
        rec.setLongValue(0, oldRec.getLongValue(0));
        rec.setLongValue(1, oldRec.getLongValue(1));
        rec.setString(2, oldRec.getString(2));
        rec.setString(3, oldRec.getString(3));
        rec.setIntValue(4, oldRec.getIntValue(4));
        rec.setIntValue(5, 1);
        return rec;
    }
}

