/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressMapImpl;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.Mark;
import ghidra.util.datastruct.NoSuchIndexException;
import ghidra.util.prop.ObjectPropertySet;

public class AddressObjectMap {
    private AddressMapImpl addrMap = new AddressMapImpl();
    private ObjectPropertySet objMarkers = new ObjectPropertySet("AddressObjectMap");
    private static final Object[] emptyArray = new Object[0];

    public Object[] getObjects(Address addr) {
        Object[] objarray = this.getObj(this.addrMap.getKey(addr));
        return objarray;
    }

    public void addObject(Object obj, AddressSetView set) {
        AddressRangeIterator iter = set.getAddressRanges();
        while (iter.hasNext()) {
            AddressRange range = (AddressRange)iter.next();
            this.addObject(obj, range.getMinAddress(), range.getMaxAddress());
        }
    }

    public void addObject(Object obj, Address startAddr, Address endAddr) {
        long start = this.addrMap.getKey(startAddr);
        long end = this.addrMap.getKey(endAddr);
        this.addRange(obj, start, end);
        this.coalesceRange(start, end);
    }

    public void removeObject(Object obj, AddressSetView set) {
        AddressRangeIterator iter = set.getAddressRanges();
        while (iter.hasNext()) {
            AddressRange range = (AddressRange)iter.next();
            this.removeObject(obj, range.getMinAddress(), range.getMaxAddress());
        }
    }

    public void removeObject(Object obj, Address startAddr, Address endAddr) {
        long start = this.addrMap.getKey(startAddr);
        long end = this.addrMap.getKey(endAddr);
        this.removeRange(obj, start, end);
        this.coalesceRange(start, end);
    }

    private Object[] getObj(long longAddr) {
        Mark mark;
        if (this.objMarkers.hasProperty(longAddr)) {
            mark = this.getMark(longAddr);
        } else {
            try {
                long next = this.objMarkers.getNextPropertyIndex(longAddr);
                mark = this.getMark(next);
                if (mark.type == 1 || mark.type == 3) {
                    return emptyArray;
                }
            }
            catch (NoSuchIndexException e2) {
                return emptyArray;
            }
        }
        return mark.getObj();
    }

    private Mark getMark(long index) {
        return (Mark)this.objMarkers.getObject(index);
    }

    private void addRange(Object obj, long start, long end) {
        try {
            long next = this.objMarkers.hasProperty(start) ? start : this.objMarkers.getNextPropertyIndex(start);
            while (start <= end) {
                Mark mark = this.getMark(next);
                if (mark.type == 2) {
                    this.markEnd(start - 1L, mark.obj);
                    this.markStart(start, mark.obj);
                    next = start;
                    continue;
                }
                if (start == next) {
                    if (mark.type == 3) {
                        mark.add(obj);
                        ++start;
                    } else {
                        next = this.objMarkers.getNextPropertyIndex(next);
                        start = this.doSplit(obj, start, next, end) + 1L;
                    }
                    next = this.objMarkers.getNextPropertyIndex(next);
                    continue;
                }
                if (start < next && next <= end) {
                    this.markRange(start, next - 1L, obj);
                    start = next;
                    continue;
                }
                if (next <= end) continue;
                break;
            }
        }
        catch (NoSuchIndexException noSuchIndexException) {
            // empty catch block
        }
        if (start <= end) {
            this.markRange(start, end, obj);
        }
    }

    private void markRange(long start, long end, Object obj) {
        if (start == end) {
            this.objMarkers.putObject(start, (Object)new Mark(obj, 3));
        } else {
            this.objMarkers.putObject(start, (Object)new Mark(obj, 1));
            this.objMarkers.putObject(end, (Object)new Mark(obj, 2));
        }
    }

    private void markStart(long addr, Object obj) {
        Mark mark = this.getMark(addr);
        mark = mark != null && mark.type == 2 ? new Mark(obj, 3) : new Mark(obj, 1);
        this.objMarkers.putObject(addr, (Object)mark);
    }

    private void markEnd(long addr, Object obj) {
        Mark mark = this.getMark(addr);
        mark = mark != null && mark.type == 1 ? new Mark(obj, 3) : new Mark(obj, 2);
        this.objMarkers.putObject(addr, (Object)mark);
    }

    private long doSplit(Object obj, long start, long next, long end) {
        Mark existMark = this.getMark(start);
        if (next > end) {
            this.markStart(end + 1L, existMark.obj);
        }
        existMark.add(obj);
        long splitEnd = Math.min(next, end);
        this.markEnd(splitEnd, existMark.obj);
        return splitEnd;
    }

    private long doDeleteSplit(Object obj, long start, long next, long end) {
        Mark existMark = this.getMark(start);
        if (next > end) {
            this.markStart(end + 1L, existMark.obj);
            existMark.remove(obj);
            if (existMark.isEmpty()) {
                this.objMarkers.remove(start);
            } else {
                this.markEnd(end, existMark.obj);
            }
            return end;
        }
        existMark.remove(obj);
        if (existMark.isEmpty()) {
            this.objMarkers.remove(start);
            this.objMarkers.remove(next);
        } else {
            Mark endMark = this.getMark(next);
            endMark.remove(obj);
        }
        return next;
    }

    private void removeRange(Object obj, long start, long end) {
        try {
            long next = this.objMarkers.hasProperty(start) ? start : this.objMarkers.getNextPropertyIndex(start);
            while (start <= end) {
                Mark mark = this.getMark(next);
                if (mark.type == 2) {
                    if (mark.contains(obj)) {
                        this.markEnd(start - 1L, mark.obj);
                        this.markStart(start, mark.obj);
                        next = start;
                        continue;
                    }
                    start = next;
                    continue;
                }
                if (start == next) {
                    if (mark.type == 3) {
                        mark.remove(obj);
                        if (mark.isEmpty()) {
                            this.objMarkers.remove(start);
                        }
                        ++start;
                    } else if (mark.contains(obj)) {
                        next = this.objMarkers.getNextPropertyIndex(next);
                        start = this.doDeleteSplit(obj, start, next, end) + 1L;
                    }
                    next = this.objMarkers.getNextPropertyIndex(next);
                    continue;
                }
                if (start < next && next <= end) {
                    start = next;
                    continue;
                }
                if (next <= end) continue;
                break;
            }
        }
        catch (NoSuchIndexException noSuchIndexException) {
            // empty catch block
        }
    }

    private void coalesceRange(long start, long end) {
        try {
            while (start <= end) {
                this.coalesce(start);
                start = this.objMarkers.getNextPropertyIndex(start);
            }
        }
        catch (NoSuchIndexException noSuchIndexException) {
            // empty catch block
        }
    }

    private void coalesce(long addr) {
        if (addr > 0L) {
            this.checkCoalese(addr - 1L, addr);
        }
        if (addr < Long.MAX_VALUE) {
            this.checkCoalese(addr, addr + 1L);
        }
    }

    private void checkCoalese(long first, long second) {
        Mark fMark = this.getMark(first);
        Mark sMark = this.getMark(second);
        if (fMark == null || sMark == null) {
            return;
        }
        if (!fMark.containsSameObjects(sMark)) {
            return;
        }
        if (fMark.type == 2 && sMark.type == 1) {
            this.objMarkers.remove(first);
            this.objMarkers.remove(second);
        } else if (fMark.type == 2 && sMark.type == 3) {
            this.objMarkers.remove(first);
            this.objMarkers.putObject(second, (Object)fMark);
        } else if (fMark.type == 3 && sMark.type == 3) {
            this.objMarkers.putObject(first, (Object)new Mark(fMark.obj, 1));
            this.objMarkers.putObject(second, (Object)new Mark(fMark.obj, 2));
            this.markStart(first, fMark.obj);
            this.markEnd(second, fMark.obj);
        } else if (fMark.type == 3 && sMark.type == 1) {
            this.objMarkers.remove(second);
            this.objMarkers.putObject(first, (Object)sMark);
        }
    }
}

