/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.app.plugin.core.datamgr.archive.BuiltInSourceArchive;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.MutabilitySettingsDefinition;
import ghidra.program.model.lang.DecompilerLanguage;
import ghidra.util.InvalidNameException;
import ghidra.util.UniversalID;
import ghidra.util.exception.DuplicateNameException;

public abstract class BuiltIn
extends DataTypeImpl
implements BuiltInDataType {
    private static final SettingsDefinition[] STANDARD_SETTINGS_DEFINITIONS = new SettingsDefinition[]{MutabilitySettingsDefinition.DEF};
    private SettingsDefinition[] settingDefs;

    public BuiltIn(CategoryPath path, String name, DataTypeManager dataMgr) {
        super(path == null ? CategoryPath.ROOT : path, name, null, BuiltInSourceArchive.INSTANCE, 0L, 0L, dataMgr);
    }

    @Override
    public final DataType copy(DataTypeManager dtm) {
        return this.clone(dtm);
    }

    @Override
    public final SettingsDefinition[] getSettingsDefinitions() {
        if (this.settingDefs == null) {
            this.settingDefs = SettingsDefinition.concat((SettingsDefinition[])STANDARD_SETTINGS_DEFINITIONS, (SettingsDefinition[])this.getBuiltInSettingsDefinitions());
        }
        return this.settingDefs;
    }

    protected SettingsDefinition[] getBuiltInSettingsDefinitions() {
        return null;
    }

    @Override
    public boolean isEquivalent(DataType dt) {
        if (dt == this) {
            return true;
        }
        if (dt == null) {
            return false;
        }
        return this.getClass() == dt.getClass();
    }

    @Override
    public void dataTypeSizeChanged(DataType dt) {
    }

    @Override
    public final void setCategoryPath(CategoryPath path) throws DuplicateNameException {
    }

    @Override
    public final void setName(String name) throws InvalidNameException {
    }

    @Override
    public final void setNameAndCategory(CategoryPath path, String name) throws InvalidNameException, DuplicateNameException {
    }

    @Override
    public final void addParent(DataType dt) {
    }

    @Override
    public final void removeParent(DataType dt) {
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
    }

    @Override
    public boolean dependsOn(DataType dt) {
        return false;
    }

    @Override
    public UniversalID getUniversalID() {
        return null;
    }

    @Override
    public long getLastChangeTime() {
        return 0L;
    }

    public String getDecompilerDisplayName(DecompilerLanguage language) {
        return this.name;
    }

    protected String getCTypeDeclaration(String typeName, String ctypeName, boolean useDefine) {
        return useDefine ? "#define " + typeName + "    " + ctypeName : "typedef " + ctypeName + "    " + typeName + ";";
    }

    protected String getCTypeDeclaration(String typeName, int typeLen, boolean signed, DataOrganization dataOrganization, boolean useDefine) {
        return this.getCTypeDeclaration(typeName, dataOrganization.getIntegerCTypeApproximation(typeLen, signed), useDefine);
    }

    protected String getCTypeDeclaration(BuiltIn dt, boolean signed, DataOrganization dataOrganization, boolean useDefine) {
        return this.getCTypeDeclaration(dt.getDecompilerDisplayName(DecompilerLanguage.C_LANGUAGE), dataOrganization.getIntegerCTypeApproximation(dt.getLength(), signed), useDefine);
    }

    @Override
    public String getCTypeDeclaration(DataOrganization dataOrganization) {
        if (this instanceof Dynamic || this instanceof FactoryDataType) {
            return null;
        }
        return this.getCTypeDeclaration(this, false, dataOrganization, false);
    }
}

