/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.app.plugin.processors.sleigh.PcodeEmit;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.program.model.lang.InjectContext;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;

public interface InjectPayload {
    public static final int CALLFIXUP_TYPE = 1;
    public static final int CALLOTHERFIXUP_TYPE = 2;
    public static final int CALLMECHANISM_TYPE = 3;
    public static final int EXECUTABLEPCODE_TYPE = 4;

    public String getName();

    public int getType();

    public String getSource();

    public int getParamShift();

    public InjectParameter[] getInput();

    public InjectParameter[] getOutput();

    public boolean isErrorPlaceholder();

    public void inject(InjectContext var1, PcodeEmit var2);

    public PcodeOp[] getPcode(Program var1, InjectContext var2);

    public boolean isFallThru();

    public boolean isIncidentalCopy();

    public void saveXml(StringBuilder var1);

    public void restoreXml(XmlPullParser var1, SleighLanguage var2) throws XmlParseException;

    public static class InjectParameter {
        private String name;
        private int index;
        private int size;

        public InjectParameter(String nm, int sz) {
            this.name = nm;
            this.index = 0;
            this.size = sz;
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public int getSize() {
            return this.size;
        }

        void setIndex(int i) {
            this.index = i;
        }

        public boolean equals(Object obj) {
            InjectParameter op2 = (InjectParameter)obj;
            if (this.index != op2.index || this.size != op2.size) {
                return false;
            }
            return this.name.equals(op2.name);
        }

        public int hashCode() {
            int hash = this.name.hashCode();
            hash = 79 * hash + this.index;
            hash = 79 * hash + this.size;
            return hash;
        }
    }
}

