/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.InjectPayloadSleigh;
import ghidra.program.model.pcode.AddressXML;
import ghidra.util.SystemUtilities;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;

public class InjectPayloadSegment
extends InjectPayloadSleigh {
    private AddressSpace space;
    private boolean supportsFarPointer;
    private AddressSpace constResolveSpace;
    private long constResolveOffset;
    private int constResolveSize;

    public InjectPayloadSegment(String source) {
        super(source);
        this.type = 4;
        this.space = null;
        this.supportsFarPointer = false;
        this.constResolveSpace = null;
        this.constResolveOffset = 0L;
        this.constResolveSize = 0;
    }

    @Override
    public void saveXml(StringBuilder buffer) {
        String subName;
        buffer.append("<segmentop");
        int pos = this.name.indexOf(95);
        String string = subName = pos > 0 ? this.name.substring(0, pos) : this.name;
        if (!subName.equals("segment")) {
            SpecXmlUtils.encodeStringAttribute((StringBuilder)buffer, (String)"userop", (String)subName);
        }
        SpecXmlUtils.encodeStringAttribute((StringBuilder)buffer, (String)"space", (String)this.space.getName());
        if (this.supportsFarPointer) {
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)buffer, (String)"farpointer", (boolean)this.supportsFarPointer);
        }
        buffer.append(">\n");
        super.saveXml(buffer);
        if (this.constResolveSpace != null) {
            buffer.append("<constresolve>\n");
            buffer.append("<varnode");
            SpecXmlUtils.encodeStringAttribute((StringBuilder)buffer, (String)"space", (String)this.constResolveSpace.getName());
            SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buffer, (String)"offset", (long)this.constResolveOffset);
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"size", (long)this.constResolveSize);
            buffer.append("/>\n");
            buffer.append("</constresolve>\n");
        }
        buffer.append("</segmentop>\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, SleighLanguage language) throws XmlParseException {
        XmlElement el = parser.start(new String[0]);
        this.name = el.getAttribute("userop");
        if (this.name == null) {
            this.name = "segment";
        }
        this.name = this.name + "_pcode";
        String spaceString = el.getAttribute("space");
        this.space = language.getAddressFactory().getAddressSpace(spaceString);
        if (this.space == null) {
            throw new XmlParseException("Unknown address space: " + spaceString);
        }
        this.supportsFarPointer = SpecXmlUtils.decodeBoolean((String)el.getAttribute("farpointer"));
        if (parser.peek().isStart()) {
            if (parser.peek().getName().equals("pcode")) {
                super.restoreXml(parser, language);
            } else {
                throw new XmlParseException("Missing <pcode> child for <segmentop> tag");
            }
        }
        if (parser.peek().isStart()) {
            XmlElement subel = parser.start(new String[]{"constresolve"});
            XmlElement subsubel = parser.start(new String[0]);
            AddressXML addrSize = AddressXML.restoreXml(subsubel, language);
            addrSize.getFirstAddress();
            this.constResolveSpace = addrSize.getAddressSpace();
            this.constResolveOffset = addrSize.getOffset();
            this.constResolveSize = (int)addrSize.getSize();
            parser.end(subsubel);
            parser.end(subel);
        }
        parser.end(el);
    }

    @Override
    public boolean equals(Object obj) {
        InjectPayloadSegment op2 = (InjectPayloadSegment)obj;
        if (this.constResolveOffset != op2.constResolveOffset) {
            return false;
        }
        if (this.constResolveSize != op2.constResolveSize) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)this.constResolveSpace, (Object)op2.constResolveSpace)) {
            return false;
        }
        if (!this.space.equals(op2.space)) {
            return false;
        }
        return this.supportsFarPointer == op2.supportsFarPointer;
    }

    @Override
    public int hashCode() {
        int hash = this.space.hashCode();
        if (this.constResolveSpace != null) {
            hash = 79 * hash + this.constResolveSpace.hashCode();
        }
        hash = 79 * hash + Long.hashCode(this.constResolveOffset);
        hash = 79 * hash + this.constResolveSize;
        hash = 79 * hash + (this.supportsFarPointer ? 1 : 13);
        return hash;
    }
}

