/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class HighLocal
extends HighVariable {
    private Address pcaddr;
    private HighSymbol symbol;

    public HighLocal(HighFunction high) {
        super(high);
    }

    public HighLocal(DataType type, Varnode vn, Varnode[] inst, Address pc, HighSymbol sym) {
        super(sym.getName(), type, vn, inst, sym.getHighFunction());
        this.pcaddr = pc;
        this.symbol = sym;
    }

    @Override
    public HighSymbol getSymbol() {
        return this.symbol;
    }

    public Address getPCAddress() {
        return this.pcaddr;
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws PcodeXMLException {
        XmlElement el = parser.start(new String[]{"high"});
        long symref = SpecXmlUtils.decodeLong((String)el.getAttribute("symref"));
        this.offset = -1;
        String attrString = el.getAttribute("offset");
        if (attrString != null) {
            this.offset = SpecXmlUtils.decodeInt((String)attrString);
        }
        this.restoreInstances(parser, el);
        this.symbol = this.function.getLocalSymbolMap().getSymbol(symref);
        if (this.symbol == null) {
            throw new PcodeXMLException("HighLocal is missing symbol");
        }
        this.name = this.offset < 0 ? this.symbol.getName() : "UNNAMED";
        this.pcaddr = this.symbol.getPCAddress();
        this.symbol.setHighVariable(this);
        parser.end(el);
    }
}

