/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.MappedEntry;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.xml.XmlPullParser;

public class MappedDataEntry
extends MappedEntry {
    private Data data;

    public MappedDataEntry(HighSymbol sym) {
        super(sym);
    }

    public MappedDataEntry(HighSymbol sym, VariableStorage store, Data d) {
        super(sym, store, null);
        this.data = d;
    }

    public Data getData() {
        return this.data;
    }

    @Override
    public void restoreXML(XmlPullParser parser) throws PcodeXMLException {
        super.restoreXML(parser);
        this.data = this.symbol.getProgram().getListing().getDataAt(this.storage.getMinAddress());
    }

    @Override
    public boolean isReadOnly() {
        if (this.data.isConstant()) {
            return true;
        }
        return super.isReadOnly();
    }

    @Override
    public boolean isVolatile() {
        if (this.data.isVolatile()) {
            return true;
        }
        return super.isVolatile();
    }
}

