/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.pcode.VarnodeAST;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class VarnodeBank {
    private TreeSet<VarnodeAST> locTree = new TreeSet<VarnodeAST>(new LocComparator());

    public void clear() {
        this.locTree.clear();
    }

    public int size() {
        return this.locTree.size();
    }

    public boolean isEmpty() {
        return this.locTree.isEmpty();
    }

    public Varnode create(int s, Address addr, int id) {
        VarnodeAST vn = new VarnodeAST(addr, s, id);
        this.locTree.add(vn);
        return vn;
    }

    public void destroy(Varnode vn) {
        this.locTree.remove(vn);
    }

    private Varnode xref(VarnodeAST vn) {
        VarnodeAST oldvn;
        SortedSet<VarnodeAST> sset = this.locTree.tailSet(vn);
        if (!sset.isEmpty() && (oldvn = sset.first()).equals(vn)) {
            oldvn.descendReplace(vn);
            return oldvn;
        }
        this.locTree.add(vn);
        return vn;
    }

    public void makeFree(Varnode vn) {
        VarnodeAST vn1 = (VarnodeAST)vn;
        this.locTree.remove(vn1);
        vn1.setDef(null);
        vn1.setInput(false);
        vn1.setFree(true);
        this.locTree.add(vn1);
    }

    public Varnode setInput(Varnode vn) {
        if (!vn.isFree()) {
            return null;
        }
        if (vn.isConstant()) {
            return null;
        }
        VarnodeAST vn1 = (VarnodeAST)vn;
        this.locTree.remove(vn1);
        vn1.setInput(true);
        return this.xref(vn1);
    }

    public Varnode setDef(Varnode vn, PcodeOp op) {
        if (!vn.isFree()) {
            return null;
        }
        if (vn.isConstant()) {
            return null;
        }
        VarnodeAST vn1 = (VarnodeAST)vn;
        this.locTree.remove(vn1);
        vn1.setDef(op);
        return this.xref(vn1);
    }

    public Iterator<VarnodeAST> locRange() {
        return this.locTree.iterator();
    }

    public Iterator<VarnodeAST> locRange(AddressSpace spaceid) {
        VarnodeAST searchvn1 = new VarnodeAST(spaceid.getAddress(0L), 0, 0);
        searchvn1.setInput(true);
        VarnodeAST searchvn2 = new VarnodeAST(spaceid.getMaxAddress(), Integer.MAX_VALUE, 0);
        return this.locTree.subSet(searchvn1, searchvn2).iterator();
    }

    public Iterator<VarnodeAST> locRange(Address addr) {
        VarnodeAST searchvn1 = new VarnodeAST(addr, 0, 0);
        searchvn1.setInput(true);
        VarnodeAST searchvn2 = new VarnodeAST(addr.add(1L), 0, 0);
        searchvn2.setInput(true);
        return this.locTree.subSet(searchvn1, searchvn2).iterator();
    }

    public Iterator<VarnodeAST> locRange(int sz, Address addr) {
        VarnodeAST searchvn1 = new VarnodeAST(addr, sz, 0);
        searchvn1.setInput(true);
        VarnodeAST searchvn2 = new VarnodeAST(addr, sz + 1, 0);
        searchvn2.setInput(true);
        return this.locTree.subSet(searchvn1, searchvn2).iterator();
    }

    public Varnode find(int sz, Address addr, Address pc, int uniq) {
        VarnodeAST vn;
        VarnodeAST searchvn = new VarnodeAST(addr, sz, 0);
        int uq = uniq == -1 ? 0 : uniq;
        PcodeOpAST op = new PcodeOpAST(pc, uq, 1, 0);
        searchvn.setDef(op);
        Iterator iter = this.locTree.tailSet(searchvn).iterator();
        while (iter.hasNext() && (vn = (VarnodeAST)iter.next()).getSize() == sz && vn.getAddress().equals(addr)) {
            PcodeOp op2 = vn.getDef();
            if (op2 == null || !op2.getSeqnum().getTarget().equals(pc) || uniq != -1 && op2.getSeqnum().getTime() != uniq) continue;
            return vn;
        }
        return null;
    }

    public Varnode findInput(int sz, Address addr) {
        VarnodeAST vn;
        VarnodeAST searchvn = new VarnodeAST(addr, sz, 0);
        searchvn.setInput(true);
        Iterator iter = this.locTree.tailSet(searchvn).iterator();
        if (iter.hasNext() && (vn = (VarnodeAST)iter.next()).isInput() && vn.getSize() == sz && vn.getAddress().equals(addr)) {
            return vn;
        }
        return null;
    }

    public class DefComparator
    implements Comparator<VarnodeAST> {
        @Override
        public int compare(VarnodeAST v1, VarnodeAST v2) {
            int comp;
            if (v1.isInput()) {
                if (!v2.isInput()) {
                    return -1;
                }
            } else if (v1.getDef() != null) {
                if (v2.isInput()) {
                    return 1;
                }
                if (v2.isFree()) {
                    return -1;
                }
                comp = v1.getDef().getSeqnum().compareTo(v2.getDef().getSeqnum());
                if (comp != 0) {
                    return comp;
                }
            }
            if ((comp = v1.getAddress().compareTo(v2.getAddress())) != 0) {
                return comp;
            }
            if (v1.getSize() != v2.getSize()) {
                return v1.getSize() < v2.getSize() ? -1 : 1;
            }
            if (v1.isFree()) {
                if (v1.getUniqueId() == v2.getUniqueId()) {
                    return 0;
                }
                return v1.getUniqueId() < v2.getUniqueId() ? -1 : 1;
            }
            return 0;
        }
    }

    public class LocComparator
    implements Comparator<VarnodeAST> {
        @Override
        public int compare(VarnodeAST v1, VarnodeAST v2) {
            int cmp = v1.getAddress().compareTo(v2.getAddress());
            if (cmp != 0) {
                return cmp;
            }
            if (v1.getSize() != v2.getSize()) {
                return v1.getSize() < v2.getSize() ? -1 : 1;
            }
            if (v1.isInput()) {
                if (v2.isInput()) {
                    return 0;
                }
                return -1;
            }
            if (v2.isInput()) {
                return 1;
            }
            if (v1.getDef() != null) {
                if (v2.getDef() == null) {
                    return -1;
                }
                return v1.getDef().getSeqnum().compareTo(v2.getDef().getSeqnum());
            }
            if (v2.getDef() != null) {
                return 1;
            }
            if (v1.getUniqueId() == v2.getUniqueId()) {
                return 0;
            }
            return v1.getUniqueId() < v2.getUniqueId() ? -1 : 1;
        }
    }
}

