/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.lang.BasicCompilerSpecDescription;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.DecompilerLanguage;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.PcodeInjectLibrary;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.DefaultProgramContext;
import ghidra.program.model.listing.Parameter;
import ghidra.program.util.LanguageTranslator;
import java.util.Set;

class TemporaryCompilerSpec
implements CompilerSpec {
    private final CompilerSpecID oldCompilerSpecID;
    private final CompilerSpec newCompilerSpec;
    private final CompilerSpecDescription description;
    private final LanguageTranslator translator;

    public TemporaryCompilerSpec(LanguageTranslator translator, CompilerSpecID oldCompilerSpecID) throws CompilerSpecNotFoundException {
        this.translator = translator;
        this.oldCompilerSpecID = oldCompilerSpecID;
        this.newCompilerSpec = translator.getNewLanguage().getCompilerSpecByID(translator.getNewCompilerSpecID(oldCompilerSpecID));
        this.description = new BasicCompilerSpecDescription(oldCompilerSpecID, this.newCompilerSpec.getCompilerSpecDescription().getCompilerSpecName());
    }

    @Override
    public boolean doesCDataTypeConversions() {
        return this.newCompilerSpec.doesCDataTypeConversions();
    }

    @Override
    public void applyContextSettings(DefaultProgramContext ctx) {
    }

    @Override
    public PrototypeModel[] getCallingConventions() {
        return new PrototypeModel[0];
    }

    @Override
    public PrototypeModel getCallingConvention(String name) {
        return null;
    }

    @Override
    public PrototypeModel[] getAllModels() {
        return new PrototypeModel[0];
    }

    @Override
    public CompilerSpecDescription getCompilerSpecDescription() {
        return this.description;
    }

    @Override
    public CompilerSpecID getCompilerSpecID() {
        return this.oldCompilerSpecID;
    }

    @Override
    public PrototypeModel getDefaultCallingConvention() {
        return null;
    }

    @Override
    public DecompilerLanguage getDecompilerOutputLanguage() {
        return DecompilerLanguage.C_LANGUAGE;
    }

    @Override
    public PrototypeModel getPrototypeEvaluationModel(CompilerSpec.EvaluationModelType modelType) {
        return this.newCompilerSpec.getPrototypeEvaluationModel(modelType);
    }

    @Override
    public Language getLanguage() {
        return this.translator.getOldLanguage();
    }

    @Override
    public Register getStackPointer() {
        throw new UnsupportedOperationException("Language for upgrade use only (getStackPointer)");
    }

    public void reloadCompilerSpec() {
        throw new UnsupportedOperationException("Language for upgrade use only (reloadCompilerSpec)");
    }

    @Override
    public boolean stackGrowsNegative() {
        return this.newCompilerSpec.stackGrowsNegative();
    }

    @Override
    public AddressSpace getAddressSpace(String spaceName) {
        return this.newCompilerSpec.getAddressSpace(spaceName);
    }

    @Override
    public AddressSpace getStackSpace() {
        return this.newCompilerSpec.getStackSpace();
    }

    @Override
    public AddressSpace getStackBaseSpace() {
        return this.newCompilerSpec.getStackBaseSpace();
    }

    @Override
    public boolean isGlobal(Address addr) {
        return this.newCompilerSpec.isGlobal(addr);
    }

    @Override
    public DataOrganization getDataOrganization() {
        return this.newCompilerSpec.getDataOrganization();
    }

    @Override
    public PrototypeModel matchConvention(GenericCallingConvention genericCallingConvention) {
        throw new UnsupportedOperationException("Language for upgrade use only (matchConvention)");
    }

    @Override
    public PrototypeModel findBestCallingConvention(Parameter[] params) {
        throw new UnsupportedOperationException("Language for upgrade use only (findBestCallingConvention)");
    }

    public int getDefaultStackAlignment() {
        throw new UnsupportedOperationException("Language for upgrade use only (getDefaultStackAlignment)");
    }

    @Override
    public boolean isStackRightJustified() {
        throw new UnsupportedOperationException("Language for upgrade use only (isStackRightJustified)");
    }

    @Override
    public String getProperty(String key) {
        return this.newCompilerSpec.getProperty(key);
    }

    @Override
    public Set<String> getPropertyKeys() {
        return this.newCompilerSpec.getPropertyKeys();
    }

    @Override
    public String getProperty(String key, String defaultString) {
        return this.newCompilerSpec.getProperty(key, defaultString);
    }

    @Override
    public boolean getPropertyAsBoolean(String key, boolean defaultBoolean) {
        return this.newCompilerSpec.getPropertyAsBoolean(key, defaultBoolean);
    }

    @Override
    public int getPropertyAsInt(String key, int defaultInt) {
        return this.newCompilerSpec.getPropertyAsInt(key, defaultInt);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.newCompilerSpec.hasProperty(key);
    }

    @Override
    public PcodeInjectLibrary getPcodeInjectLibrary() {
        return this.newCompilerSpec.getPcodeInjectLibrary();
    }
}

