/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.gadp.client;

import com.google.protobuf.Message;
import ghidra.dbg.gadp.client.GadpClientTargetObject;
import ghidra.dbg.gadp.client.GadpValueUtils;
import ghidra.dbg.gadp.protocol.Gadp;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.util.datastruct.ListenerSet;
import java.util.concurrent.CompletableFuture;

public interface GadpClientTargetBreakpointSpec
extends GadpClientTargetObject,
TargetBreakpointSpec {
    default public CompletableFuture<Void> toggle(boolean enabled) {
        this.getDelegate().assertValid();
        return this.getModel().sendChecked((Message.Builder)Gadp.BreakToggleRequest.newBuilder().setPath(GadpValueUtils.makePath(this.getPath())).setEnabled(enabled), Gadp.BreakToggleReply.getDefaultInstance()).thenApply(rep -> null);
    }

    default public CompletableFuture<Void> disable() {
        return this.toggle(false);
    }

    default public CompletableFuture<Void> enable() {
        return this.toggle(true);
    }

    default public void addAction(TargetBreakpointSpec.TargetBreakpointAction action) {
        this.getDelegate().getActions(true).add((Object)action);
    }

    default public void removeAction(TargetBreakpointSpec.TargetBreakpointAction action) {
        ListenerSet<TargetBreakpointSpec.TargetBreakpointAction> actions = this.getDelegate().getActions(false);
        if (actions != null) {
            actions.remove((Object)action);
        }
    }
}

