/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.gadp.client;

import com.google.protobuf.Message;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.gadp.client.GadpClientTargetObject;
import ghidra.dbg.gadp.client.GadpValueUtils;
import ghidra.dbg.gadp.protocol.Gadp;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.PathUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface GadpClientTargetFocusScope
extends GadpClientTargetObject,
TargetFocusScope {
    default public CompletableFuture<Void> requestFocus(TargetObject obj) {
        this.getDelegate().assertValid();
        this.getModel().assertMine(TargetObject.class, obj);
        if (!PathUtils.isAncestor((List)this.getPath(), (List)obj.getPath())) {
            throw new DebuggerIllegalArgumentException("Can only focus a successor of the scope");
        }
        return this.getModel().sendChecked((Message.Builder)Gadp.FocusRequest.newBuilder().setPath(GadpValueUtils.makePath(this.getPath())).setFocus(GadpValueUtils.makePath(obj.getPath())), Gadp.FocusReply.getDefaultInstance()).thenApply(__ -> null);
    }
}

