/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.evt;

import agent.gdb.manager.GdbLibraryId;
import agent.gdb.manager.evt.AbstractGdbEventWithFields;
import agent.gdb.manager.parsing.GdbMiParser;
import agent.gdb.manager.parsing.GdbParsingUtils;
import java.util.Objects;

public abstract class AbstractGdbLibraryEvent
extends AbstractGdbEventWithFields {
    private final GdbLibraryId lid = new LibId(((GdbMiParser.GdbMiFieldList)this.getInfo()).getString("id"));
    private final String targetName = ((GdbMiParser.GdbMiFieldList)this.getInfo()).getString("target-name");
    private final Integer iid;

    public AbstractGdbLibraryEvent(CharSequence tail) throws GdbParsingUtils.GdbParseError {
        super(tail);
        String gid = ((GdbMiParser.GdbMiFieldList)this.getInfo()).getString("thread-group");
        this.iid = gid == null ? null : Integer.valueOf(GdbParsingUtils.parseInferiorId(gid));
    }

    public GdbLibraryId getLibraryId() {
        return this.lid;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public Integer getInferiorId() {
        return this.iid;
    }

    private static class LibId
    implements GdbLibraryId {
        private final String id;

        public LibId(String id) {
            this.id = id;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LibId)) {
                return false;
            }
            LibId that = (LibId)obj;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

