/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.GdbThread;
import agent.gdb.manager.evt.GdbCommandDoneEvent;
import agent.gdb.manager.evt.GdbThreadCreatedEvent;
import agent.gdb.manager.impl.GdbEvent;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.impl.cmd.AbstractGdbCommand;
import java.util.LinkedHashSet;
import java.util.Set;

public class GdbAttachCommand
extends AbstractGdbCommand<Set<GdbThread>> {
    private final long pid;

    public GdbAttachCommand(GdbManagerImpl manager, long pid) {
        super(manager);
        this.pid = pid;
    }

    @Override
    public String encode() {
        return "-target-attach " + this.pid;
    }

    @Override
    public boolean handle(GdbEvent<?> evt, GdbPendingCommand<?> pending) {
        if (super.handle(evt, pending)) {
            return true;
        }
        if (evt instanceof GdbThreadCreatedEvent) {
            pending.claim(evt);
        }
        return false;
    }

    @Override
    public Set<GdbThread> complete(GdbPendingCommand<?> pending) {
        pending.checkCompletion(GdbCommandDoneEvent.class);
        LinkedHashSet<GdbThread> threads = new LinkedHashSet<GdbThread>();
        for (GdbThreadCreatedEvent created : pending.findAllOf(GdbThreadCreatedEvent.class)) {
            int tid = created.getThreadId();
            threads.add(this.manager.getThread(tid));
        }
        return threads;
    }
}

