/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.parsing;

import agent.gdb.manager.parsing.GdbParsingUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.list.AbstractListDecorator;
import org.apache.commons.collections4.map.AbstractMapDecorator;
import utility.function.ExceptionalFunction;

public class GdbCValueParser
extends GdbParsingUtils.AbstractGdbParser {
    protected static final Pattern COMMA = Pattern.compile(",");
    protected static final Pattern LBRACE = Pattern.compile("\\{");
    protected static final Pattern RBRACE = Pattern.compile("\\}");
    protected static final Pattern ID = Pattern.compile("(?<id>[A-Za-z_][0-9A-Za-z_]*)");
    protected static final Pattern EQUALS = Pattern.compile("=");
    protected static final Pattern REPEATS = Pattern.compile("<repeats\\s+");
    protected static final Pattern TIMES = Pattern.compile("\\s+times>");
    protected static final Pattern INT_OCT = Pattern.compile("0(?<oct>[0-7]+)");
    protected static final Pattern INT_DEC = Pattern.compile("(?<dec>\\d+)");
    protected static final Pattern INT_HEX = Pattern.compile("0x(?<hex>[0-9A-Fa-f]+)");

    public static <T extends GdbCValue> T parseValue(CharSequence text, ExceptionalFunction<GdbCValueParser, T, GdbParsingUtils.GdbParseError> func) throws GdbParsingUtils.GdbParseError {
        GdbCValueParser parser = new GdbCValueParser(text);
        GdbCValue val = (GdbCValue)func.apply((Object)parser);
        parser.checkEmpty(true);
        return (T)val;
    }

    public static GdbCValue parseValue(CharSequence text) throws GdbParsingUtils.GdbParseError {
        return GdbCValueParser.parseValue(text, GdbCValueParser::parseValue);
    }

    public static GdbArrayValue parseArray(CharSequence text) throws GdbParsingUtils.GdbParseError {
        return (GdbArrayValue)GdbCValueParser.parseValue(text, GdbCValueParser::parseArray);
    }

    public GdbCValueParser(CharSequence text) {
        super(text);
    }

    public GdbCValue parseValue() throws GdbParsingUtils.GdbParseError {
        switch (this.peek(true)) {
            case '{': {
                return this.parseCompositeOrArray();
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.parseInteger();
            }
        }
        throw new GdbParsingUtils.GdbParseError("{ or digit", this.buf);
    }

    public GdbIntValue parseInteger() throws GdbParsingUtils.GdbParseError {
        try {
            String match = this.match(INT_HEX, true, "hex");
            return GdbIntValue.valueOf(new BigInteger(match, 16));
        }
        catch (GdbParsingUtils.GdbParseError match) {
            try {
                String match2 = this.match(INT_OCT, true, "oct");
                return GdbIntValue.valueOf(new BigInteger(match2, 8));
            }
            catch (GdbParsingUtils.GdbParseError match2) {
                try {
                    String match3 = this.match(INT_DEC, true, "dec");
                    return GdbIntValue.valueOf(new BigInteger(match3, 10));
                }
                catch (GdbParsingUtils.GdbParseError gdbParseError) {
                    throw new GdbParsingUtils.GdbParseError("0x[hex], 0[oct], or [dec]", this.buf);
                }
            }
        }
    }

    public GdbCValue parseCompositeOrArray() throws GdbParsingUtils.GdbParseError {
        this.match(LBRACE, true);
        char c = this.peek(true);
        if (c == '}') {
            this.match(RBRACE, true);
            return GdbCValue.EMPTY;
        }
        if (Character.isAlphabetic(c) || c == '_') {
            return this.parseCompositeAfterOpen();
        }
        return this.parseArrayAfterOpen();
    }

    public GdbCompositeValue parseCompositeAfterOpen() throws GdbParsingUtils.GdbParseError {
        GdbCompositeValue.Builder result = GdbCompositeValue.builder();
        while (true) {
            String id = this.match(ID, true);
            this.match(EQUALS, true);
            GdbCValue val = this.parseValue();
            result.put(id, val);
            char c = this.peek(true);
            if (c == '}') {
                this.match(RBRACE, false);
                return result.build();
            }
            if (c != ',') break;
            this.match(COMMA, false);
        }
        throw new GdbParsingUtils.GdbParseError("} or ,", this.buf);
    }

    public GdbArrayValue parseArray() throws GdbParsingUtils.GdbParseError {
        this.match(LBRACE, true);
        char c = this.peek(true);
        if (c == '}') {
            this.match(RBRACE, false);
            return GdbArrayValue.EMPTY;
        }
        return this.parseArrayAfterOpen();
    }

    public GdbArrayValue parseArrayAfterOpen() throws GdbParsingUtils.GdbParseError {
        GdbArrayValue.Builder result = GdbArrayValue.builder();
        while (true) {
            GdbCValue val = this.parseValue();
            result.add(val);
            char c = this.peek(true);
            if (c == '<') {
                this.match(REPEATS, false);
                GdbIntValue count = this.parseInteger();
                this.match(TIMES, false);
                long n = count.val.longValueExact();
                int i = 1;
                while ((long)i < n) {
                    result.add(val);
                    ++i;
                }
                c = this.peek(true);
            }
            if (c == '}') {
                this.match(RBRACE, false);
                return result.build();
            }
            if (c != ',') break;
            this.match(COMMA, false);
        }
        throw new GdbParsingUtils.GdbParseError("} , or <repeats", this.buf);
    }

    public static class GdbIntValue
    implements GdbCValue {
        private final BigInteger val;

        public static GdbIntValue valueOf(BigInteger val) {
            return new GdbIntValue(val);
        }

        public static GdbIntValue valueOf(long val) {
            return GdbIntValue.valueOf(BigInteger.valueOf(val));
        }

        public String toString() {
            return "0x" + this.val.toString(16);
        }

        public int hashCode() {
            return this.val.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof GdbIntValue)) {
                return false;
            }
            GdbIntValue that = (GdbIntValue)obj;
            return Objects.equals(this.val, that.val);
        }

        private GdbIntValue(BigInteger val) {
            this.val = val;
        }

        public BigInteger getValue() {
            return this.val;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    public static class DefaultGdbArrayValue
    extends AbstractListDecorator<GdbCValue>
    implements GdbArrayValue {
        private DefaultGdbArrayValue(List<GdbCValue> list) {
            super(list);
        }
    }

    public static interface GdbArrayValue
    extends GdbCValue,
    List<GdbCValue> {
        public static final GdbArrayValue EMPTY = new DefaultGdbArrayValue(List.of());

        public static Builder builder() {
            return new Builder();
        }

        default public List<Integer> expectInts() {
            return this.stream().map(v -> v.expectInt()).collect(Collectors.toList());
        }

        default public List<Long> expectLongs() {
            return this.stream().map(v -> v.expectLong()).collect(Collectors.toList());
        }

        default public List<BigInteger> expectBigInts() {
            return this.stream().map(v -> v.expectedBigInt()).collect(Collectors.toList());
        }

        public static class Builder {
            private final List<GdbCValue> list = new ArrayList<GdbCValue>();

            private Builder() {
            }

            public Builder add(GdbCValue value) {
                this.list.add(value);
                return this;
            }

            public GdbArrayValue build() {
                return new DefaultGdbArrayValue(List.copyOf(this.list));
            }
        }
    }

    public static class DefaultGdbCompositeValue
    extends AbstractMapDecorator<String, GdbCValue>
    implements GdbCompositeValue {
        private DefaultGdbCompositeValue(Map<String, GdbCValue> map) {
            super(map);
        }
    }

    public static interface GdbCompositeValue
    extends GdbCValue,
    Map<String, GdbCValue> {
        public static final GdbCompositeValue EMPTY = new DefaultGdbCompositeValue(Map.of());

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private final Map<String, GdbCValue> map = new LinkedHashMap<String, GdbCValue>();

            private Builder() {
            }

            public Builder put(String name, GdbCValue value) {
                if (this.map.containsKey(name)) {
                    throw new IllegalArgumentException("field " + name + " already present");
                }
                this.map.put(name, value);
                return this;
            }

            public GdbCompositeValue build() {
                return new DefaultGdbCompositeValue(Map.copyOf(this.map));
            }
        }
    }

    public static interface GdbCValue {
        public static final GdbCValue EMPTY = new GdbCValue(){

            @Override
            public boolean isEmpty() {
                return true;
            }
        };

        public boolean isEmpty();

        default public int expectInt() {
            return ((GdbIntValue)this).val.intValueExact();
        }

        default public long expectLong() {
            return ((GdbIntValue)this).val.longValueExact();
        }

        default public BigInteger expectedBigInt() {
            return ((GdbIntValue)this).val;
        }
    }
}

