/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.reason;

import agent.gdb.manager.GdbStackFrame;
import agent.gdb.manager.GdbThread;
import agent.gdb.manager.impl.GdbStackFrameImpl;
import agent.gdb.manager.impl.GdbThreadImpl;
import agent.gdb.manager.parsing.GdbMiParser;
import agent.gdb.manager.reason.GdbReason;

public class GdbBreakpointHitReason
implements GdbReason {
    private final GdbMiParser.GdbMiFieldList frame;
    private final long bkptno;
    private final int threadId;

    public GdbBreakpointHitReason(GdbMiParser.GdbMiFieldList info) {
        this.bkptno = Long.parseLong(info.getString("bkptno"));
        this.threadId = Integer.parseInt(info.getString("thread-id"));
        this.frame = info.getFieldList("frame");
    }

    public long getBreakpointId() {
        return this.bkptno;
    }

    public GdbStackFrame getFrame(GdbThread thread) {
        return GdbStackFrameImpl.fromFieldList((GdbThreadImpl)thread, this.frame);
    }

    public int getThreadId() {
        return this.threadId;
    }

    public String toString() {
        return "<GdbReason breakpoint-hit: bkpt=" + this.bkptno + ",thread-id=" + this.threadId + ">";
    }

    @Override
    public String desc() {
        return "Breakpoint " + this.bkptno + " hit";
    }
}

