/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.GdbCause;
import agent.gdb.manager.GdbEventsListenerAdapter;
import agent.gdb.manager.GdbInferior;
import agent.gdb.manager.GdbThread;
import agent.gdb.manager.impl.cmd.GdbStateChangeRecord;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.model.impl.GdbModelTargetInferior;
import agent.gdb.model.impl.GdbModelTargetModule;
import agent.gdb.model.impl.GdbModelTargetSession;
import agent.gdb.model.impl.GdbModelTargetThread;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.target.TargetConfigurable;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="InferiorContainer", attributes={@TargetAttributeType(name="_base", type=Integer.class), @TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class GdbModelTargetInferiorContainer
extends DefaultTargetObject<GdbModelTargetInferior, GdbModelTargetSession>
implements TargetConfigurable,
GdbEventsListenerAdapter {
    public static final String NAME = "Inferiors";
    protected final GdbModelImpl impl;

    public GdbModelTargetInferiorContainer(GdbModelTargetSession session) {
        super((AbstractDebuggerObjectModel)session.impl, (TargetObject)session, NAME, "InferiorContainer");
        this.impl = session.impl;
        this.changeAttributes(List.of(), Map.of("_base", 10), "Initialized");
        this.impl.gdb.addEventsListener(this);
    }

    @Override
    public void inferiorAdded(GdbInferior inferior, GdbCause cause) {
        GdbModelTargetInferior inf = this.getTargetInferior(inferior);
        this.changeElements(List.of(), List.of(inf), "Added");
    }

    @Override
    public void inferiorStarted(GdbInferior inf, GdbCause cause) {
        GdbModelTargetInferior inferior = this.getTargetInferior(inf);
        inferior.inferiorStarted(inf.getPid()).exceptionally(ex -> {
            this.impl.reportError(this, "Could not notify inferior started", (Throwable)ex);
            return null;
        });
    }

    @Override
    public void inferiorExited(GdbInferior inf, GdbCause cause) {
        GdbModelTargetInferior inferior = this.getTargetInferior(inf);
        ((DebuggerModelListener)((GdbModelTargetSession)this.parent).getListeners().fire).event(this.parent, null, TargetEventScope.TargetEventType.PROCESS_EXITED, "Inferior " + inf.getId() + " exited code=" + inf.getExitCode(), List.of(inferior));
        inferior.inferiorExited(inf.getExitCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inferiorRemoved(int inferiorId, GdbCause cause) {
        GdbModelTargetInferiorContainer gdbModelTargetInferiorContainer = this;
        synchronized (gdbModelTargetInferiorContainer) {
            this.impl.deleteModelObject(inferiorId);
        }
        this.changeElements(List.of(GdbModelTargetInferior.indexInferior(inferiorId)), List.of(), "Removed");
    }

    @Override
    public void threadCreated(GdbThread thread, GdbCause cause) {
        GdbModelTargetInferior inferior = this.getTargetInferior(thread.getInferior());
        GdbModelTargetThread targetThread = inferior.threads.threadCreated(thread);
        ((DebuggerModelListener)((GdbModelTargetSession)this.parent).getListeners().fire).event(this.parent, (TargetThread)targetThread, TargetEventScope.TargetEventType.THREAD_CREATED, "Thread " + thread.getId() + " started", List.of(targetThread));
    }

    @Override
    public void threadExited(int threadId, GdbInferior inf, GdbCause cause) {
        GdbModelTargetInferior inferior = this.getTargetInferior(inf);
        GdbModelTargetThread targetThread = (GdbModelTargetThread)inferior.threads.getCachedElements().get(GdbModelTargetThread.indexThread(threadId));
        ((DebuggerModelListener)((GdbModelTargetSession)this.parent).getListeners().fire).event(this.parent, (TargetThread)targetThread, TargetEventScope.TargetEventType.THREAD_EXITED, "Thread " + threadId + " exited", List.of(targetThread));
        inferior.threads.threadExited(threadId);
    }

    @Override
    public void libraryLoaded(GdbInferior inf, String name, GdbCause cause) {
        GdbModelTargetInferior inferior = this.getTargetInferior(inf);
        GdbModelTargetModule module = inferior.modules.libraryLoaded(name);
        ((DebuggerModelListener)((GdbModelTargetSession)this.parent).getListeners().fire).event(this.parent, null, TargetEventScope.TargetEventType.MODULE_LOADED, "Library " + name + " loaded", List.of(module));
    }

    @Override
    public void libraryUnloaded(GdbInferior inf, String name, GdbCause cause) {
        GdbModelTargetInferior inferior = this.getTargetInferior(inf);
        GdbModelTargetModule module = inferior.modules.getTargetModuleIfPresent(name);
        ((DebuggerModelListener)((GdbModelTargetSession)this.parent).getListeners().fire).event(this.parent, null, TargetEventScope.TargetEventType.MODULE_UNLOADED, "Library " + name + " unloaded", List.of(module));
        inferior.modules.libraryUnloaded(name);
    }

    @Override
    public void memoryChanged(GdbInferior inf, long addr, int len, GdbCause cause) {
        GdbModelTargetInferior inferior = this.getTargetInferior(inf);
        inferior.memory.memoryChanged(addr, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUsingInferiors(Map<Integer, GdbInferior> byIID) {
        List inferiors;
        GdbModelTargetInferiorContainer gdbModelTargetInferiorContainer = this;
        synchronized (gdbModelTargetInferiorContainer) {
            inferiors = byIID.values().stream().map(this::getTargetInferior).collect(Collectors.toList());
        }
        this.setElements(inferiors, "Refreshed");
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        if (!refresh) {
            this.updateUsingInferiors(this.impl.gdb.getKnownInferiors());
            return AsyncUtils.NIL;
        }
        return this.impl.gdb.listInferiors().thenAccept(this::updateUsingInferiors);
    }

    public synchronized GdbModelTargetInferior getTargetInferior(int id) {
        TargetObject modelObject = this.impl.getModelObject(id);
        if (modelObject != null) {
            return (GdbModelTargetInferior)modelObject;
        }
        return new GdbModelTargetInferior(this, this.impl.gdb.getKnownInferiors().get(id));
    }

    public synchronized GdbModelTargetInferior getTargetInferior(GdbInferior inferior) {
        TargetObject modelObject = this.impl.getModelObject(inferior);
        if (modelObject != null) {
            return (GdbModelTargetInferior)modelObject;
        }
        return new GdbModelTargetInferior(this, inferior);
    }

    protected void invalidateMemoryAndRegisterCaches() {
        for (GdbInferior inf : this.impl.gdb.getKnownInferiors().values()) {
            GdbModelTargetInferior targetInf = (GdbModelTargetInferior)this.impl.getModelObject(inf);
            targetInf.invalidateMemoryAndRegisterCaches();
        }
    }

    public CompletableFuture<Void> stateChanged(GdbStateChangeRecord sco) {
        return this.getTargetInferior(sco.getInferior()).stateChanged(sco);
    }

    public CompletableFuture<Void> writeConfigurationOption(String key, Object value) {
        switch (key) {
            case "_base": {
                if (value instanceof Integer) {
                    this.changeAttributes(List.of(), Map.of("_base", value), "Modified");
                    for (GdbModelTargetInferior child : this.getCachedElements().values()) {
                        child.setBase(value);
                    }
                    break;
                }
                throw new DebuggerIllegalArgumentException("Base should be numeric");
            }
        }
        return AsyncUtils.NIL;
    }
}

