/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.manager;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.Connector;
import ghidra.dbg.jdi.manager.JdiConsoleOutputListener;
import ghidra.dbg.jdi.manager.JdiEventHandler;
import ghidra.dbg.jdi.manager.JdiEventsListener;
import ghidra.dbg.jdi.manager.JdiStateListener;
import ghidra.dbg.jdi.manager.JdiTargetOutputListener;
import ghidra.dbg.jdi.manager.impl.JdiManagerImpl;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.tuple.Pair;

public interface JdiManager
extends AutoCloseable {
    public static JdiManager newInstance() {
        return new JdiManagerImpl();
    }

    @Override
    default public void close() {
        this.terminate();
    }

    public void terminate();

    public void addStateListener(VirtualMachine var1, JdiStateListener var2);

    public void removeStateListener(VirtualMachine var1, JdiStateListener var2);

    public void addEventsListener(VirtualMachine var1, JdiEventsListener var2);

    public void removeEventsListener(VirtualMachine var1, JdiEventsListener var2);

    public void addTargetOutputListener(JdiTargetOutputListener var1);

    public void removeTargetOutputListener(JdiTargetOutputListener var1);

    public void addConsoleOutputListener(JdiConsoleOutputListener var1);

    public void removeConsoleOutputListener(JdiConsoleOutputListener var1);

    public VirtualMachine getVM(String var1);

    public Map<String, VirtualMachine> getKnownVMs();

    public void sendInterruptNow() throws IOException;

    public CompletableFuture<VirtualMachine> addVM(Connector var1, List<String> var2);

    public CompletableFuture<VirtualMachine> addVM(Connector var1, Map<String, Connector.Argument> var2);

    public CompletableFuture<Void> removeVM(VirtualMachine var1);

    public CompletableFuture<Void> console(String var1);

    public CompletableFuture<String> consoleCapture(String var1);

    public CompletableFuture<Map<String, VirtualMachine>> listVMs();

    @Deprecated(forRemoval=true)
    public CompletableFuture<List<Pair<Integer, String>>> listAvailableProcesses();

    public VirtualMachineManager getVirtualMachineManager();

    public JdiEventHandler getEventHandler(VirtualMachine var1);

    public static enum Channel {
        STDOUT,
        STDERR;

    }
}

