/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import ghidra.dbg.jdi.manager.breakpoint.JdiBreakpointInfo;
import ghidra.dbg.jdi.model.JdiModelTargetBreakpointContainer;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetDeletable;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.datastruct.ListenerSet;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="BreakpointSpec", attributes={@TargetAttributeType(name="_container", type=JdiModelTargetBreakpointContainer.class), @TargetAttributeType(name="_spec", type=JdiModelTargetBreakpointSpec.class), @TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class JdiModelTargetBreakpointSpec
extends JdiModelTargetObjectImpl
implements TargetBreakpointSpec,
JdiModelTargetDeletable {
    protected JdiBreakpointInfo info;
    protected TargetBreakpointSpecContainer.TargetBreakpointKindSet kinds;
    protected final ListenerSet<TargetBreakpointSpec.TargetBreakpointAction> actions = new ListenerSet<TargetBreakpointSpec.TargetBreakpointAction>(TargetBreakpointSpec.TargetBreakpointAction.class){

        protected Map<TargetBreakpointSpec.TargetBreakpointAction, TargetBreakpointSpec.TargetBreakpointAction> createMap() {
            return Collections.synchronizedMap(new LinkedHashMap());
        }
    };

    public JdiModelTargetBreakpointSpec(JdiModelTargetBreakpointContainer breakpoints, JdiBreakpointInfo info, boolean isElement) {
        super(breakpoints, info.toString(), info, isElement);
    }

    @Override
    public CompletableFuture<Void> delete() {
        this.info.setEnabled(false);
        return CompletableFuture.completedFuture(null);
    }

    public boolean isEnabled() {
        return this.info.isEnabled();
    }

    public String getExpression() {
        return "";
    }

    protected TargetBreakpointSpecContainer.TargetBreakpointKindSet computeKinds(JdiBreakpointInfo from) {
        switch (from.getType()) {
            case BREAKPOINT: {
                return TargetBreakpointSpecContainer.TargetBreakpointKindSet.of((TargetBreakpointSpec.TargetBreakpointKind[])new TargetBreakpointSpec.TargetBreakpointKind[]{TargetBreakpointSpec.TargetBreakpointKind.SW_EXECUTE});
            }
            case MODIFICATION_WATCHPOINT: {
                return TargetBreakpointSpecContainer.TargetBreakpointKindSet.of((TargetBreakpointSpec.TargetBreakpointKind[])new TargetBreakpointSpec.TargetBreakpointKind[]{TargetBreakpointSpec.TargetBreakpointKind.WRITE});
            }
            case ACCESS_WATCHPOINT: {
                return TargetBreakpointSpecContainer.TargetBreakpointKindSet.of((TargetBreakpointSpec.TargetBreakpointKind[])new TargetBreakpointSpec.TargetBreakpointKind[]{TargetBreakpointSpec.TargetBreakpointKind.READ, TargetBreakpointSpec.TargetBreakpointKind.WRITE});
            }
        }
        return TargetBreakpointSpecContainer.TargetBreakpointKindSet.of();
    }

    public TargetBreakpointSpecContainer.TargetBreakpointKindSet getKinds() {
        return this.kinds;
    }

    public void addAction(TargetBreakpointSpec.TargetBreakpointAction action) {
        this.actions.add((Object)action);
    }

    public void removeAction(TargetBreakpointSpec.TargetBreakpointAction action) {
        this.actions.remove((Object)action);
    }

    protected CompletableFuture<JdiBreakpointInfo> getInfo(boolean refresh) {
        return CompletableFuture.completedFuture(this.info);
    }

    protected void updateAttributesFromInfo(String reason) {
        boolean enabled = this.info.isEnabled();
        this.kinds = this.computeKinds(this.info);
        this.display = this.getDisplay();
        this.changeAttributes(List.of(), List.of(), Map.of("_enabled", enabled, "_kinds", this.kinds, "_display", this.display), reason);
    }

    protected CompletableFuture<Void> updateInfo(JdiBreakpointInfo oldInfo, JdiBreakpointInfo newInfo, String reason) {
        this.info = newInfo;
        this.updateAttributesFromInfo(reason);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        return this.getInfo(refresh).thenCompose(i -> this.updateInfo(this.info, (JdiBreakpointInfo)i, "Refreshed"));
    }

    public CompletableFuture<Void> disable() {
        this.info.setEnabled(false);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> enable() {
        this.info.setEnabled(true);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public String getDisplay() {
        return this.info == null ? super.getDisplay() : this.info.toString();
    }
}

