/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.Location;
import ghidra.async.AsyncFence;
import ghidra.dbg.jdi.model.JdiModelTargetLocation;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.iface2.JdiModelTargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="LocationContainer", elements={@TargetElementType(type=JdiModelTargetLocation.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class JdiModelTargetLocationContainer
extends JdiModelTargetObjectImpl {
    private List<Location> locations;
    protected final Map<String, JdiModelTargetLocation> locationsByName = new HashMap<String, JdiModelTargetLocation>();

    public JdiModelTargetLocationContainer(JdiModelTargetObject parent, String name, List<Location> locations) {
        super(parent, name);
        this.locations = locations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> updateUsingLocations(Map<String, Location> byName) {
        List locs;
        JdiModelTargetLocationContainer jdiModelTargetLocationContainer = this;
        synchronized (jdiModelTargetLocationContainer) {
            locs = byName.values().stream().map(this::getTargetLocation).collect(Collectors.toList());
        }
        AsyncFence fence = new AsyncFence();
        for (JdiModelTargetLocation loc : locs) {
            fence.include(loc.init());
        }
        return fence.ready().thenAccept(__ -> this.changeElements(List.of(), locs, Map.of(), "Refreshed"));
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        HashMap<String, Location> map = new HashMap<String, Location>();
        if (this.locations != null) {
            for (Location loc : this.locations) {
                map.put(loc.toString(), loc);
            }
        }
        this.locationsByName.keySet().retainAll(map.keySet());
        return this.updateUsingLocations(map);
    }

    protected synchronized JdiModelTargetLocation getTargetLocation(Location loc) {
        return this.locationsByName.computeIfAbsent(loc.toString(), n -> new JdiModelTargetLocation(this, loc, true));
    }

    public synchronized JdiModelTargetLocation getTargetLocationsIfPresent(String name) {
        return this.locationsByName.get(name);
    }
}

