/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.PathSearchingVirtualMachine;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.event.MonitorContendedEnterEvent;
import com.sun.jdi.event.MonitorContendedEnteredEvent;
import com.sun.jdi.event.MonitorWaitEvent;
import com.sun.jdi.event.MonitorWaitedEvent;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MonitorContendedEnterRequest;
import com.sun.jdi.request.MonitorContendedEnteredRequest;
import com.sun.jdi.request.MonitorWaitRequest;
import com.sun.jdi.request.MonitorWaitedRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import ghidra.async.AsyncFence;
import ghidra.dbg.jdi.manager.JdiCause;
import ghidra.dbg.jdi.manager.JdiEventsListenerAdapter;
import ghidra.dbg.jdi.manager.JdiReason;
import ghidra.dbg.jdi.manager.impl.JdiManagerImpl;
import ghidra.dbg.jdi.model.JdiModelTargetAttributesContainer;
import ghidra.dbg.jdi.model.JdiModelTargetBreakpointContainer;
import ghidra.dbg.jdi.model.JdiModelTargetClassContainer;
import ghidra.dbg.jdi.model.JdiModelTargetLocation;
import ghidra.dbg.jdi.model.JdiModelTargetModuleContainer;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetProcess;
import ghidra.dbg.jdi.model.JdiModelTargetRegister;
import ghidra.dbg.jdi.model.JdiModelTargetStackFrame;
import ghidra.dbg.jdi.model.JdiModelTargetThread;
import ghidra.dbg.jdi.model.JdiModelTargetThreadContainer;
import ghidra.dbg.jdi.model.JdiModelTargetThreadGroupContainer;
import ghidra.dbg.jdi.model.JdiModelTargetVMContainer;
import ghidra.dbg.jdi.model.JdiModelTargetValue;
import ghidra.dbg.jdi.model.iface1.JdiModelSelectableObject;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetAccessConditioned;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetDeletable;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetEnvironment;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetExecutionStateful;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetFocusScope;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetInterruptible;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetKillable;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetLauncher;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetResumable;
import ghidra.dbg.jdi.model.iface2.JdiModelTargetObject;
import ghidra.dbg.target.TargetAggregate;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetLauncher;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.lifecycle.Internal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="VM", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Attributes", type=JdiModelTargetAttributesContainer.class), @TargetAttributeType(name="Breakpoints", type=JdiModelTargetBreakpointContainer.class, fixed=true), @TargetAttributeType(name="Classes", type=JdiModelTargetClassContainer.class, fixed=true), @TargetAttributeType(name="Modules", type=JdiModelTargetModuleContainer.class, fixed=true), @TargetAttributeType(name="Threads", type=JdiModelTargetThreadContainer.class, required=true, fixed=true), @TargetAttributeType(name="ThreadGroups", type=JdiModelTargetThreadGroupContainer.class, fixed=true), @TargetAttributeType(type=Object.class)}, canonicalContainer=true)
public class JdiModelTargetVM
extends JdiModelTargetObjectImpl
implements TargetProcess,
TargetAggregate,
JdiModelTargetEnvironment,
JdiModelTargetAccessConditioned,
JdiModelTargetExecutionStateful,
JdiModelTargetLauncher,
JdiModelTargetDeletable,
JdiModelTargetKillable,
JdiModelTargetResumable,
JdiModelTargetInterruptible,
JdiEventsListenerAdapter,
JdiModelSelectableObject {
    public static final String ID_ATTRIBUTE_NAME = "_id";
    public static final String EXIT_CODE_ATTRIBUTE_NAME = "_exit_code";
    protected final VirtualMachine vm;
    protected boolean trackMonitor = false;
    private Map<String, JdiModelTargetObject> objectMap;
    private Map<Object, String> object2key;
    protected final JdiModelTargetThreadContainer threads;
    protected JdiModelTargetThreadGroupContainer threadGroups;
    protected JdiModelTargetModuleContainer modules;
    protected JdiModelTargetClassContainer classes;
    protected final JdiModelTargetProcess process;
    protected JdiModelTargetBreakpointContainer breakpoints;
    protected JdiModelTargetAttributesContainer addedAttributes;
    private final EventRequestManager eventManager;
    private final ThreadStartRequest threadStartRequest;
    private final ThreadDeathRequest threadStopRequest;
    private final MonitorWaitRequest monitorWaitRequest;
    private final MonitorWaitedRequest monitorWaitedRequest;
    private final MonitorContendedEnterRequest monitorEnterRequest;
    private final MonitorContendedEnteredRequest monitorEnteredRequest;

    public JdiModelTargetVM(JdiModelTargetVMContainer vms, VirtualMachine vm, boolean isElement) {
        super(vms, vm.name(), vm, isElement);
        Process proc;
        vms.vmsById.put(vm.name(), this);
        this.vm = vm;
        this.eventManager = vm.eventRequestManager();
        this.threadStartRequest = this.eventManager.createThreadStartRequest();
        this.threadStopRequest = this.eventManager.createThreadDeathRequest();
        if (vm.canRequestMonitorEvents() && this.trackMonitor) {
            this.monitorWaitRequest = this.eventManager.createMonitorWaitRequest();
            this.monitorWaitedRequest = this.eventManager.createMonitorWaitedRequest();
            this.monitorEnterRequest = this.eventManager.createMonitorContendedEnterRequest();
            this.monitorEnteredRequest = this.eventManager.createMonitorContendedEnteredRequest();
        } else {
            this.trackMonitor = false;
            this.monitorWaitRequest = null;
            this.monitorWaitedRequest = null;
            this.monitorEnterRequest = null;
            this.monitorEnteredRequest = null;
        }
        this.threadStartRequest.enable();
        this.threadStopRequest.enable();
        if (vm.canRequestMonitorEvents() && this.trackMonitor) {
            this.monitorWaitRequest.enable();
            this.monitorWaitedRequest.enable();
            this.monitorEnterRequest.enable();
            this.monitorEnteredRequest.enable();
        }
        this.process = (proc = vm.process()) != null ? new JdiModelTargetProcess(this, proc, false) : null;
        this.threads = new JdiModelTargetThreadContainer(this, "Threads", vm.allThreads());
        this.changeAttributes(List.of(), List.of(this.threads), Map.of("_state", TargetExecutionStateful.TargetExecutionState.ALIVE, "_accessible", this.isAccessible(), "_display", this.updateDisplay(), "_arch", vm.name(), "_debugger", vm.description(), "_os", "JRE " + vm.version(), "_parameters", TargetLauncher.TargetCmdLineLauncher.PARAMETERS), "Initialized");
        if (this.process != null) {
            this.changeAttributes(List.of(), List.of(this.process), Map.of(), "Initialized");
        }
    }

    private void populateAttributes() {
        this.addedAttributes = new JdiModelTargetAttributesContainer(this, "Attributes");
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("version", this.vm.version());
        attrs.put("description", this.vm.description());
        attrs.put("canAddMethods", this.vm.canAddMethod());
        attrs.put("canBeModified", this.vm.canBeModified());
        attrs.put("canForceEarlyReturn", this.vm.canForceEarlyReturn());
        attrs.put("canGetBytecodes", this.vm.canGetBytecodes());
        attrs.put("canGetClassFileVersion", this.vm.canGetClassFileVersion());
        attrs.put("canGetConstantPool", this.vm.canGetConstantPool());
        attrs.put("canGetCurrentContendedMonitor", this.vm.canGetCurrentContendedMonitor());
        attrs.put("canGetInstanceInfo", this.vm.canGetInstanceInfo());
        attrs.put("canGetMethodReturnValues", this.vm.canGetMethodReturnValues());
        attrs.put("canGetModuleInfo", this.vm.canGetModuleInfo());
        attrs.put("canGetMonitorFrameInfo", this.vm.canGetMonitorFrameInfo());
        attrs.put("canGetMonitorInfo", this.vm.canGetMonitorInfo());
        attrs.put("canGetOwnedMonitorInfo", this.vm.canGetOwnedMonitorInfo());
        attrs.put("canGetSourceDebugExtension", this.vm.canGetSourceDebugExtension());
        attrs.put("canGetSyntheticAttribute", this.vm.canGetSyntheticAttribute());
        attrs.put("canPopFrames", this.vm.canPopFrames());
        attrs.put("canRedefineClasses", this.vm.canRedefineClasses());
        attrs.put("canRequestMonitorEvents", this.vm.canRequestMonitorEvents());
        attrs.put("canRequestVMDeathEvent", this.vm.canRequestVMDeathEvent());
        attrs.put("canUnrestrictedlyRedefineClasses", this.vm.canUnrestrictedlyRedefineClasses());
        attrs.put("canUseInstanceFilters", this.vm.canUseInstanceFilters());
        attrs.put("canUseSourceNameFilters", this.vm.canUseSourceNameFilters());
        attrs.put("canWatchFieldAccess", this.vm.canWatchFieldAccess());
        attrs.put("canWatchFieldModification", this.vm.canWatchFieldModification());
        if (this.vm instanceof PathSearchingVirtualMachine) {
            PathSearchingVirtualMachine psvm = (PathSearchingVirtualMachine)this.vm;
            attrs.put("classPath", psvm.classPath());
            attrs.put("baseDirectory", psvm.baseDirectory());
            attrs.put("baseDirectory", psvm.baseDirectory());
        }
        this.addedAttributes.addAttributes(attrs);
    }

    public CompletableFuture<Void> requestAttributes(boolean refresh) {
        this.threadGroups = new JdiModelTargetThreadGroupContainer(this);
        this.modules = new JdiModelTargetModuleContainer(this);
        this.classes = new JdiModelTargetClassContainer(this);
        this.breakpoints = new JdiModelTargetBreakpointContainer(this);
        this.populateAttributes();
        this.changeAttributes(List.of(), List.of(this.modules, this.threadGroups, this.classes, this.breakpoints, this.addedAttributes), Map.of(), "Initialized");
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> launch(Map<String, ?> args) {
        JdiManagerImpl manager = (JdiManagerImpl)this.impl.getManager();
        Connector cx = manager.getConnector(this.vm);
        Map<String, Connector.Argument> defaultArguments = cx.defaultArguments();
        Map<String, Connector.Argument> jdiArgs = JdiModelTargetLauncher.getArguments(defaultArguments, JdiModelTargetLauncher.getParameters(defaultArguments), args);
        return this.getManager().addVM(cx, jdiArgs).thenApply(__ -> null);
    }

    public TargetMethod.TargetParameterMap getParameters() {
        JdiManagerImpl manager = (JdiManagerImpl)this.impl.getManager();
        Connector cx = manager.getConnector(this.vm);
        Map<String, Connector.Argument> defaultArguments = cx.defaultArguments();
        return TargetMethod.TargetParameterMap.copyOf(JdiModelTargetLauncher.getParameters(defaultArguments));
    }

    @Override
    public CompletableFuture<Void> interrupt() {
        this.vm.suspend();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> resume() {
        this.vmStateChanged(TargetExecutionStateful.TargetExecutionState.RUNNING, JdiReason.Reasons.RESUMED);
        this.invalidateMemoryAndRegisterCaches();
        this.vm.resume();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> kill() {
        this.vm.exit(0);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> delete() {
        this.vm.dispose();
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> started(String id) {
        AsyncFence fence = new AsyncFence();
        return fence.ready().thenAccept(__ -> {
            if (id != null) {
                this.changeAttributes(List.of(), List.of(), Map.of("_state", TargetExecutionStateful.TargetExecutionState.ALIVE, ID_ATTRIBUTE_NAME, id, "_display", this.updateDisplay()), "Started");
            } else {
                this.changeAttributes(List.of(), List.of(), Map.of("_state", TargetExecutionStateful.TargetExecutionState.ALIVE, "_display", this.updateDisplay()), "Started");
            }
            this.vmSelected(this.vm, JdiCause.Causes.UNCLAIMED);
        });
    }

    protected void exited(VirtualMachine vm2) {
        if (vm2 != null) {
            this.changeAttributes(List.of(), List.of(), Map.of("_state", TargetExecutionStateful.TargetExecutionState.TERMINATED, EXIT_CODE_ATTRIBUTE_NAME, vm2, "_display", this.updateDisplay()), "Exited");
        } else {
            this.changeAttributes(List.of(), List.of(), Map.of("_state", TargetExecutionStateful.TargetExecutionState.TERMINATED, "_display", this.updateDisplay()), "Exited");
        }
    }

    @Override
    public void vmSelected(VirtualMachine eventVM, JdiCause cause) {
        if (eventVM.equals(this.vm)) {
            ((JdiModelTargetFocusScope)this.searchForSuitable(TargetFocusScope.class)).setFocus(this);
        }
    }

    public void vmStateChanged(TargetExecutionStateful.TargetExecutionState targetState, JdiReason reason) {
        this.changeAttributes(List.of(), List.of(), Map.of("_state", targetState), reason.desc());
    }

    @Override
    public void monitorContendedEntered(MonitorContendedEnteredEvent evt, JdiCause cause) {
        System.err.println(this + ":" + evt);
    }

    @Override
    public void monitorContendedEnter(MonitorContendedEnterEvent evt, JdiCause cause) {
        System.err.println(this + ":" + evt);
    }

    @Override
    public void monitorWaited(MonitorWaitedEvent evt, JdiCause cause) {
        System.err.println(this + ":" + evt);
    }

    @Override
    public void monitorWait(MonitorWaitEvent evt, JdiCause cause) {
        System.err.println(this + ":" + evt);
    }

    protected void updateDisplayAttribute() {
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.updateDisplay()), "Display changed");
    }

    protected String updateDisplay() {
        if (this.vm.process() == null) {
            return this.vm.toString();
        }
        String name = "VM(" + JdiModelTargetProcess.getUniqueId(this.vm.process()) + ") ";
        ProcessHandle.Info info = this.vm.process().info();
        Optional<String[]> arguments = info.arguments();
        if (!arguments.isEmpty()) {
            String[] args;
            for (String arg : args = arguments.get()) {
                if (arg.startsWith("-")) continue;
                String[] split = arg.split("/");
                name = name + (split.length == 0 ? arg : split[split.length - 1]);
            }
        }
        return String.format("%s", name);
    }

    @Override
    public String getDisplay() {
        return this.vm == null ? super.getDisplay() : this.updateDisplay();
    }

    protected void invalidateMemoryAndRegisterCaches() {
    }

    protected void updateMemory() {
    }

    @Override
    @Internal
    public CompletableFuture<Void> setActive() {
        return CompletableFuture.completedFuture(null);
    }

    public JdiModelTargetClassContainer getClasses() {
        return this.classes;
    }

    @Override
    public void refreshInternal() {
    }

    public synchronized JdiModelTargetObject getTargetObject(String key) {
        return this.objectMap.get(key);
    }

    @Override
    public synchronized JdiModelTargetObject getTargetObject(Object obj) {
        return this.objectMap.get(this.object2key.get(obj));
    }

    public synchronized void setTargetObject(String id, Object key, JdiModelTargetObject object) {
        if (this.objectMap == null) {
            this.objectMap = new HashMap<String, JdiModelTargetObject>();
            this.object2key = new HashMap<Object, String>();
        }
        if (!(!this.objectMap.containsKey(id) || key == null || object instanceof JdiModelTargetValue || object instanceof JdiModelTargetLocation || object instanceof JdiModelTargetRegister || object instanceof JdiModelTargetStackFrame)) {
            System.err.println("setTargetObject: " + key);
        }
        if (key != null) {
            this.object2key.put(key, id);
        }
        this.objectMap.put(id, object);
    }

    @Override
    public boolean isAccessible() {
        for (JdiModelTargetThread thread : this.threads.threadsById.values()) {
            if (!thread.isAccessible()) continue;
            return true;
        }
        return false;
    }
}

