/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GraphPath<V> {
    private Set<V> pathSet = new HashSet<V>();
    private List<V> pathList = new ArrayList<V>();

    public GraphPath() {
    }

    public GraphPath(V v) {
        this.add(v);
    }

    public GraphPath<V> copy() {
        GraphPath<V> newPath = new GraphPath<V>();
        newPath.pathList.addAll(this.pathList);
        newPath.pathSet.addAll(this.pathSet);
        return newPath;
    }

    public boolean startsWith(GraphPath<V> otherPath) {
        if (this.size() < otherPath.size()) {
            return false;
        }
        for (int i = 0; i < otherPath.size(); ++i) {
            if (this.pathList.get(i).equals(otherPath.pathList.get(i))) continue;
            return false;
        }
        return true;
    }

    public GraphPath<V> getCommonStartPath(GraphPath<V> other) {
        int n = Math.min(this.size(), other.size());
        for (int i = 0; i < n; ++i) {
            if (this.get(i).equals(other.get(i))) continue;
            return this.subPath(0, i);
        }
        return this.subPath(0, n);
    }

    public int size() {
        return this.pathList.size();
    }

    public boolean contains(V v) {
        return this.pathSet.contains(v);
    }

    public void add(V v) {
        this.pathSet.add(v);
        this.pathList.add(v);
    }

    public V getLast() {
        return this.pathList.get(this.pathList.size() - 1);
    }

    public int depth(V v) {
        return this.pathList.indexOf(v);
    }

    public V get(int depth) {
        return this.pathList.get(depth);
    }

    public V removeLast() {
        V v = this.pathList.remove(this.pathList.size() - 1);
        this.pathSet.remove(v);
        return v;
    }

    public Set<V> getPredecessors(V v) {
        HashSet<V> set = new HashSet<V>();
        int index = this.pathList.indexOf(v);
        if (index < 0) {
            return set;
        }
        set.addAll(this.pathList.subList(0, index + 1));
        return set;
    }

    public Set<V> getSuccessors(V v) {
        HashSet<V> set = new HashSet<V>();
        int index = this.pathList.indexOf(v);
        if (index < 0) {
            return set;
        }
        set.addAll(this.pathList.subList(index, this.pathList.size()));
        return set;
    }

    public String toString() {
        return this.pathList.toString();
    }

    public GraphPath<V> subPath(int start, int end) {
        GraphPath<V> subPath = new GraphPath<V>();
        subPath.pathList = new ArrayList<V>(this.pathList.subList(start, end));
        subPath.pathSet = new HashSet<V>(subPath.pathList);
        return subPath;
    }
}

