/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.jung;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;
import ghidra.util.Msg;
import java.lang.reflect.Constructor;
import java.util.Collection;

public class JungToGDirectedGraphAdapter<V, E extends GEdge<V>>
implements GDirectedGraph<V, E> {
    private Graph<V, E> delegate;

    public JungToGDirectedGraphAdapter(Graph<V, E> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void addEdge(E e) {
        this.delegate.addEdge(e, e.getStart(), e.getEnd());
    }

    @Override
    public boolean containsEdge(V from, V to) {
        return this.findEdge(from, to) != null;
    }

    @Override
    public GDirectedGraph<V, E> emptyCopy() {
        if (this.delegate instanceof GDirectedGraph) {
            return ((GDirectedGraph)this.delegate).emptyCopy();
        }
        Class<?> clazz = this.delegate.getClass();
        try {
            Constructor<?> constructor = clazz.getConstructor(null);
            Graph newGraph = (Graph)constructor.newInstance(null);
            return new JungToGDirectedGraphAdapter<V, E>(newGraph);
        }
        catch (Exception e) {
            Msg.showError((Object)this, null, (String)"Error Creating Graph", (Object)("Unable to create a new instance of graph: " + clazz), (Throwable)e);
            return null;
        }
    }

    @Override
    public GDirectedGraph<V, E> copy() {
        JungToGDirectedGraphAdapter newGraph = (JungToGDirectedGraphAdapter)this.emptyCopy();
        for (Object v : this.delegate.getVertices()) {
            newGraph.addVertex(v);
        }
        for (GEdge e : this.delegate.getEdges()) {
            newGraph.delegate.addEdge((Object)e, e.getStart(), e.getEnd());
        }
        return newGraph;
    }

    @Override
    public boolean isEmpty() {
        return this.getVertexCount() == 0;
    }

    @Override
    public Collection<E> getEdges() {
        return this.delegate.getEdges();
    }

    @Override
    public Collection<E> getInEdges(V vertex) {
        return this.delegate.getInEdges(vertex);
    }

    @Override
    public Collection<V> getVertices() {
        return this.delegate.getVertices();
    }

    @Override
    public Collection<E> getOutEdges(V vertex) {
        return this.delegate.getOutEdges(vertex);
    }

    @Override
    public boolean containsVertex(V vertex) {
        return this.delegate.containsVertex(vertex);
    }

    @Override
    public Collection<V> getPredecessors(V vertex) {
        return this.delegate.getPredecessors(vertex);
    }

    @Override
    public boolean containsEdge(E edge) {
        return this.delegate.containsEdge(edge);
    }

    @Override
    public int getEdgeCount() {
        return this.delegate.getEdgeCount();
    }

    @Override
    public Collection<V> getSuccessors(V vertex) {
        return this.delegate.getSuccessors(vertex);
    }

    @Override
    public int getVertexCount() {
        return this.delegate.getVertexCount();
    }

    public Collection<V> getNeighbors(V vertex) {
        return this.delegate.getNeighbors(vertex);
    }

    public int inDegree(V vertex) {
        return this.delegate.inDegree(vertex);
    }

    @Override
    public Collection<E> getIncidentEdges(V vertex) {
        return this.delegate.getIncidentEdges(vertex);
    }

    public int outDegree(V vertex) {
        return this.delegate.outDegree(vertex);
    }

    public Collection<V> getIncidentVertices(E edge) {
        return this.delegate.getIncidentVertices(edge);
    }

    public boolean isPredecessor(V v1, V v2) {
        return this.delegate.isPredecessor(v1, v2);
    }

    public boolean isSuccessor(V v1, V v2) {
        return this.delegate.isSuccessor(v1, v2);
    }

    @Override
    public E findEdge(V v1, V v2) {
        return (E)((GEdge)this.delegate.findEdge(v1, v2));
    }

    public int getPredecessorCount(V vertex) {
        return this.delegate.getPredecessorCount(vertex);
    }

    public int getSuccessorCount(V vertex) {
        return this.delegate.getSuccessorCount(vertex);
    }

    public V getSource(E directed_edge) {
        return (V)this.delegate.getSource(directed_edge);
    }

    public Collection<E> findEdgeSet(V v1, V v2) {
        return this.delegate.findEdgeSet(v1, v2);
    }

    public V getDest(E directed_edge) {
        return (V)this.delegate.getDest(directed_edge);
    }

    public boolean isSource(V vertex, E edge) {
        return this.delegate.isSource(vertex, edge);
    }

    @Override
    public boolean addVertex(V vertex) {
        return this.delegate.addVertex(vertex);
    }

    public boolean isDest(V vertex, E edge) {
        return this.delegate.isDest(vertex, edge);
    }

    public boolean addEdge(E edge, Collection<? extends V> vertices) {
        return this.delegate.addEdge(edge, vertices);
    }

    public boolean addEdge(E e, V v1, V v2) {
        return this.delegate.addEdge(e, v1, v2);
    }

    public boolean addEdge(E edge, Collection<? extends V> vertices, EdgeType edge_type) {
        return this.delegate.addEdge(edge, vertices, edge_type);
    }

    public boolean addEdge(E e, V v1, V v2, EdgeType edgeType) {
        return this.delegate.addEdge(e, v1, v2, edgeType);
    }

    @Override
    public boolean removeVertex(V vertex) {
        return this.delegate.removeVertex(vertex);
    }

    @Override
    public void removeVertices(Iterable<V> vertices) {
        vertices.forEach(v -> this.removeVertex(v));
    }

    @Override
    public void removeEdges(Iterable<E> edges) {
        edges.forEach(e -> this.removeEdge(e));
    }

    public Pair<V> getEndpoints(E edge) {
        return this.delegate.getEndpoints(edge);
    }

    public V getOpposite(V vertex, E edge) {
        return (V)this.delegate.getOpposite(vertex, edge);
    }

    @Override
    public boolean removeEdge(E edge) {
        return this.delegate.removeEdge(edge);
    }

    public boolean isNeighbor(V v1, V v2) {
        return this.delegate.isNeighbor(v1, v2);
    }

    public boolean isIncident(V vertex, E edge) {
        return this.delegate.isIncident(vertex, edge);
    }

    public int degree(V vertex) {
        return this.delegate.degree(vertex);
    }

    public int getNeighborCount(V vertex) {
        return this.delegate.getNeighborCount(vertex);
    }

    public int getIncidentCount(E edge) {
        return this.delegate.getIncidentCount(edge);
    }

    public EdgeType getEdgeType(E edge) {
        return this.delegate.getEdgeType(edge);
    }

    public EdgeType getDefaultEdgeType() {
        return this.delegate.getDefaultEdgeType();
    }

    public Collection<E> getEdges(EdgeType edge_type) {
        return this.delegate.getEdges(edge_type);
    }

    public int getEdgeCount(EdgeType edge_type) {
        return this.delegate.getEdgeCount(edge_type);
    }
}

