/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.format.dwarf4.DWARFException;
import ghidra.app.util.bin.format.dwarf4.DWARFPreconditionException;
import ghidra.app.util.bin.format.dwarf4.next.DWARFFunctionImporter;
import ghidra.app.util.bin.format.dwarf4.next.DWARFImportOptions;
import ghidra.app.util.bin.format.dwarf4.next.DWARFImportSummary;
import ghidra.app.util.bin.format.dwarf4.next.DWARFParser;
import ghidra.app.util.bin.format.dwarf4.next.DWARFProgram;
import ghidra.app.util.bin.format.dwarf4.next.sectionprovider.DWARFSectionProvider;
import ghidra.app.util.bin.format.dwarf4.next.sectionprovider.DWARFSectionProviderFactory;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class DWARFAnalyzer
extends AbstractAnalyzer {
    private static final String DWARF_LOADED_OPTION_NAME = "DWARF Loaded";
    private static final String OPTION_IMPORT_DATATYPES = "Import data types";
    private static final String OPTION_IMPORT_DATATYPES_DESC = "Import data types defined in the DWARF debug info.";
    private static final String OPTION_PRELOAD_ALL_DIES = "Preload all DIEs";
    private static final String OPTION_PRELOAD_ALL_DIES_DESC = "Preload all DIE records. Requires more memory, but necessary for some non-standard layouts.";
    private static final String OPTION_IMPORT_FUNCS = "Import functions";
    private static final String OPTION_IMPORT_FUNCS_DESC = "Import function information defined in the DWARF debug info.  (implies import data types)";
    private static final String OPTION_IMPORT_LIMIT_DIE_COUNT = "Debug item count limit";
    private static final String OPTION_IMPORT_LIMIT_DIE_COUNT_DESC = "If the number of DWARF debug items are greater than this setting, DWARF analysis will be skipped.";
    private static final String OPTION_OUTPUT_SOURCE_INFO = "Output Source info";
    private static final String OPTION_OUTPUT_SOURCE_INFO_DESC = "Include source code location info (filename:linenumber) in comments attached to the Ghidra datatype or function or variable created.";
    private static final String OPTION_OUTPUT_DWARF_DIE_INFO = "Output DWARF DIE info";
    private static final String OPTION_OUTPUT_DWARF_DIE_INFO_DESC = "Include DWARF DIE offset info in comments attached to the Ghidra datatype or function or variable created.";
    private static final String OPTION_NAME_LENGTH_CUTOFF = "Name length cutoff";
    private static final String OPTION_NAME_LENGTH_CUTOFF_DESC = "Truncate symbol and type names longer than this limit.  Range 20..2000";
    private static final String OPTION_OUTPUT_LEXICAL_BLOCK_COMMENTS = "Lexical block comments";
    private static final String OPTION_OUTPUT_LEXICAL_BLOCK_COMMENTS_DESC = "Add comments to the start of lexical blocks";
    private static final String OPTION_OUTPUT_INLINE_FUNC_COMMENTS = "Inlined functions comments";
    private static final String OPTION_OUTPUT_INLINE_FUNC_COMMENTS_DESC = "Add comments to the start of inlined functions";
    private static final String OPTION_COPY_ANON_TYPES = "Create local copy of anonymous types for struct fields";
    private static final String OPTION_COPY_ANON_TYPES_DESC = "Clones anonymous types used in a struct and creates a local copy using the name of the field.";
    private static final String OPTION_OUTPUT_FUNC_SIGS = "Output function signatures";
    private static final String OPTION_OUTPUT_FUNC_SIGS_DESC = "Create function signature data types for each function encountered in the DWARF debug data.";
    private static final String DWARF_ANALYZER_NAME = "DWARF";
    private static final String DWARF_ANALYZER_DESCRIPTION = "Automatically extracts DWARF info from an ELF file.";
    private DWARFImportOptions importOptions = new DWARFImportOptions();
    private long lastTxId = -1L;

    public DWARFAnalyzer() {
        super(DWARF_ANALYZER_NAME, DWARF_ANALYZER_DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setDefaultEnablement(true);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS.after());
        this.setSupportsOneTimeAnalysis();
    }

    @Override
    public boolean getDefaultEnablement(Program program) {
        Language language = program.getLanguage();
        return language.getDefaultSpace() == language.getDefaultDataSpace();
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        boolean alreadyLoaded;
        long txId = program.getCurrentTransaction().getID();
        if (txId == this.lastTxId) {
            return true;
        }
        this.lastTxId = txId;
        Options propList = program.getOptions("Program Information");
        boolean bl = alreadyLoaded = propList.getBoolean(DWARF_LOADED_OPTION_NAME, false) || this.oldCheckIfDWARFImported(program);
        if (alreadyLoaded) {
            Msg.info((Object)this, (Object)"DWARF already imported, skipping.");
            return false;
        }
        DWARFSectionProvider dsp = DWARFSectionProviderFactory.createSectionProviderFor(program, monitor);
        if (dsp == null) {
            Msg.info((Object)this, (Object)"Unable to find DWARF information, skipping DWARF analysis");
            return false;
        }
        try {
            try (DWARFProgram prog = new DWARFProgram(program, this.importOptions, monitor, dsp);){
                if (prog.getRegisterMappings() == null && this.importOptions.isImportFuncs()) {
                    log.appendMsg("No DWARF to Ghidra register mappings found for this program's language [" + program.getLanguageID().getIdAsString() + "], unable to import functions.");
                    this.importOptions.setImportFuncs(false);
                }
                DWARFParser dp = new DWARFParser(prog, (DataTypeManager)BuiltInDataTypeManager.getDataTypeManager(), monitor);
                DWARFImportSummary parseResults = dp.parse();
                parseResults.logSummaryResults();
            }
            propList.setBoolean(DWARF_LOADED_OPTION_NAME, true);
            dsp.updateProgramInfo(program);
            return true;
        }
        catch (CancelledException ce) {
            throw ce;
        }
        catch (DWARFPreconditionException e) {
            log.appendMsg("Skipping DWARF import because a precondition was not met:");
            log.appendMsg(e.getMessage());
            log.appendMsg("Manually re-run the DWARF analyzer after adjusting the options or start it via Dwarf_ExtractorScript");
        }
        catch (DWARFException | IOException e) {
            log.appendMsg("Error during DWARFAnalyzer import");
            log.appendException((Throwable)e);
        }
        return false;
    }

    private boolean oldCheckIfDWARFImported(Program prog) {
        return DWARFFunctionImporter.hasDWARFProgModule(prog, DWARF_ANALYZER_NAME);
    }

    @Override
    public boolean canAnalyze(Program program) {
        return DWARFProgram.isDWARF(program);
    }

    @Override
    public void registerOptions(Options options, Program program) {
        options.registerOption(OPTION_IMPORT_DATATYPES, (Object)this.importOptions.isImportDataTypes(), null, OPTION_IMPORT_DATATYPES_DESC);
        options.registerOption(OPTION_PRELOAD_ALL_DIES, (Object)this.importOptions.isPreloadAllDIEs(), null, OPTION_PRELOAD_ALL_DIES_DESC);
        options.registerOption(OPTION_IMPORT_FUNCS, (Object)this.importOptions.isImportFuncs(), null, OPTION_IMPORT_FUNCS_DESC);
        options.registerOption(OPTION_OUTPUT_DWARF_DIE_INFO, (Object)this.importOptions.isOutputDIEInfo(), null, OPTION_OUTPUT_DWARF_DIE_INFO_DESC);
        options.registerOption(OPTION_OUTPUT_LEXICAL_BLOCK_COMMENTS, (Object)this.importOptions.isOutputLexicalBlockComments(), null, OPTION_OUTPUT_LEXICAL_BLOCK_COMMENTS_DESC);
        options.registerOption(OPTION_OUTPUT_INLINE_FUNC_COMMENTS, (Object)this.importOptions.isOutputInlineFuncComments(), null, OPTION_OUTPUT_INLINE_FUNC_COMMENTS_DESC);
        options.registerOption(OPTION_OUTPUT_SOURCE_INFO, (Object)this.importOptions.isOutputSourceLocationInfo(), null, OPTION_OUTPUT_SOURCE_INFO_DESC);
        options.registerOption(OPTION_IMPORT_LIMIT_DIE_COUNT, (Object)this.importOptions.getImportLimitDIECount(), null, OPTION_IMPORT_LIMIT_DIE_COUNT_DESC);
        options.registerOption(OPTION_NAME_LENGTH_CUTOFF, (Object)this.importOptions.getNameLengthCutoff(), null, OPTION_NAME_LENGTH_CUTOFF_DESC);
        options.registerOption(OPTION_COPY_ANON_TYPES, (Object)this.importOptions.isCopyRenameAnonTypes(), null, OPTION_COPY_ANON_TYPES_DESC);
        options.registerOption(OPTION_OUTPUT_FUNC_SIGS, (Object)this.importOptions.isCreateFuncSignatures(), null, OPTION_OUTPUT_FUNC_SIGS_DESC);
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        this.importOptions.setOutputDIEInfo(options.getBoolean(OPTION_OUTPUT_DWARF_DIE_INFO, this.importOptions.isOutputDIEInfo()));
        this.importOptions.setPreloadAllDIEs(options.getBoolean(OPTION_PRELOAD_ALL_DIES, this.importOptions.isPreloadAllDIEs()));
        this.importOptions.setOutputSourceLocationInfo(options.getBoolean(OPTION_OUTPUT_SOURCE_INFO, this.importOptions.isOutputSourceLocationInfo()));
        this.importOptions.setOutputLexicalBlockComments(options.getBoolean(OPTION_OUTPUT_LEXICAL_BLOCK_COMMENTS, this.importOptions.isOutputLexicalBlockComments()));
        this.importOptions.setOutputInlineFuncComments(options.getBoolean(OPTION_OUTPUT_INLINE_FUNC_COMMENTS, this.importOptions.isOutputInlineFuncComments()));
        this.importOptions.setImportDataTypes(options.getBoolean(OPTION_IMPORT_DATATYPES, this.importOptions.isImportDataTypes()));
        this.importOptions.setImportFuncs(options.getBoolean(OPTION_IMPORT_FUNCS, this.importOptions.isImportFuncs()));
        this.importOptions.setImportLimitDIECount(options.getInt(OPTION_IMPORT_LIMIT_DIE_COUNT, this.importOptions.getImportLimitDIECount()));
        this.importOptions.setNameLengthCutoff(options.getInt(OPTION_NAME_LENGTH_CUTOFF, this.importOptions.getNameLengthCutoff()));
        this.importOptions.setCopyRenameAnonTypes(options.getBoolean(OPTION_COPY_ANON_TYPES, this.importOptions.isCopyRenameAnonTypes()));
        this.importOptions.setCreateFuncSignatures(options.getBoolean(OPTION_OUTPUT_FUNC_SIGS, this.importOptions.isCreateFuncSignatures()));
    }
}

