/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.interpreter;

import docking.DockingUtils;
import docking.actions.KeyBindingUtils;
import generic.util.WindowUtilities;
import ghidra.app.plugin.core.console.CodeCompletion;
import ghidra.app.plugin.core.interpreter.CodeCompletionWindow;
import ghidra.app.plugin.core.interpreter.CompletionWindowTrigger;
import ghidra.app.plugin.core.interpreter.HistoryManager;
import ghidra.app.plugin.core.interpreter.HistoryManagerImpl;
import ghidra.app.plugin.core.interpreter.InterpreterConnection;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class InterpreterPanel
extends JPanel
implements OptionsChangeListener {
    private static final String COMPLETION_WINDOW_TRIGGER_LABEL = "Completion Window Trigger";
    private static final String COMPLETION_WINDOW_TRIGGER_DESCRIPTION = "The key binding used to show the auto-complete window (for those consoles that have auto-complete).";
    private static final String FONT_OPTION_LABEL = "Font";
    private static final String FONT_DESCRIPTION = "This is the font that will be used in the Console.  Double-click the font example to change it.";
    private static final Color NORMAL_COLOR = Color.black;
    private static final Color ERROR_COLOR = Color.red;
    private InterpreterConnection interpreter;
    private JScrollPane outputScrollPane;
    private JTextPane outputTextPane;
    private JTextPane promptTextPane;
    JTextPane inputTextPane;
    private CodeCompletionWindow codeCompletionWindow;
    private HistoryManager history;
    IPStdin stdin;
    private OutputStream stdout;
    private OutputStream stderr;
    private PrintWriter outWriter;
    private PrintWriter errWriter;
    private Font basicFont = InterpreterPanel.getBasicFont();
    private Font basicBoldFont = InterpreterPanel.getBoldFont(this.basicFont);
    private SimpleAttributeSet STDOUT_SET;
    private SimpleAttributeSet STDERR_SET;
    private SimpleAttributeSet STDIN_SET;
    private CompletionWindowTrigger completionWindowTrigger = CompletionWindowTrigger.TAB;
    private boolean highlightCompletion = false;
    private boolean caretGuard = true;
    private PluginTool tool;

    private static Font getBasicFont() {
        return new Font("Monospaced", 0, 20);
    }

    private static Font getBoldFont(Font font) {
        return font.deriveFont(1);
    }

    private static SimpleAttributeSet createAttributes(Font font, Color color) {
        SimpleAttributeSet attributeSet = new SimpleAttributeSet();
        attributeSet.addAttribute(StyleConstants.FontFamily, font.getFamily());
        attributeSet.addAttribute(StyleConstants.FontSize, font.getSize());
        attributeSet.addAttribute(StyleConstants.Italic, font.isItalic());
        attributeSet.addAttribute(StyleConstants.Bold, font.isBold());
        attributeSet.addAttribute(StyleConstants.Foreground, color);
        return attributeSet;
    }

    public InterpreterPanel(PluginTool tool, InterpreterConnection interpreter) {
        this.tool = tool;
        this.interpreter = interpreter;
        this.addHierarchyListener(e -> {
            if (this.codeCompletionWindow != null) {
                this.codeCompletionWindow.dispose();
                this.codeCompletionWindow = null;
            }
        });
        this.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            @Override
            public void ancestorMoved(HierarchyEvent e) {
                InterpreterPanel.this.updateCompletionWindowLocation();
            }
        });
        this.build();
        this.createOptions();
    }

    private void build() {
        this.outputTextPane = new JTextPane();
        this.outputTextPane.setName("Interpreter Output Display");
        this.outputScrollPane = new JScrollPane(this.outputTextPane);
        this.outputScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.promptTextPane = new JTextPane();
        this.inputTextPane = new JTextPane();
        this.inputTextPane.setName("Interpreter Input Field");
        this.history = new HistoryManagerImpl();
        this.outputScrollPane.setFocusable(false);
        this.promptTextPane.setFocusable(false);
        this.stdin = new IPStdin();
        this.stdout = new IPOut(TextType.STDOUT);
        this.stderr = new IPOut(TextType.STDERR);
        this.outWriter = new PrintWriter(this.stdout, true);
        this.errWriter = new PrintWriter(this.stderr, true);
        this.outputTextPane.setEditable(false);
        this.promptTextPane.setEditable(false);
        JPanel interior = new JPanel();
        interior.setLayout(new BorderLayout());
        interior.add((Component)this.promptTextPane, "West");
        interior.add((Component)this.inputTextPane, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)this.outputScrollPane, "Center");
        this.add((Component)interior, "South");
        AbstractDocument document = (AbstractDocument)this.inputTextPane.getDocument();
        document.setDocumentFilter(new DocumentFilter(){

            private String extractAndExecuteCommands(DocumentFilter.FilterBypass fb, int offset, int length, String newText) {
                Document doc = fb.getDocument();
                try {
                    String docText = doc.getText(0, offset);
                    Object text = docText + newText;
                    int indexOf = ((String)text).indexOf(10);
                    while (indexOf != -1) {
                        String command = ((String)text).substring(0, indexOf + 1);
                        InterpreterPanel.this.executeCommand(command);
                        text = ((String)text).substring(indexOf + 1);
                        indexOf = ((String)text).indexOf(10);
                    }
                    return text;
                }
                catch (BadLocationException e) {
                    Msg.error((Object)this, (Object)"Interpreter document positioning error", (Throwable)e);
                    return "";
                }
            }

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                String text = this.extractAndExecuteCommands(fb, offset, 0, string);
                super.replace(fb, 0, offset, text, attr);
                InterpreterPanel.this.updateCompletionList();
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                String txt = this.extractAndExecuteCommands(fb, offset, length, text);
                super.replace(fb, 0, offset + length, txt, attrs);
                InterpreterPanel.this.updateCompletionList();
            }

            @Override
            public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                super.remove(fb, offset, length);
                InterpreterPanel.this.updateCompletionList();
            }
        });
        this.outputTextPane.addKeyListener(new KeyListener(){

            private void handleEvent(KeyEvent e) {
                KeyStroke copyKeyStroke = KeyStroke.getKeyStroke(67, DockingUtils.CONTROL_KEY_MODIFIER_MASK);
                if (copyKeyStroke.equals(KeyStroke.getKeyStrokeForEvent(e))) {
                    return;
                }
                KeyBindingUtils.retargetEvent((Component)InterpreterPanel.this.inputTextPane, (KeyEvent)e);
            }

            @Override
            public void keyTyped(KeyEvent e) {
                this.handleEvent(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.handleEvent(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                this.handleEvent(e);
            }
        });
        this.inputTextPane.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                CodeCompletionWindow completionWindow = InterpreterPanel.this.getCodeCompletionWindow();
                switch (e.getKeyCode()) {
                    case 10: {
                        if (completionWindow.isVisible()) {
                            InterpreterPanel.this.insertCompletion(completionWindow.getCompletion());
                            completionWindow.setVisible(false);
                            e.consume();
                            break;
                        }
                        InterpreterPanel.this.inputTextPane.setCaretPosition(InterpreterPanel.this.inputTextPane.getDocument().getLength());
                        break;
                    }
                    case 38: {
                        if (completionWindow.isVisible()) {
                            completionWindow.selectPrevious();
                        } else {
                            String historyUp = InterpreterPanel.this.history.getHistoryUp();
                            if (historyUp != null) {
                                InterpreterPanel.this.setInputTextPaneText(historyUp);
                            }
                        }
                        e.consume();
                        break;
                    }
                    case 40: {
                        if (completionWindow.isVisible()) {
                            completionWindow.selectNext();
                        } else {
                            String historyDown = InterpreterPanel.this.history.getHistoryDown();
                            if (historyDown != null) {
                                InterpreterPanel.this.setInputTextPaneText(historyDown);
                            }
                        }
                        e.consume();
                        break;
                    }
                    case 27: {
                        completionWindow.setVisible(false);
                        e.consume();
                        break;
                    }
                    default: {
                        if (InterpreterPanel.this.completionWindowTrigger.isTrigger(e) && !InterpreterPanel.this.inputTextPane.getText().trim().isEmpty()) {
                            InterpreterPanel.this.completionWindowTriggered(completionWindow);
                            e.consume();
                            break;
                        }
                        InterpreterPanel.this.updateCompletionList();
                    }
                }
            }
        });
        this.outputTextPane.addCaretListener(e -> {
            Caret caret = this.inputTextPane.getCaret();
            if (this.caretGuard) {
                this.caretGuard = false;
                caret.setDot(caret.getDot());
                this.caretGuard = true;
            }
            caret.setVisible(true);
        });
        this.inputTextPane.addCaretListener(e -> {
            Caret caret = this.outputTextPane.getCaret();
            if (this.caretGuard) {
                this.caretGuard = false;
                caret.setDot(caret.getDot());
                this.caretGuard = true;
            }
        });
        FocusTraversalPolicy policy = new FocusTraversalPolicy(){

            @Override
            public Component getLastComponent(Container aContainer) {
                return InterpreterPanel.this.inputTextPane;
            }

            @Override
            public Component getFirstComponent(Container aContainer) {
                return InterpreterPanel.this.inputTextPane;
            }

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return InterpreterPanel.this.inputTextPane;
            }

            @Override
            public Component getComponentBefore(Container aContainer, Component aComponent) {
                return InterpreterPanel.this.inputTextPane;
            }

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                return InterpreterPanel.this.inputTextPane;
            }
        };
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(policy);
        this.setFocusTraversalPolicyProvider(true);
    }

    private void completionWindowTriggered(CodeCompletionWindow completionWindow) {
        if (completionWindow.isVisible()) {
            CodeCompletion completion = completionWindow.getCompletion();
            if (null == completion) {
                completionWindow.selectNext();
            } else {
                this.insertCompletion(completionWindow.getCompletion());
            }
        } else {
            completionWindow.setVisible(true);
            this.updateCompletionList();
        }
    }

    private void updateFontAttributes(Font newFont) {
        this.basicFont = newFont;
        this.basicBoldFont = InterpreterPanel.getBoldFont(newFont);
        this.STDOUT_SET = InterpreterPanel.createAttributes(this.basicFont, NORMAL_COLOR);
        this.STDERR_SET = InterpreterPanel.createAttributes(this.basicFont, ERROR_COLOR);
        this.STDIN_SET = InterpreterPanel.createAttributes(this.basicBoldFont, NORMAL_COLOR);
        this.setTextPaneFont(this.inputTextPane, this.basicBoldFont);
        this.setTextPaneFont(this.promptTextPane, this.basicFont);
        this.setPrompt(this.promptTextPane.getText());
    }

    private void createOptions() {
        ToolOptions options = this.tool.getOptions("Console");
        HelpLocation help = new HelpLocation(this.getName(), "ConsolePlugin");
        options.setOptionsHelpLocation(help);
        options.registerOption(FONT_OPTION_LABEL, (Object)this.basicFont, help, FONT_DESCRIPTION);
        options.registerOption(COMPLETION_WINDOW_TRIGGER_LABEL, (Object)CompletionWindowTrigger.TAB, help, COMPLETION_WINDOW_TRIGGER_DESCRIPTION);
        this.basicFont = options.getFont(FONT_OPTION_LABEL, this.basicFont);
        this.basicFont = SystemUtilities.adjustForFontSizeOverride((Font)this.basicFont);
        this.updateFontAttributes(this.basicFont);
        this.completionWindowTrigger = (CompletionWindowTrigger)options.getEnum(COMPLETION_WINDOW_TRIGGER_LABEL, (Enum)CompletionWindowTrigger.TAB);
        options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (optionName.equals(FONT_OPTION_LABEL)) {
            this.basicFont = SystemUtilities.adjustForFontSizeOverride((Font)((Font)newValue));
            this.updateFontAttributes(this.basicFont);
        } else if (optionName.equals(COMPLETION_WINDOW_TRIGGER_LABEL)) {
            this.completionWindowTrigger = (CompletionWindowTrigger)((Object)newValue);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.height = Math.max(preferredSize.height, 400);
        return preferredSize;
    }

    private void executeCommand(String command) {
        try {
            StyledDocument document = this.promptTextPane.getStyledDocument();
            String prompt = document.getText(0, document.getLength());
            this.addText(prompt, TextType.STDOUT);
            this.addText(command, TextType.STDIN);
            this.repositionScrollpane();
            this.stdin.addText(command);
            this.history.addHistory(command);
        }
        catch (BadLocationException e1) {
            Msg.error((Object)this, (Object)"internal buffer error", (Throwable)e1);
        }
    }

    private CodeCompletionWindow getCodeCompletionWindow() {
        if (this.codeCompletionWindow == null) {
            Window parent = WindowUtilities.windowForComponent((Component)this.inputTextPane);
            this.codeCompletionWindow = new CodeCompletionWindow(parent, this, this.inputTextPane);
            this.updateCompletionWindowLocation();
        }
        return this.codeCompletionWindow;
    }

    private void updateCompletionWindowLocation() {
        if (this.codeCompletionWindow == null) {
            return;
        }
        Point currentLocation = new Point(0, 0);
        Point caretPosition = this.inputTextPane.getCaret().getMagicCaretPosition();
        if (caretPosition != null) {
            currentLocation = caretPosition;
        }
        this.codeCompletionWindow.updateLocation(currentLocation);
    }

    private void updateCompletionList() {
        SwingUtilities.invokeLater(() -> {
            CodeCompletionWindow completionWindow = this.getCodeCompletionWindow();
            if (!completionWindow.isVisible()) {
                return;
            }
            String text = this.getInputTextPaneText();
            List<CodeCompletion> completions = this.interpreter.getCompletions(text);
            completionWindow.updateCompletionList(completions);
        });
    }

    private String getInputTextPaneText() {
        String text = null;
        try {
            Document doc = this.inputTextPane.getDocument();
            text = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            Msg.error((Object)this, (Object)"internal buffer error", (Throwable)e);
        }
        return text;
    }

    private void setInputTextPaneText(String text) {
        try {
            Document document = this.inputTextPane.getDocument();
            document.remove(0, document.getLength());
            document.insertString(0, text, this.STDIN_SET);
        }
        catch (BadLocationException e) {
            Msg.error((Object)this, (Object)"internal document positioning error", (Throwable)e);
        }
    }

    private void repositionScrollpane() {
        this.outputTextPane.setCaretPosition(Math.max(0, this.outputTextPane.getDocument().getLength() - 1));
    }

    void addText(String text, TextType type) {
        SimpleAttributeSet attributes;
        switch (type) {
            case STDERR: {
                attributes = this.STDERR_SET;
                break;
            }
            case STDIN: {
                attributes = this.STDIN_SET;
                break;
            }
            default: {
                attributes = this.STDOUT_SET;
            }
        }
        try {
            StyledDocument document = this.outputTextPane.getStyledDocument();
            document.insertString(document.getLength(), text, attributes);
            this.repositionScrollpane();
        }
        catch (BadLocationException e) {
            Msg.error((Object)this, (Object)"internal document positioning error", (Throwable)e);
        }
    }

    public void clear() {
        this.outputTextPane.setText("");
        this.stdin.resetStream();
    }

    public String getOutputText() {
        return this.outputTextPane.getText();
    }

    public InputStream getStdin() {
        return this.stdin;
    }

    public OutputStream getStdOut() {
        return this.stdout;
    }

    public OutputStream getStdErr() {
        return this.stderr;
    }

    public PrintWriter getOutWriter() {
        return this.outWriter;
    }

    public PrintWriter getErrWriter() {
        return this.errWriter;
    }

    public String getPrompt() {
        return this.promptTextPane.getText();
    }

    public void setPrompt(String prompt) {
        try {
            Document document = this.promptTextPane.getDocument();
            document.remove(0, document.getLength());
            document.insertString(0, prompt, this.STDOUT_SET);
        }
        catch (BadLocationException e) {
            Msg.error((Object)this, (Object)"internal document positioning error", (Throwable)e);
        }
    }

    public void insertCompletion(CodeCompletion completion) {
        if (!CodeCompletion.isValid(completion)) {
            return;
        }
        String text = this.getInputTextPaneText();
        int position = this.inputTextPane.getCaretPosition();
        String insertion = completion.getInsertion();
        this.setInputTextPaneText(text.substring(0, position) + insertion + text.substring(position));
        if (this.highlightCompletion) {
            this.inputTextPane.setSelectionStart(position);
        }
        this.inputTextPane.moveCaretPosition(position + insertion.length());
        this.updateCompletionList();
    }

    public void dispose() {
        this.stdin.close();
        this.setVisible(false);
    }

    public void setTextPaneFont(JTextPane textPane, Font font) {
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attributes, font.getFamily());
        StyleConstants.setFontSize(attributes, font.getSize());
        StyleConstants.setItalic(attributes, font.isItalic());
        StyleConstants.setBold(attributes, font.isBold());
        StyleConstants.setForeground(attributes, NORMAL_COLOR);
        MutableAttributeSet inputAttributes = textPane.getInputAttributes();
        inputAttributes.removeAttribute(attributes);
        inputAttributes.addAttributes(attributes);
    }

    public boolean isInputPermitted() {
        return this.inputTextPane.isEditable();
    }

    public void setInputPermitted(boolean permitted) {
        this.inputTextPane.setEditable(permitted);
    }

    static class IPStdin
    extends InputStream {
        private static final byte[] EMPTY_BYTES = new byte[0];
        private byte[] bytes = EMPTY_BYTES;
        private int position = 0;
        private LinkedBlockingQueue<byte[]> queuedBytes = new LinkedBlockingQueue();
        private AtomicBoolean isClosed = new AtomicBoolean(false);

        IPStdin() {
        }

        private boolean fetchBytesFromQueue(boolean blocking) {
            try {
                while (!this.isClosed.get() && this.position >= this.bytes.length) {
                    byte[] newBytes;
                    byte[] byArray = newBytes = blocking ? this.queuedBytes.take() : this.queuedBytes.poll();
                    if (newBytes != null) {
                        this.bytes = newBytes;
                        this.position = 0;
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.position < this.bytes.length;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (!this.fetchBytesFromQueue(true)) {
                return -1;
            }
            int length = Math.min(this.bytes.length - this.position, len);
            System.arraycopy(this.bytes, this.position, b, off, length);
            this.position += length;
            return length;
        }

        @Override
        public int read() throws IOException {
            byte[] buffer = new byte[1];
            if (this.read(buffer, 0, 1) != 1) {
                return -1;
            }
            return buffer[0] & 0xFF;
        }

        @Override
        public int available() {
            this.fetchBytesFromQueue(false);
            return this.bytes.length - this.position;
        }

        @Override
        public void close() {
            this.isClosed.set(true);
            this.queuedBytes.clear();
            this.queuedBytes.offer(EMPTY_BYTES);
        }

        void addText(String text) {
            if (!this.isClosed.get()) {
                this.queuedBytes.offer(text.getBytes(StandardCharsets.UTF_8));
            }
        }

        void resetStream() {
            this.isClosed.set(false);
            this.queuedBytes.clear();
            this.queuedBytes.offer(EMPTY_BYTES);
        }
    }

    private class IPOut
    extends OutputStream {
        TextType type;
        byte[] buffer = new byte[1];

        IPOut(TextType type) {
            this.type = type;
        }

        @Override
        public void write(int b) throws IOException {
            this.buffer[0] = (byte)b;
            String text = new String(this.buffer);
            InterpreterPanel.this.addText(text, this.type);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            String text = new String(b, off, len);
            InterpreterPanel.this.addText(text, this.type);
        }
    }

    public static enum TextType {
        STDOUT,
        STDERR,
        STDIN;

    }
}

