/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import ghidra.app.plugin.core.navigation.AbstractNextPreviousAction;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import resources.ResourceManager;

public class NextPreviousDefinedDataAction
extends AbstractNextPreviousAction {
    public NextPreviousDefinedDataAction(PluginTool tool, String owner, String subGroup) {
        super(tool, "Next Data", owner, subGroup);
    }

    @Override
    protected String getNavigationTypeName() {
        return "Data";
    }

    @Override
    protected Icon getIcon() {
        return ResourceManager.loadImage((String)"images/D.gif");
    }

    @Override
    protected KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(68, 640);
    }

    @Override
    protected Address getNextAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        if (this.isDefinedDataAt(program, address)) {
            address = this.getAddressOfNextPreviousNonDefinedData(monitor, program, address, true);
        }
        return this.getAddressOfNextDataAfter(program, address);
    }

    @Override
    protected Address getPreviousAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        if (this.isDefinedDataAt(program, address)) {
            address = this.getAddressOfNextPreviousNonDefinedData(monitor, program, address, false);
        }
        return this.getAddressOfPreviousDataBefore(program, address);
    }

    private boolean isDefinedDataAt(Program program, Address address) {
        if (address == null) {
            return false;
        }
        Data data = program.getListing().getDataAt(address);
        if (data == null) {
            return false;
        }
        return data.isDefined();
    }

    private Address getAddressOfNextDataAfter(Program program, Address address) {
        if (address == null) {
            return null;
        }
        Data data = program.getListing().getDefinedDataAfter(address);
        if (data == null) {
            return null;
        }
        return data.getMinAddress();
    }

    private Address getAddressOfPreviousDataBefore(Program program, Address address) {
        if (address == null) {
            return null;
        }
        Data data = program.getListing().getDefinedDataBefore(address);
        if (data == null) {
            return null;
        }
        return data.getMinAddress();
    }

    private Address getAddressOfNextPreviousNonDefinedData(TaskMonitor monitor, Program program, Address address, boolean forward) throws CancelledException {
        CodeUnitIterator codeUnits = program.getListing().getCodeUnits(address, forward);
        while (codeUnits.hasNext()) {
            monitor.checkCanceled();
            CodeUnit codeUnit = codeUnits.next();
            if (codeUnit instanceof Instruction) {
                return codeUnit.getAddress();
            }
            if (!(codeUnit instanceof Data) || ((Data)codeUnit).isDefined()) continue;
            return codeUnit.getAddress();
        }
        return null;
    }
}

