/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.osgi;

import docking.ComponentProvider;
import docking.action.builder.ActionBuilder;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableFilterPanel;
import docking.widgets.table.RowObjectTableModel;
import generic.jar.ResourceFile;
import generic.util.Path;
import ghidra.app.plugin.core.osgi.BundleHost;
import ghidra.app.plugin.core.osgi.BundleStatus;
import ghidra.app.plugin.core.osgi.BundleStatusChangeRequestListener;
import ghidra.app.plugin.core.osgi.BundleStatusTableModel;
import ghidra.app.plugin.core.osgi.GhidraBundle;
import ghidra.app.plugin.core.osgi.GhidraBundleException;
import ghidra.app.plugin.core.osgi.GhidraPlaceholderBundle;
import ghidra.app.services.ConsoleService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.preferences.Preferences;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.filechooser.GhidraFileChooserModel;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import resources.Icons;
import resources.ResourceManager;

public class BundleStatusComponentProvider
extends ComponentProviderAdapter {
    static final String BUNDLE_GROUP = "0bundle group";
    static final String BUNDLE_LIST_GROUP = "1bundle list group";
    static final String PREFERENCE_LAST_SELECTED_BUNDLE = "LastGhidraBundle";
    private JPanel panel;
    private GTable bundleStatusTable;
    private final BundleStatusTableModel bundleStatusTableModel;
    private GTableFilterPanel<BundleStatus> filterPanel;
    private GhidraFileChooser fileChooser;
    private GhidraFileFilter filter;
    private final BundleHost bundleHost;

    public BundleStatusComponentProvider(PluginTool tool, String owner, BundleHost bundleHost) {
        super(tool, "BundleManager", owner);
        this.setHelpLocation(new HelpLocation("BundleManager", "BundleManager"));
        this.setTitle("Bundle Manager");
        this.bundleHost = bundleHost;
        this.bundleStatusTableModel = new BundleStatusTableModel(this, bundleHost);
        this.bundleStatusTableModel.addListener(new MyBundleStatusChangeRequestListener());
        this.filter = new GhidraFileFilter(){

            public String getDescription() {
                return "Source code directory, bundle (*.jar), or bnd script (*.bnd)";
            }

            public boolean accept(File file, GhidraFileChooserModel model) {
                return GhidraBundle.getType(file) != GhidraBundle.Type.INVALID;
            }
        };
        this.fileChooser = null;
        this.build();
        this.addToTool();
        this.createActions();
    }

    private void build() {
        this.panel = new JPanel(new BorderLayout(5, 5));
        this.bundleStatusTable = new GTable((TableModel)((Object)this.bundleStatusTableModel));
        this.bundleStatusTable.setName("BUNDLESTATUS_TABLE");
        this.bundleStatusTable.setSelectionBackground(new Color(204, 204, 255));
        this.bundleStatusTable.setSelectionForeground(Color.BLACK);
        this.bundleStatusTable.setSelectionMode(2);
        this.bundleStatusTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.tool.contextChanged((ComponentProvider)this);
        });
        this.bundleStatusTable.setAutoCreateColumnsFromModel(false);
        this.filterPanel = new GTableFilterPanel((JTable)this.bundleStatusTable, (RowObjectTableModel)this.bundleStatusTableModel);
        JScrollPane scrollPane = new JScrollPane((Component)this.bundleStatusTable);
        scrollPane.getViewport().setBackground(this.bundleStatusTable.getBackground());
        this.panel.add((Component)this.filterPanel, "South");
        this.panel.add((Component)scrollPane, "Center");
        this.panel.setPreferredSize(new Dimension(800, 400));
    }

    private void addBundlesAction(String actionName, String description, Icon icon, Runnable runnable) {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(actionName, this.getName()).popupMenuPath(new String[]{description})).popupMenuIcon(icon)).popupMenuGroup(BUNDLE_GROUP)).description(description)).enabled(false)).enabledWhen(context -> this.bundleStatusTable.getSelectedRows().length > 0)).onAction(context -> runnable.run())).buildAndInstallLocal((ComponentProvider)this);
    }

    private void createActions() {
        ImageIcon icon = Icons.REFRESH_ICON;
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("RefreshBundles", this.getName()).popupMenuPath(new String[]{"Refresh all"})).popupMenuIcon((Icon)icon)).popupMenuGroup(BUNDLE_LIST_GROUP)).toolBarIcon((Icon)icon)).toolBarGroup(BUNDLE_LIST_GROUP)).description("Refresh state by cleaning and reactivating all enabled bundles")).onAction(c -> this.doRefresh())).buildAndInstallLocal((ComponentProvider)this);
        this.addBundlesAction("EnableBundles", "Enable selected bundle(s)", ResourceManager.loadImage((String)"images/media-playback-start.png"), this::doEnableBundles);
        this.addBundlesAction("DisableBundles", "Disable selected bundle(s)", ResourceManager.loadImage((String)"images/media-playback-stop.png"), this::doDisableBundles);
        this.addBundlesAction("CleanBundles", "Clean selected bundle build cache(s)", ResourceManager.loadImage((String)"images/erase16.png"), this::doCleanBundleBuildCaches);
        icon = ResourceManager.loadImage((String)"images/Plus.png");
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("AddBundles", this.getName()).popupMenuPath(new String[]{"Add bundle(s)"})).popupMenuIcon((Icon)icon)).popupMenuGroup(BUNDLE_LIST_GROUP)).toolBarIcon((Icon)icon)).toolBarGroup(BUNDLE_LIST_GROUP)).description("Display file chooser to add bundles to list")).onAction(c -> this.showAddBundlesFileChooser())).buildAndInstallLocal((ComponentProvider)this);
        icon = ResourceManager.loadImage((String)"images/edit-delete.png");
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("RemoveBundles", this.getName()).popupMenuPath(new String[]{"Remove selected bundle(s)"})).popupMenuIcon((Icon)icon)).popupMenuGroup(BUNDLE_LIST_GROUP)).toolBarIcon((Icon)icon)).toolBarGroup(BUNDLE_LIST_GROUP)).description("Remove selected bundle(s) from the list")).enabledWhen(c -> this.bundleStatusTable.getSelectedRows().length > 0)).onAction(c -> this.doRemoveBundles())).buildAndInstallLocal((ComponentProvider)this);
    }

    int[] getSelectedModelRows() {
        int[] selectedRows = this.bundleStatusTable.getSelectedRows();
        if (selectedRows == null) {
            return null;
        }
        return Arrays.stream(selectedRows).map(arg_0 -> this.filterPanel.getModelRow(arg_0)).toArray();
    }

    private void doRefresh() {
        List<BundleStatus> statuses = this.bundleStatusTableModel.getModelData().stream().filter(BundleStatus::isEnabled).collect(Collectors.toList());
        for (BundleStatus status : statuses) {
            GhidraBundle bundle = this.bundleHost.getExistingGhidraBundle(status.getFile());
            bundle.clean();
            status.setSummary("");
            try {
                this.bundleHost.deactivateSynchronously(bundle.getLocationIdentifier());
            }
            catch (GhidraBundleException | InterruptedException e) {
                Msg.error((Object)((Object)this), (Object)"Error while deactivating bundle", (Throwable)e);
            }
        }
        new TaskLauncher((Task)new EnableAndActivateBundlesTask("activating", statuses, true), (Component)this.getComponent(), 1000);
    }

    private void doCleanBundleBuildCaches() {
        int[] selectedModelRows = this.getSelectedModelRows();
        boolean anythingCleaned = false;
        for (BundleStatus status : this.bundleStatusTableModel.getRowObjects(selectedModelRows)) {
            anythingCleaned |= this.bundleHost.getExistingGhidraBundle(status.getFile()).clean();
            if (status.getSummary().isEmpty()) continue;
            status.setSummary("");
            anythingCleaned |= true;
        }
        if (anythingCleaned) {
            this.bundleStatusTableModel.fireTableDataChanged();
        }
    }

    private void doRemoveBundles() {
        int[] selectedModelRows = this.getSelectedModelRows();
        if (selectedModelRows == null || selectedModelRows.length == 0) {
            return;
        }
        new TaskLauncher((Task)new RemoveBundlesTask("removing bundles", this.getSelectedStatuses()), (Component)this.getComponent(), 1000);
    }

    private void showAddBundlesFileChooser() {
        File lastSelectedFile;
        String lastSelected;
        if (this.fileChooser == null) {
            this.fileChooser = new GhidraFileChooser((Component)this.getComponent());
            this.fileChooser.setMultiSelectionEnabled(true);
            this.fileChooser.setFileSelectionMode(GhidraFileChooserMode.FILES_AND_DIRECTORIES);
            this.fileChooser.setTitle("Select Bundle(s)");
            if (this.filter != null) {
                this.fileChooser.addFileFilter(new GhidraFileFilter(){

                    public String getDescription() {
                        return BundleStatusComponentProvider.this.filter.getDescription();
                    }

                    public boolean accept(File f, GhidraFileChooserModel model) {
                        return BundleStatusComponentProvider.this.filter.accept(f, model);
                    }
                });
            }
            if ((lastSelected = Preferences.getProperty((String)PREFERENCE_LAST_SELECTED_BUNDLE)) != null) {
                lastSelectedFile = new File(lastSelected);
                this.fileChooser.setSelectedFile(lastSelectedFile);
            }
        } else {
            lastSelected = Preferences.getProperty((String)PREFERENCE_LAST_SELECTED_BUNDLE);
            if (lastSelected != null) {
                lastSelectedFile = new File(lastSelected);
                this.fileChooser.setSelectedFile(lastSelectedFile);
            }
            this.fileChooser.rescanCurrentDirectory();
        }
        List files = this.fileChooser.getSelectedFiles();
        if (!files.isEmpty()) {
            Preferences.setProperty((String)PREFERENCE_LAST_SELECTED_BUNDLE, (String)((File)files.get(0)).getAbsolutePath());
            List<ResourceFile> resourceFiles = files.stream().map(ResourceFile::new).collect(Collectors.toUnmodifiableList());
            Collection<GhidraBundle> bundles = this.bundleHost.add(resourceFiles, true, false);
            TaskLauncher.launchNonModal((String)"activating new bundles", monitor -> this.bundleHost.activateAll(bundles, monitor, ((ConsoleService)this.getTool().getService(ConsoleService.class)).getStdErr()));
        }
    }

    protected List<BundleStatus> getSelectedStatuses() {
        return this.bundleStatusTableModel.getRowObjects(this.getSelectedModelRows());
    }

    protected void doEnableBundles() {
        new TaskLauncher((Task)new EnableAndActivateBundlesTask("enabling", this.getSelectedStatuses(), false), (Component)this.getComponent(), 1000);
    }

    protected void doDisableBundles() {
        new TaskLauncher((Task)new DeactivateAndDisableBundlesTask("disabling", this.getSelectedStatuses()), (Component)this.getComponent(), 1000);
    }

    protected void doActivateDeactivateBundle(BundleStatus status, boolean activate) {
        status.setBusy(true);
        this.notifyTableRowChanged(status);
        new TaskLauncher((Task)new ActivateDeactivateBundleTask((activate ? "Activating" : "Deactivating ") + " bundle...", status, activate), null, 1000);
    }

    private void notifyTableRowChanged(BundleStatus status) {
        Swing.runIfSwingOrRunLater(() -> {
            int modelRowIndex = this.bundleStatusTableModel.getRowIndex(status);
            int viewRowIndex = this.filterPanel.getViewRow(modelRowIndex);
            this.bundleStatusTable.notifyTableChanged(new TableModelEvent((TableModel)((Object)this.bundleStatusTableModel), viewRowIndex));
        });
    }

    private void notifyTableDataChanged() {
        Swing.runIfSwingOrRunLater(() -> this.bundleStatusTable.notifyTableChanged(new TableModelEvent((TableModel)((Object)this.bundleStatusTableModel))));
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public void dispose() {
        this.filterPanel.dispose();
    }

    void selectModelRow(int modelRowIndex) {
        this.bundleStatusTable.selectRow(this.filterPanel.getViewRow(modelRowIndex));
    }

    public void setBundleFilesForTesting(List<ResourceFile> bundleFiles) {
        this.bundleStatusTableModel.setModelData(bundleFiles.stream().map(f -> new BundleStatus((ResourceFile)f, true, false, null)).collect(Collectors.toList()));
    }

    private class MyBundleStatusChangeRequestListener
    implements BundleStatusChangeRequestListener {
        private MyBundleStatusChangeRequestListener() {
        }

        @Override
        public void bundleEnablementChangeRequest(BundleStatus status, boolean newValue) {
            GhidraBundle bundle = BundleStatusComponentProvider.this.bundleHost.getExistingGhidraBundle(status.getFile());
            if (bundle instanceof GhidraPlaceholderBundle) {
                return;
            }
            if (newValue) {
                BundleStatusComponentProvider.this.bundleHost.enable(bundle);
                BundleStatusComponentProvider.this.doActivateDeactivateBundle(status, true);
            } else {
                if (status.isActive()) {
                    BundleStatusComponentProvider.this.doActivateDeactivateBundle(status, false);
                }
                BundleStatusComponentProvider.this.bundleHost.disable(bundle);
            }
        }

        @Override
        public void bundleActivationChangeRequest(BundleStatus status, boolean newValue) {
            if (status.isEnabled()) {
                BundleStatusComponentProvider.this.doActivateDeactivateBundle(status, newValue);
            }
        }
    }

    private class ActivateDeactivateBundleTask
    extends Task {
        private final BundleStatus status;
        private final boolean activate;

        private ActivateDeactivateBundleTask(String title, BundleStatus status, boolean activate) {
            super(title);
            this.status = status;
            this.activate = activate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(TaskMonitor monitor) throws CancelledException {
            ConsoleService console = (ConsoleService)BundleStatusComponentProvider.this.getTool().getService(ConsoleService.class);
            try {
                GhidraBundle bundle = BundleStatusComponentProvider.this.bundleHost.getExistingGhidraBundle(this.status.getFile());
                if (this.activate) {
                    if (this.status.getSummary().startsWith("activating bundle")) {
                        this.status.setSummary("");
                    }
                    BundleStatusComponentProvider.this.bundleHost.activateAll(Collections.singletonList(bundle), monitor, console.getStdErr());
                } else {
                    BundleStatusComponentProvider.this.bundleHost.deactivateSynchronously(bundle.getLocationIdentifier());
                }
            }
            catch (Exception e) {
                this.status.setSummary(e.getMessage());
                Msg.error((Object)((Object)this), (Object)"Error during activation/deactivation of bundle", (Throwable)e);
            }
            finally {
                this.status.setBusy(false);
                BundleStatusComponentProvider.this.notifyTableRowChanged(this.status);
            }
        }
    }

    private class DeactivateAndDisableBundlesTask
    extends Task {
        final List<BundleStatus> statuses;

        private DeactivateAndDisableBundlesTask(String title, List<BundleStatus> statuses) {
            super(title, true, true, false);
            this.statuses = statuses;
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            List bundles = this.statuses.stream().filter(status -> status.isEnabled()).map(status -> BundleStatusComponentProvider.this.bundleHost.getExistingGhidraBundle(status.getFile())).collect(Collectors.toList());
            monitor.setMaximum((long)bundles.size());
            for (GhidraBundle bundle : bundles) {
                try {
                    BundleStatusComponentProvider.this.bundleHost.deactivateSynchronously(bundle.getLocationIdentifier());
                    BundleStatusComponentProvider.this.bundleHost.disable(bundle);
                }
                catch (GhidraBundleException | InterruptedException e) {
                    Msg.error((Object)((Object)this), (Object)"Error while deactivating and disabling bundle", (Throwable)e);
                }
                monitor.incrementProgress(1L);
            }
        }
    }

    private class EnableAndActivateBundlesTask
    extends Task {
        private final List<BundleStatus> statuses;
        private final boolean inStages;

        private EnableAndActivateBundlesTask(String title, List<BundleStatus> statuses, boolean inStages) {
            super(title, true, true, false);
            this.statuses = statuses;
            this.inStages = inStages;
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            ArrayList<GhidraBundle> bundles = new ArrayList<GhidraBundle>();
            for (BundleStatus status : this.statuses) {
                GhidraBundle bundle = BundleStatusComponentProvider.this.bundleHost.getExistingGhidraBundle(status.getFile());
                if (bundle instanceof GhidraPlaceholderBundle) continue;
                status.setBusy(true);
                if (status.getSummary().startsWith("activating bundle")) {
                    status.setSummary("");
                }
                BundleStatusComponentProvider.this.bundleHost.enable(bundle);
                bundles.add(bundle);
            }
            BundleStatusComponentProvider.this.notifyTableDataChanged();
            PrintWriter writer = ((ConsoleService)BundleStatusComponentProvider.this.getTool().getService(ConsoleService.class)).getStdErr();
            if (this.inStages) {
                BundleStatusComponentProvider.this.bundleHost.activateInStages(bundles, monitor, writer);
            } else {
                BundleStatusComponentProvider.this.bundleHost.activateAll(bundles, monitor, writer);
            }
            boolean anybusy = false;
            for (BundleStatus status : this.statuses) {
                if (!status.isBusy()) continue;
                anybusy = true;
                status.setBusy(false);
            }
            if (anybusy) {
                BundleStatusComponentProvider.this.notifyTableDataChanged();
            }
        }
    }

    private final class RemoveBundlesTask
    extends Task {
        private final DeactivateAndDisableBundlesTask deactivateBundlesTask;
        private final List<BundleStatus> statuses;

        private RemoveBundlesTask(String title, List<BundleStatus> statuses) {
            super(title);
            this.deactivateBundlesTask = new DeactivateAndDisableBundlesTask("deactivating", statuses);
            this.statuses = statuses;
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            this.deactivateBundlesTask.run(monitor);
            monitor.checkCanceled();
            Map<Boolean, List<GhidraBundle>> bundles = this.statuses.stream().map(bs -> BundleStatusComponentProvider.this.bundleHost.getExistingGhidraBundle(bs.getFile())).collect(Collectors.partitioningBy(GhidraBundle::isSystemBundle));
            List<GhidraBundle> systemBundles = bundles.get(true);
            if (!systemBundles.isEmpty()) {
                StringBuilder buff = new StringBuilder();
                for (GhidraBundle bundle : systemBundles) {
                    buff.append(Path.toPathString((ResourceFile)bundle.getFile()) + "\n");
                }
                Msg.showWarn((Object)((Object)this), (Component)BundleStatusComponentProvider.this.getComponent(), (String)"Unabled to remove", (Object)("System bundles cannot be removed:\n" + buff.toString()));
            }
            BundleStatusComponentProvider.this.bundleHost.remove((Collection<GhidraBundle>)bundles.get(false));
        }
    }
}

