/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.programtree;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import ghidra.app.cmd.module.CreateDefaultTreeCmd;
import ghidra.app.cmd.module.DeleteTreeCmd;
import ghidra.app.cmd.module.RenameTreeCmd;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.TreeSelectionPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.programtree.ProgramDnDTree;
import ghidra.app.plugin.core.programtree.ProgramListener;
import ghidra.app.plugin.core.programtree.ProgramNode;
import ghidra.app.plugin.core.programtree.ProgramTreeActionManager;
import ghidra.app.plugin.core.programtree.TreeViewProvider;
import ghidra.app.plugin.core.programtree.ViewManagerComponentProvider;
import ghidra.app.plugin.core.programtree.ViewProviderService;
import ghidra.app.services.GoToService;
import ghidra.app.services.ProgramManager;
import ghidra.app.services.ProgramTreeService;
import ghidra.app.services.ViewManagerService;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.util.GroupPath;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.datastruct.StringKeyIndexer;
import ghidra.util.exception.AssertException;
import ghidra.util.task.RunManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.BevelBorder;
import javax.swing.tree.TreePath;
import resources.Icons;
import resources.ResourceManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Program Tree", shortDescription="Show Program Tree Views", description="This plugin shows a view for  each tree in the program. A tree can be organized into folders and fragments.  The program tree view controls what is displayed in the Code Browser.", servicesRequired={ProgramManager.class, GoToService.class}, servicesProvided={ViewManagerService.class, ProgramTreeService.class, ViewProviderService.class}, eventsConsumed={ProgramActivatedPluginEvent.class, TreeSelectionPluginEvent.class}, eventsProduced={TreeSelectionPluginEvent.class})
public class ProgramTreePlugin
extends ProgramPlugin
implements ProgramTreeService,
OptionsChangeListener {
    private static final String PROGRAM_TREE_OPTION_NAME = "Program Tree";
    private static final String REPLACE_VIEW_OPTION_NAME = "Replace View on Double-click";
    private static final String REPLACE_VIEW_OPTION_DESCRIPTION = "When toggled on, a double-click executes the \"Replace View\" action of the Program Tree.  When off, a double-click navigates to the minimum address of the clicked fragment.";
    private static final String NUMBER_OF_VIEWS = "NumberOfViews";
    private static final String TREE_NAME = "TreeName";
    private static final String TOGGLE_STATE = "NavigationToggleState";
    private static final String OPEN_VIEW_ICON_NAME = "images/openSmallFolder.png";
    private static final String CREATE_ICON_NAME = "images/layout_add.png";
    private static final Icon NAVIGATION_ICON = Icons.NAVIGATE_ON_INCOMING_EVENT_ICON;
    private HashMap<String, TreeViewProvider> providerMap;
    private GoToService goToService;
    private ViewManagerService viewManagerService;
    private ProgramTreeActionManager actionManager;
    private TreeViewProvider currentProvider;
    private ViewManagerComponentProvider viewProvider;
    private ProgramListener programListener;
    private TreeViewProvider defaultProvider;
    private boolean firingGoTo;
    private RunManager runManager;
    private DockingAction createAction;
    private DockingAction openAction;
    private ToggleDockingAction selectionToggleAction;
    private JPopupMenu popup;
    private boolean isReplaceViewMode = true;

    public ProgramTreePlugin(PluginTool tool) {
        super(tool, true, false);
        this.viewProvider = new ViewManagerComponentProvider(tool, this.getName());
        this.registerServiceProvided(ViewManagerService.class, this.viewProvider);
        this.providerMap = new HashMap();
        this.actionManager = new ProgramTreeActionManager(this);
        this.registerActions();
        this.programListener = new ProgramListener(this);
        this.runManager = new RunManager();
        this.runManager.showProgressBar(false);
        this.createActions();
        this.defaultProvider = this.addTreeView(PROGRAM_TREE_OPTION_NAME);
        this.initOptions(tool.getOptions(PROGRAM_TREE_OPTION_NAME));
    }

    public void serviceAdded(Class<?> interfaceClass, Object service) {
        if (interfaceClass != ViewProviderService.class) {
            return;
        }
        this.viewProvider.serviceAdded((ViewProviderService)service);
    }

    public void serviceRemoved(Class<?> interfaceClass, Object service) {
        if (interfaceClass != ViewProviderService.class) {
            return;
        }
        this.viewProvider.serviceRemoved((ViewProviderService)service);
    }

    private void initOptions(ToolOptions options) {
        this.isReplaceViewMode = options.getBoolean(REPLACE_VIEW_OPTION_NAME, this.isReplaceViewMode);
        options.registerOption(REPLACE_VIEW_OPTION_NAME, (Object)this.isReplaceViewMode, new HelpLocation(this.getName(), "Replace_View"), REPLACE_VIEW_OPTION_DESCRIPTION);
        options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (REPLACE_VIEW_OPTION_NAME.equals(optionName)) {
            this.isReplaceViewMode = (Boolean)newValue;
        }
    }

    @Override
    public String getViewedTreeName() {
        if (this.currentProvider != null) {
            return this.currentProvider.getViewName();
        }
        return null;
    }

    @Override
    public void setViewedTree(String treeName) {
        TreeViewProvider p = this.providerMap.get(treeName);
        if (this.currentProvider == p) {
            return;
        }
        if (p != null) {
            this.viewManagerService.setCurrentViewProvider(treeName);
            this.currentProvider = p;
        }
    }

    @Override
    public void setGroupSelection(GroupPath[] gps) {
        if (this.currentProvider != null) {
            this.currentProvider.setGroupSelection(gps);
        }
    }

    @Override
    public AddressSet getView() {
        if (this.currentProvider != null) {
            return this.currentProvider.getView();
        }
        return new AddressSet();
    }

    public void dispose() {
        for (String treeName : this.providerMap.keySet()) {
            TreeViewProvider provider = this.providerMap.get(treeName);
            this.deregisterService(ViewProviderService.class, provider);
            provider.dispose();
        }
        this.goToService = null;
        this.viewManagerService = null;
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this.programListener);
        }
        if (this.programListener != null) {
            this.programListener.dispose();
        }
        this.viewProvider.dispose();
        super.dispose();
    }

    public Object getUndoRedoState(DomainObject domainObject) {
        if (domainObject != this.currentProgram) {
            return null;
        }
        SaveState saveState = new SaveState();
        this.writeDataState(saveState);
        return saveState;
    }

    public void restoreUndoRedoState(DomainObject domainObject, Object state) {
        if (domainObject != this.currentProgram) {
            return;
        }
        SaveState saveState = (SaveState)state;
        this.readDataState(saveState);
    }

    public void writeDataState(SaveState saveState) {
        this.viewProvider.writeDataState(saveState);
        saveState.putInt(NUMBER_OF_VIEWS, this.providerMap.size());
        Iterator<String> iter = this.providerMap.keySet().iterator();
        int idx = 0;
        while (iter.hasNext()) {
            String treeName = iter.next();
            saveState.putString("TreeName-" + idx, treeName);
            TreeViewProvider provider = this.providerMap.get(treeName);
            provider.writeDataState(saveState);
            ++idx;
        }
        saveState.putBoolean(TOGGLE_STATE, this.selectionToggleAction.isSelected());
    }

    public void readDataState(SaveState saveState) {
        TreeViewProvider provider;
        this.viewProvider.readDataState(saveState);
        int numberOfViews = saveState.getInt(NUMBER_OF_VIEWS, 0);
        ArrayList<TreeViewProvider> viewList = new ArrayList<TreeViewProvider>();
        String[] treeNames = new String[numberOfViews];
        for (int i = 0; i < numberOfViews; ++i) {
            treeNames[i] = saveState.getString("TreeName-" + i, null);
        }
        ArrayList<TreeViewProvider> providerList = new ArrayList<TreeViewProvider>();
        for (String element : treeNames) {
            provider = this.providerMap.get(element);
            if (provider == null) continue;
            providerList.add(provider);
        }
        for (String treeName : treeNames) {
            provider = this.providerMap.get(treeName);
            if (!this.treeExists(treeName)) {
                if (provider != null) {
                    this.deregisterService(TreeViewProvider.class, provider);
                    this.providerMap.remove(treeName);
                    provider = null;
                }
            } else if (provider == null) {
                provider = this.addTreeView(treeName);
            }
            if (provider == null) continue;
            this.reloadTree(provider.getProgramDnDTree(), true);
            provider.readDataState(saveState);
            viewList.add(provider);
        }
        this.removeStaleProviders(viewList);
        if (viewList.isEmpty()) {
            this.addTreeViews();
        }
        this.selectionToggleAction.setSelected(saveState.getBoolean(TOGGLE_STATE, true));
    }

    public Object getTransientState() {
        SaveState ss = new SaveState();
        this.writeDataState(ss);
        return ss;
    }

    public void restoreTransientState(Object state) {
        SaveState ss = (SaveState)state;
        this.readDataState(ss);
    }

    @Override
    public void processEvent(PluginEvent event) {
        PluginEvent ev;
        super.processEvent(event);
        if (event instanceof ProgramActivatedPluginEvent) {
            ev = (ProgramActivatedPluginEvent)event;
            this.viewProvider.setCurrentProgram(ev.getActiveProgram());
        }
        if (event instanceof TreeSelectionPluginEvent) {
            ev = (TreeSelectionPluginEvent)event;
            String treeName = ev.getTreeName();
            TreeViewProvider provider = this.providerMap.get(treeName);
            if (provider == null) {
                return;
            }
            provider.setGroupSelection(ev.getGroupPaths());
        }
    }

    private void removeStaleProviders(ArrayList<TreeViewProvider> providerList) {
        HashMap<String, TreeViewProvider> map = new HashMap<String, TreeViewProvider>(this.providerMap);
        for (String treeName : map.keySet()) {
            TreeViewProvider provider = map.get(treeName);
            if (providerList.contains(provider)) continue;
            this.deregisterService(ViewProviderService.class, provider);
            this.providerMap.remove(treeName);
        }
    }

    protected void init() {
        this.goToService = (GoToService)this.tool.getService(GoToService.class);
        this.viewManagerService = (ViewManagerService)this.tool.getService(ViewManagerService.class);
        if (this.viewManagerService == null) {
            throw new AssertException("Program Tree Plugin could not find a provider of the View Manager Service");
        }
        this.actionManager.clearSystemClipboard();
    }

    @Override
    protected void programDeactivated(Program program) {
        program.removeListener((DomainObjectListener)this.programListener);
        this.setProgram(null);
    }

    @Override
    protected void programActivated(Program program) {
        program.addListener((DomainObjectListener)this.programListener);
        this.setProgram(program);
    }

    @Override
    protected void locationChanged(ProgramLocation loc) {
        if (this.currentProvider != null && this.selectionToggleAction.isSelected() && loc != null && !this.firingGoTo && !this.actionManager.isReplacingView()) {
            this.currentProvider.selectPathsForLocation(loc);
        }
    }

    void treeViewAdded(String treeName) {
        TreeViewProvider provider = this.providerMap.get(treeName);
        if (provider == null) {
            this.addTreeView(treeName);
        }
    }

    void treeViewChanged(TreeViewProvider provider) {
        this.currentProvider = provider;
    }

    void doubleClick(ProgramNode node) {
        if (this.isReplaceViewMode) {
            this.currentProvider.replaceView(node);
        }
        if (node.isFragment()) {
            this.goTo(node.getFragment());
        } else if (node.isModule()) {
            this.goTo(node.getModule().getAddressSet().getMinAddress());
        } else if (node.isRoot()) {
            this.goTo(this.getCurrentProvider().getView().getMinAddress());
        }
    }

    void goTo(ProgramFragment fragment) {
        Address minAddress = fragment.getMinAddress();
        if (minAddress == null) {
            return;
        }
        this.goTo(minAddress);
    }

    TreeViewProvider getViewProvider(String viewName) {
        return this.providerMap.get(viewName);
    }

    ViewManagerService getViewManagerService() {
        return this.viewManagerService;
    }

    GoToService getGoToService() {
        return this.goToService;
    }

    ProgramTreeActionManager getActionManager() {
        return this.actionManager;
    }

    RunManager getRunManager() {
        return this.runManager;
    }

    DockingAction[] getToolBarActions() {
        return new DockingAction[]{this.createAction, this.openAction, this.selectionToggleAction};
    }

    JPopupMenu getPopupMenu() {
        return this.popup;
    }

    void enableActions(boolean enabled) {
        this.createAction.setEnabled(enabled);
        this.openAction.setEnabled(enabled);
    }

    boolean closeView(TreeViewProvider treeViewProvider) {
        String viewName = treeViewProvider.getViewName();
        if (this.providerMap.size() == 1) {
            this.tool.setStatusInfo("Cannot close last tree view");
            return false;
        }
        this.removeProvider(viewName);
        return true;
    }

    boolean deleteView(TreeViewProvider treeViewProvider) {
        if (this.providerMap.size() == 1) {
            this.tool.setStatusInfo("Cannot delete the last tree view");
            return false;
        }
        String treeName = treeViewProvider.getViewName();
        DeleteTreeCmd cmd = new DeleteTreeCmd(treeName);
        if (!this.tool.execute((Command)cmd, (DomainObject)this.currentProgram)) {
            this.tool.setStatusInfo(cmd.getStatusMsg());
            return false;
        }
        return true;
    }

    boolean renameView(TreeViewProvider treeViewProvider, String newName) {
        Listing listing = this.currentProgram.getListing();
        ProgramModule root = listing.getRootModule(newName);
        if (root == null) {
            String oldName = treeViewProvider.getViewName();
            if (this.providerMap.containsKey(newName)) {
                this.tool.setStatusInfo("Name " + newName + " alredy exists");
                return false;
            }
            this.providerMap.put(newName, treeViewProvider);
            RenameTreeCmd cmd = new RenameTreeCmd(oldName, newName);
            if (!this.tool.execute((Command)cmd, (DomainObject)this.currentProgram)) {
                this.tool.setStatusInfo(cmd.getStatusMsg());
                this.providerMap.remove(newName);
                return false;
            }
            this.providerMap.remove(oldName);
            this.providerMap.put(newName, treeViewProvider);
            if (this.defaultProvider == treeViewProvider) {
                this.defaultProvider = new TreeViewProvider(PROGRAM_TREE_OPTION_NAME, this);
            } else {
                this.reloadTree(treeViewProvider.getProgramDnDTree(), false);
            }
            return true;
        }
        this.tool.setStatusInfo("Tree named '" + newName + "' already exists");
        return false;
    }

    void treeRemoved(String treeName) {
        this.removeProvider(treeName);
    }

    void treeRenamed(String oldName, String newName) {
        TreeViewProvider provider = this.providerMap.get(oldName);
        if (provider != null && !provider.getViewName().equals(newName)) {
            this.providerMap.remove(oldName);
            this.providerMap.put(newName, provider);
            provider.setViewName(newName);
        }
    }

    ProgramDnDTree getTree(String treeName) {
        TreeViewProvider provider = this.providerMap.get(treeName);
        if (provider != null) {
            return provider.getProgramDnDTree();
        }
        return null;
    }

    TreeViewProvider getCurrentProvider() {
        return this.currentProvider;
    }

    int getNumberOfViews() {
        return this.providerMap.size();
    }

    void fragmentMoved() {
        for (String treeName : this.providerMap.keySet()) {
            TreeViewProvider provider = this.providerMap.get(treeName);
            provider.notifyListeners();
        }
    }

    void reloadProgram(boolean checkRoot) {
        String[] treeNames;
        if (this.currentProgram == null) {
            return;
        }
        Listing listing = this.currentProgram.getListing();
        for (String element : treeNames = listing.getTreeNames()) {
            ProgramDnDTree tree = this.getTree(element);
            if (tree == null) continue;
            this.reloadTree(tree, checkRoot);
        }
    }

    private TreeViewProvider addTreeView(String treeName) {
        TreeViewProvider provider = this.providerMap.get(treeName);
        if (provider == null) {
            provider = new TreeViewProvider(treeName, this);
            this.providerMap.put(treeName, provider);
            if (this.currentProgram != null) {
                provider.setProgram(this.currentProgram);
            }
            this.registerServiceProvided(ViewProviderService.class, provider);
        }
        return provider;
    }

    void reloadTree(ProgramDnDTree tree) {
        this.reloadTree(tree, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadTree(ProgramDnDTree tree, boolean checkRoot) {
        ProgramNode rootNode;
        if (tree == null) {
            return;
        }
        ProgramNode programNode = rootNode = (ProgramNode)tree.getModel().getRoot();
        synchronized (programNode) {
            if (checkRoot && rootNode.isValid(tree.getVersionTag())) {
                return;
            }
            ProgramModule rootModule = this.currentProgram.getListing().getRootModule(tree.getTreeName());
            if (rootModule != null && rootModule.getName().equals(rootNode.getName())) {
                GroupPath gp;
                int i;
                tree.setBusyCursor(false);
                ArrayList<GroupPath> expandList = new ArrayList<GroupPath>();
                ArrayList selectList = new ArrayList();
                ArrayList<ProgramNode> nodeList = tree.getNodeList();
                ArrayList<TreePath> origViewList = tree.getViewList();
                ArrayList<GroupPath> newViewList = new ArrayList<GroupPath>();
                for (i = 0; i < nodeList.size(); ++i) {
                    ProgramNode node = (ProgramNode)nodeList.get(i);
                    TreePath path = node.getTreePath();
                    GroupPath gp2 = node.getGroupPath();
                    if (tree.isExpanded(path)) {
                        expandList.add(gp2);
                    }
                    if (!origViewList.contains(path)) continue;
                    newViewList.add(gp2);
                }
                tree.reload();
                for (i = 0; i < selectList.size(); ++i) {
                    gp = (GroupPath)selectList.get(i);
                    tree.addGroupSelectionPath(gp);
                }
                for (i = 0; i < expandList.size(); ++i) {
                    gp = (GroupPath)expandList.get(i);
                    tree.expand(gp);
                }
                for (i = 0; i < newViewList.size(); ++i) {
                    gp = (GroupPath)newViewList.get(i);
                    tree.addGroupViewPath(gp);
                }
                if (newViewList.size() > 0 && tree.getViewList().size() == 0) {
                    tree.addGroupViewPath(new GroupPath(rootNode.getName()));
                }
            } else {
                tree.reload();
                tree.addToView(((ProgramNode)tree.getModel().getRoot()).getTreePath());
            }
            tree.fireTreeViewChanged();
            Listing listing = this.currentProgram.getListing();
            StringKeyIndexer indexer = tree.getNameIndexer();
            String[] keys = indexer.getKeys();
            String treeName = tree.getTreeName();
            for (String element : keys) {
                ProgramFragment f;
                ProgramModule m = listing.getModule(treeName, element);
                if (m != null || (f = listing.getFragment(treeName, element)) != null) continue;
                indexer.remove(element);
            }
        }
    }

    private void removeProvider(String providerName) {
        TreeViewProvider provider = this.providerMap.remove(providerName);
        if (provider != null) {
            this.deregisterService(ViewProviderService.class, provider);
        }
    }

    private boolean treeExists(String treeName) {
        if (this.currentProgram == null && treeName.equals(PROGRAM_TREE_OPTION_NAME)) {
            return true;
        }
        if (this.currentProgram == null) {
            return false;
        }
        return this.currentProgram.getListing().getRootModule(treeName) != null;
    }

    private void registerActions() {
        DockingAction[] actions;
        for (DockingAction element : actions = this.actionManager.getActions()) {
            this.tool.addAction((DockingActionIf)element);
        }
    }

    private void setProgram(Program p) {
        TreeViewProvider provider;
        for (String treeName : this.providerMap.keySet()) {
            provider = this.providerMap.get(treeName);
            provider.setProgram(null);
        }
        for (String treeName : this.providerMap.keySet()) {
            provider = this.providerMap.get(treeName);
            this.deregisterService(ViewProviderService.class, provider);
        }
        this.providerMap.clear();
        this.actionManager.setProgram(p);
        if (p == null) {
            this.addDefaultProvider();
        } else {
            this.addTreeViews();
        }
    }

    private void addDefaultProvider() {
        this.providerMap.put(PROGRAM_TREE_OPTION_NAME, this.defaultProvider);
        this.registerServiceProvided(ViewProviderService.class, this.defaultProvider);
    }

    private void addTreeViews() {
        this.deregisterService(ViewProviderService.class, this.defaultProvider);
        if (this.currentProgram == null) {
            this.addDefaultProvider();
            return;
        }
        String[] treeNames = this.currentProgram.getListing().getTreeNames();
        TreeViewProvider firstProvider = null;
        for (String element : treeNames) {
            TreeViewProvider p = this.addTreeView(element);
            if (firstProvider != null) continue;
            firstProvider = p;
        }
        if (firstProvider == null) {
            this.addDefaultProvider();
            return;
        }
        this.viewManagerService.setCurrentViewProvider(firstProvider.getViewName());
        this.actionManager.setProgramTreeView(firstProvider.getViewName(), firstProvider.getProgramDnDTree());
    }

    private void createDefaultTreeView() {
        Listing listing = this.currentProgram.getListing();
        String baseName = PROGRAM_TREE_OPTION_NAME;
        int index = 1;
        Object viewName = baseName;
        boolean done = false;
        while (!done) {
            ProgramModule root = listing.getRootModule((String)viewName);
            if (root == null) {
                CreateDefaultTreeCmd cmd = new CreateDefaultTreeCmd((String)viewName);
                if (this.tool.execute((Command)cmd, (DomainObject)this.currentProgram)) break;
                this.tool.setStatusInfo(cmd.getStatusMsg());
                break;
            }
            viewName = baseName + "(" + index + ")";
            ++index;
        }
        TreeViewProvider provider = this.addTreeView((String)viewName);
        this.viewManagerService.setCurrentViewProvider((String)viewName);
        this.currentProvider = provider;
    }

    private void openView(Object sourceObject) {
        JButton button = sourceObject instanceof JButton ? (JButton)sourceObject : null;
        String[] treeNames = this.currentProgram.getListing().getTreeNames();
        this.popup = new JPopupMenu("Tree Views");
        int i = 0;
        while (i < treeNames.length) {
            JMenuItem item = new JMenuItem(treeNames[i]);
            int index = i++;
            item.addActionListener(ev -> this.openView(treeNames[index]));
            this.popup.add(item);
        }
        if (treeNames.length == 0) {
            this.getTool().setStatusInfo("No views exist.");
        } else {
            this.popup.setBorder(new BevelBorder(0));
            if (button != null) {
                this.popup.show(button, button.getX() - button.getWidth(), button.getY());
            }
        }
    }

    private void openView(String treeName) {
        TreeViewProvider provider = this.providerMap.get(treeName);
        if (provider != null) {
            this.viewManagerService.setCurrentViewProvider(treeName);
            this.currentProvider = provider;
        } else {
            provider = this.addTreeView(treeName);
            this.viewManagerService.setCurrentViewProvider(treeName);
        }
    }

    private void createActions() {
        this.openAction = new DockingAction("Open Tree View", this.getName()){

            public void actionPerformed(ActionContext context) {
                ProgramTreePlugin.this.openView(context.getSourceObject());
            }
        };
        ImageIcon icon = ResourceManager.loadImage((String)OPEN_VIEW_ICON_NAME);
        this.openAction.setToolBarData(new ToolBarData((Icon)icon));
        this.openAction.setEnabled(false);
        this.openAction.setDescription("Open Tree View");
        this.openAction.setHelpLocation(new HelpLocation(this.getName(), "Open_Tree_View"));
        this.createAction = new DockingAction("Create Default Tree View", this.getName()){

            public void actionPerformed(ActionContext context) {
                ProgramTreePlugin.this.createDefaultTreeView();
            }
        };
        icon = ResourceManager.loadImage((String)CREATE_ICON_NAME);
        this.createAction.setToolBarData(new ToolBarData((Icon)icon));
        this.createAction.setEnabled(false);
        this.createAction.setDescription(HTMLUtilities.toHTML((String)"Create a new default tree view; shows\na fragment for each of the memory blocks."));
        this.createAction.setHelpLocation(new HelpLocation(this.getName(), "Create_Default_Tree_View"));
        this.selectionToggleAction = new ToggleDockingAction("Navigation", this.getName()){

            public void actionPerformed(ActionContext context) {
                if (ProgramTreePlugin.this.selectionToggleAction.isSelected()) {
                    ProgramTreePlugin.this.selectFragments();
                }
            }
        };
        this.selectionToggleAction.setEnabled(true);
        this.selectionToggleAction.setSelected(false);
        this.selectionToggleAction.setToolBarData(new ToolBarData(NAVIGATION_ICON));
        this.selectionToggleAction.setDescription(HTMLUtilities.toHTML((String)"Toggle <b>On</b> means to select the fragment(s)\nthat corresponds to the current location."));
        this.selectionToggleAction.setHelpLocation(new HelpLocation(this.getName(), this.selectionToggleAction.getName()));
    }

    private void selectFragments() {
        if (this.currentLocation != null && this.currentProvider != null) {
            this.currentProvider.selectPathsForLocation(this.currentLocation);
        }
    }
}

