/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable;

import docking.widgets.table.AddRemoveListItem;
import docking.widgets.table.TableSortingContext;
import docking.widgets.table.threaded.TableAddRemoveStrategy;
import docking.widgets.table.threaded.TableData;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SymbolTableAddRemoveStrategy
implements TableAddRemoveStrategy<Symbol> {
    public void process(List<AddRemoveListItem<Symbol>> addRemoveList, TableData<Symbol> tableData, TaskMonitor monitor) throws CancelledException {
        Symbol value;
        Set<AddRemoveListItem<Symbol>> items = this.coalesceAddRemoveItems(addRemoveList);
        HashMap<Symbol, Symbol> hashed = new HashMap<Symbol, Symbol>();
        for (Symbol symbol : tableData) {
            hashed.put(symbol, symbol);
        }
        HashSet<Symbol> failedToRemove = new HashSet<Symbol>();
        int n = items.size();
        monitor.setMessage("Removing " + n + " items...");
        monitor.initialize((long)n);
        Iterator<AddRemoveListItem<Symbol>> it = items.iterator();
        while (it.hasNext()) {
            Symbol toRemove;
            AddRemoveListItem<Symbol> item = it.next();
            value = (Symbol)item.getValue();
            if (item.isChange()) {
                toRemove = (Symbol)hashed.remove(value);
                this.remove(tableData, toRemove, failedToRemove);
                monitor.incrementProgress(1L);
            } else if (item.isRemove()) {
                toRemove = (Symbol)hashed.remove(value);
                this.remove(tableData, toRemove, failedToRemove);
                it.remove();
            }
            monitor.checkCanceled();
        }
        if (!failedToRemove.isEmpty()) {
            int size = failedToRemove.size();
            Object message = size == 1 ? "1 old symbol..." : size + " old symbols...";
            monitor.setMessage("Removing " + (String)message);
            tableData.process((data, sortContext) -> this.expungeLostItems((Set<Symbol>)failedToRemove, (List<Symbol>)data, (TableSortingContext<Symbol>)sortContext));
        }
        n = items.size();
        monitor.setMessage("Adding " + n + " items...");
        for (AddRemoveListItem<Symbol> item : items) {
            value = (Symbol)item.getValue();
            if (item.isChange()) {
                tableData.insert((Object)value);
                hashed.put(value, value);
            } else if (item.isAdd()) {
                tableData.insert((Object)value);
                hashed.put(value, value);
            }
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
        }
        monitor.setMessage("Done adding/removing");
    }

    private Set<AddRemoveListItem<Symbol>> coalesceAddRemoveItems(List<AddRemoveListItem<Symbol>> addRemoveList) {
        HashMap<Long, AddRemoveListItem<Symbol>> map = new HashMap<Long, AddRemoveListItem<Symbol>>();
        for (AddRemoveListItem<Symbol> item : addRemoveList) {
            if (item.isChange()) {
                this.handleChange(item, map);
                continue;
            }
            if (item.isAdd()) {
                this.handleAdd(item, map);
                continue;
            }
            this.handleRemove(item, map);
        }
        return new HashSet<AddRemoveListItem<Symbol>>(map.values());
    }

    private void handleAdd(AddRemoveListItem<Symbol> item, Map<Long, AddRemoveListItem<Symbol>> map) {
        long id = ((Symbol)item.getValue()).getID();
        AddRemoveListItem<Symbol> existing = map.get(id);
        if (existing == null) {
            map.put(id, item);
            return;
        }
        if (existing.isChange()) {
            return;
        }
        if (existing.isAdd()) {
            return;
        }
        map.put(id, (AddRemoveListItem<Symbol>)new AddRemoveListItem(AddRemoveListItem.Type.CHANGE, (Object)((Symbol)existing.getValue())));
    }

    private void handleRemove(AddRemoveListItem<Symbol> item, Map<Long, AddRemoveListItem<Symbol>> map) {
        long id = ((Symbol)item.getValue()).getID();
        AddRemoveListItem<Symbol> existing = map.get(id);
        if (existing == null) {
            map.put(id, item);
            return;
        }
        if (existing.isChange()) {
            map.put(id, item);
            return;
        }
        if (existing.isRemove()) {
            return;
        }
        map.remove(id);
    }

    private void handleChange(AddRemoveListItem<Symbol> item, Map<Long, AddRemoveListItem<Symbol>> map) {
        long id = ((Symbol)item.getValue()).getID();
        AddRemoveListItem<Symbol> existing = map.get(id);
        if (existing == null) {
            map.put(id, item);
            return;
        }
        if (!existing.isChange()) {
            map.put(id, item);
        }
    }

    private void remove(TableData<Symbol> tableData, Symbol symbol, Set<Symbol> failedToRemove) {
        if (symbol == null) {
            return;
        }
        if (!tableData.remove((Object)symbol)) {
            failedToRemove.add(symbol);
        }
    }

    private List<Symbol> expungeLostItems(Set<Symbol> toRemove, List<Symbol> data, TableSortingContext<Symbol> sortContext) {
        if (sortContext.isUnsorted()) {
            return data;
        }
        ArrayList<Symbol> newList = new ArrayList<Symbol>(data.size() - toRemove.size());
        for (int i = 0; i < data.size(); ++i) {
            Symbol rowObject = data.get(i);
            if (toRemove.contains(rowObject)) continue;
            newList.add(rowObject);
        }
        return newList;
    }
}

