/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc.datatype;

import ghidra.app.plugin.exceptionhandlers.gcc.DwarfDecoderFactory;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfEHDecoder;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;

public class DwarfEncodingModeDataType
extends BuiltIn {
    public static final DwarfEncodingModeDataType dataType = new DwarfEncodingModeDataType();

    public DwarfEncodingModeDataType() {
        this(null);
    }

    public DwarfEncodingModeDataType(DataTypeManager dtm) {
        super(CategoryPath.ROOT, "dwfenc", dtm);
    }

    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new DwarfEncodingModeDataType(dtm);
    }

    public String getMnemonic(Settings settings) {
        return "dwfenc";
    }

    public int getLength() {
        return 1;
    }

    public String getDescription() {
        return "DWARF value-encoding mode";
    }

    public Object getValue(MemBuffer buf, Settings settings, int length) {
        int mode = -1;
        try {
            mode = buf.getByte(0) & 0xFF;
        }
        catch (MemoryAccessException mae) {
            return null;
        }
        return DwarfDecoderFactory.getDecoder(mode);
    }

    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        boolean size = true;
        byte[] bytes = new byte[1];
        if (buf.getBytes(bytes, 0) != 1) {
            return "??";
        }
        DwarfEHDecoder decoder = DwarfDecoderFactory.getDecoder(bytes[0]);
        return decoder.toString();
    }
}

