/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.app.util.bin.MemoryByteProviderInputStream;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class MemoryByteProvider
implements ByteProvider {
    protected Memory memory;
    protected Address baseAddress;

    public static ByteProvider createMemoryBlockByteProvider(Memory memory, MemoryBlock block) {
        long blockLen = block.getEnd().subtract(block.getStart()) + 1L;
        MemoryByteProvider bp = new MemoryByteProvider(memory, block.getStart());
        return new ByteProviderWrapper(bp, 0L, blockLen);
    }

    public MemoryByteProvider(Memory memory, AddressSpace space) {
        this(memory, space.getAddress(0L));
    }

    public MemoryByteProvider(Memory memory, Address baseAddress) {
        this.memory = memory;
        this.baseAddress = baseAddress;
    }

    public Address getAddress(long index) {
        return this.baseAddress.add(index);
    }

    @Override
    public InputStream getInputStream(long index) throws IOException {
        return new MemoryByteProviderInputStream(this.memory, this.baseAddress.add(index));
    }

    @Override
    public File getFile() {
        return new File(this.memory.getProgram().getExecutablePath());
    }

    @Override
    public String getName() {
        return this.memory.getProgram().getName();
    }

    @Override
    public String getAbsolutePath() {
        return this.memory.getProgram().getExecutablePath();
    }

    @Override
    public long length() throws IOException {
        MemoryBlock block = this.memory.getBlock(this.baseAddress);
        if (block == null || !block.isInitialized()) {
            return 0L;
        }
        return block.getEnd().subtract(this.baseAddress) + 1L;
    }

    @Override
    public boolean isValidIndex(long index) {
        try {
            Address indexAddress = this.baseAddress.add(index);
            return this.memory.contains(indexAddress);
        }
        catch (AddressOutOfBoundsException e) {
            return false;
        }
    }

    @Override
    public byte readByte(long index) throws IOException {
        try {
            return this.memory.getByte(this.baseAddress.add(index));
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public byte[] readBytes(long index, long length) throws IOException {
        try {
            byte[] bytes = new byte[(int)length];
            int nRead = this.memory.getBytes(this.baseAddress.add(index), bytes);
            if ((long)nRead != length) {
                throw new IOException("Unable to read " + length + " bytes at index " + index);
            }
            return bytes;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void close() {
    }
}

