/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.program.model.listing.Program;

public final class DwarfSectionNames {
    private static final String MACHO_PREFIX = "__";
    private static final String ELF_PREFIX = ".";
    private String prefix = "";

    public DwarfSectionNames(Program program) {
        if ("Mac OS X Mach-O".equals(program.getExecutableFormat())) {
            this.prefix = MACHO_PREFIX;
        } else if ("Executable and Linking Format (ELF)".equals(program.getExecutableFormat())) {
            this.prefix = ELF_PREFIX;
        } else {
            throw new IllegalArgumentException("Unrecognized program format: " + program.getExecutableFormat());
        }
    }

    public String SECTION_NAME_ABBREV() {
        return this.prefix + "debug_abbrev";
    }

    public String SECTION_NAME_ARANGES() {
        return this.prefix + "debug_aranges";
    }

    public String SECTION_NAME_FRAME() {
        return this.prefix + "debug_frame";
    }

    public String SECTION_NAME_INFO() {
        return this.prefix + "debug_info";
    }

    public String SECTION_NAME_LINE() {
        return this.prefix + "debug_line";
    }

    public String SECTION_NAME_LOC() {
        return this.prefix + "debug_loc";
    }

    public String SECTION_NAME_MACINFO() {
        return this.prefix + "debug_macinfo";
    }

    public String SECTION_NAME_PUBNAMES() {
        return this.prefix + "debug_pubnames";
    }

    public String SECTION_NAME_PUBTYPES() {
        return this.prefix + "debug_pubtypes";
    }

    public String SECTION_NAME_RANGES() {
        return this.prefix + "debug_ranges";
    }

    public String SECTION_NAME_STR() {
        return this.prefix + "debug_str";
    }
}

