/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import generic.continues.GenericFactory;
import ghidra.app.util.bin.ByteArrayConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.dwarf4.LEB128;
import ghidra.app.util.bin.format.elf.AndroidElfRelocationTableDataType;
import ghidra.app.util.bin.format.elf.ElfFileSection;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfRelrRelocationTableDataType;
import ghidra.app.util.bin.format.elf.ElfSectionHeader;
import ghidra.app.util.bin.format.elf.ElfSymbolTable;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ElfRelocationTable
implements ElfFileSection,
ByteArrayConverter {
    private TableFormat format;
    private ElfSectionHeader sectionToBeRelocated;
    private ElfSymbolTable symbolTable;
    private ElfSectionHeader relocTableSection;
    private long fileOffset;
    private long addrOffset;
    private long length;
    private long entrySize;
    private boolean addendTypeReloc;
    private GenericFactory factory;
    private ElfHeader elfHeader;
    private ElfRelocation[] relocs;

    static ElfRelocationTable createElfRelocationTable(FactoryBundledWithBinaryReader reader, ElfHeader header, ElfSectionHeader relocTableSection, long fileOffset, long addrOffset, long length, long entrySize, boolean addendTypeReloc, ElfSymbolTable symbolTable, ElfSectionHeader sectionToBeRelocated, TableFormat format) throws IOException {
        ElfRelocationTable elfRelocationTable = (ElfRelocationTable)reader.getFactory().create(ElfRelocationTable.class, new Object[0]);
        elfRelocationTable.initElfRelocationTable(reader, header, relocTableSection, fileOffset, addrOffset, length, entrySize, addendTypeReloc, symbolTable, sectionToBeRelocated, format);
        return elfRelocationTable;
    }

    private void initElfRelocationTable(FactoryBundledWithBinaryReader reader, ElfHeader header, ElfSectionHeader relocTableSection, long fileOffset, long addrOffset, long length, long entrySize, boolean addendTypeReloc, ElfSymbolTable symbolTable, ElfSectionHeader sectionToBeRelocated, TableFormat format) throws IOException {
        this.relocTableSection = relocTableSection;
        this.fileOffset = fileOffset;
        this.addrOffset = addrOffset;
        this.length = length;
        this.entrySize = entrySize;
        this.addendTypeReloc = addendTypeReloc;
        this.elfHeader = header;
        this.factory = reader.getFactory();
        this.format = format;
        this.sectionToBeRelocated = sectionToBeRelocated;
        this.symbolTable = symbolTable;
        long ptr = reader.getPointerIndex();
        reader.setPointerIndex(fileOffset);
        List<ElfRelocation> relocList = format == TableFormat.RELR ? this.parseRelrRelocations(reader) : (format == TableFormat.ANDROID ? this.parseAndroidRelocations(reader) : this.parseStandardRelocations(reader));
        reader.setPointerIndex(ptr);
        this.relocs = new ElfRelocation[relocList.size()];
        relocList.toArray(this.relocs);
    }

    private List<ElfRelocation> parseStandardRelocations(FactoryBundledWithBinaryReader reader) throws IOException {
        ArrayList<ElfRelocation> relocations = new ArrayList<ElfRelocation>();
        if (this.entrySize <= 0L) {
            this.entrySize = ElfRelocation.getStandardRelocationEntrySize(this.elfHeader.is64Bit(), this.addendTypeReloc);
        }
        int nRelocs = (int)(this.length / this.entrySize);
        for (int relocationIndex = 0; relocationIndex < nRelocs; ++relocationIndex) {
            relocations.add(ElfRelocation.createElfRelocation(reader, this.elfHeader, relocationIndex, this.addendTypeReloc));
        }
        return relocations;
    }

    private long readNextRelrEntry(FactoryBundledWithBinaryReader reader) throws IOException {
        return this.entrySize == 8L ? reader.readNextLong() : reader.readNextUnsignedInt();
    }

    private long addRelrEntry(long offset, List<ElfRelocation> relocList) {
        relocList.add(ElfRelocation.createElfRelocation(this.factory, this.elfHeader, relocList.size(), this.addendTypeReloc, offset, 0L, 0L));
        return offset + this.entrySize;
    }

    private long addRelrEntries(long baseOffset, long entry, List<ElfRelocation> relocList) {
        long offset = baseOffset;
        while (entry != 0L) {
            if (((entry >>>= 1) & 1L) != 0L) {
                relocList.add(ElfRelocation.createElfRelocation(this.factory, this.elfHeader, relocList.size(), this.addendTypeReloc, offset, 0L, 0L));
            }
            offset += this.entrySize;
        }
        long nBits = this.entrySize * 8L - 1L;
        return baseOffset + nBits * this.entrySize;
    }

    private List<ElfRelocation> parseRelrRelocations(FactoryBundledWithBinaryReader reader) throws IOException {
        ArrayList<ElfRelocation> relocList = new ArrayList<ElfRelocation>();
        long remaining = this.length;
        long offset = this.readNextRelrEntry(reader);
        offset = this.addRelrEntry(offset, relocList);
        remaining -= this.entrySize;
        while (remaining > 0L) {
            long nextValue = this.readNextRelrEntry(reader);
            offset = (nextValue & 1L) == 1L ? this.addRelrEntries(offset, nextValue, relocList) : this.addRelrEntry(nextValue, relocList);
            remaining -= this.entrySize;
        }
        return relocList;
    }

    private List<ElfRelocation> parseAndroidRelocations(FactoryBundledWithBinaryReader reader) throws IOException {
        String identifier = reader.readNextAsciiString(4);
        if (!"APS2".equals(identifier)) {
            throw new IOException("Unsupported Android relocation table format");
        }
        ArrayList<ElfRelocation> relocations = new ArrayList<ElfRelocation>();
        try {
            long groupSize;
            int relocationIndex = 0;
            long offset = LEB128.readAsLong(reader, true);
            for (long remainingRelocations = LEB128.readAsLong(reader, true); remainingRelocations > 0L; remainingRelocations -= groupSize) {
                long groupRInfo;
                long addend = 0L;
                groupSize = LEB128.readAsLong(reader, true);
                if (groupSize > remainingRelocations) {
                    Msg.warn((Object)this, (Object)("Group relocation count " + groupSize + " exceeded total count " + remainingRelocations));
                    break;
                }
                long groupFlags = LEB128.readAsLong(reader, true);
                boolean groupedByInfo = (groupFlags & 1L) != 0L;
                boolean groupedByDelta = (groupFlags & 2L) != 0L;
                boolean groupedByAddend = (groupFlags & 4L) != 0L;
                boolean groupHasAddend = (groupFlags & 8L) != 0L;
                long groupOffsetDelta = groupedByDelta ? LEB128.readAsLong(reader, true) : 0L;
                long l = groupRInfo = groupedByInfo ? LEB128.readAsLong(reader, true) : 0L;
                if (groupedByAddend && groupHasAddend) {
                    addend += LEB128.readAsLong(reader, true);
                }
                int i = 0;
                while ((long)i < groupSize) {
                    offset += groupedByDelta ? groupOffsetDelta : LEB128.readAsLong(reader, true);
                    long info = groupedByInfo ? groupRInfo : LEB128.readAsLong(reader, true);
                    long rAddend = 0L;
                    if (groupHasAddend) {
                        if (!groupedByAddend) {
                            addend += LEB128.readAsLong(reader, true);
                        }
                        rAddend = addend;
                    }
                    relocations.add(ElfRelocation.createElfRelocation(reader.getFactory(), this.elfHeader, relocationIndex++, this.addendTypeReloc, offset, info, rAddend));
                    ++i;
                }
            }
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Error reading relocations.", (Throwable)e);
        }
        return relocations;
    }

    public boolean hasAddendRelocations() {
        return this.addendTypeReloc;
    }

    public ElfSectionHeader getSectionToBeRelocated() {
        return this.sectionToBeRelocated;
    }

    public ElfRelocation[] getRelocations() {
        return this.relocs;
    }

    public int getRelocationCount() {
        return this.relocs.length;
    }

    public ElfSymbolTable getAssociatedSymbolTable() {
        return this.symbolTable;
    }

    @Override
    public byte[] toBytes(DataConverter dc) {
        byte[] bytes = new byte[this.relocs.length * this.relocs[0].sizeof()];
        int index = 0;
        for (ElfRelocation reloc : this.relocs) {
            byte[] relocBytes = reloc.toBytes(dc);
            System.arraycopy(relocBytes, 0, bytes, index, relocBytes.length);
            index += relocBytes.length;
        }
        return bytes;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public long getAddressOffset() {
        return this.addrOffset;
    }

    public ElfSectionHeader getTableSectionHeader() {
        return this.relocTableSection;
    }

    public boolean isRelrTable() {
        return this.format == TableFormat.RELR;
    }

    @Override
    public long getFileOffset() {
        return this.fileOffset;
    }

    @Override
    public int getEntrySize() {
        return (int)this.entrySize;
    }

    @Override
    public DataType toDataType() {
        if (this.format == TableFormat.RELR) {
            String relrStructureName = "Elf_RelrRelocationTable_" + Long.toHexString(this.addrOffset);
            return new ElfRelrRelocationTableDataType(relrStructureName, (int)this.length, (int)this.entrySize);
        }
        if (this.format == TableFormat.ANDROID) {
            return new AndroidElfRelocationTableDataType();
        }
        ElfRelocation relocationRepresentative = ElfRelocation.createElfRelocation(this.factory, this.elfHeader, -1, this.addendTypeReloc, 0L, 0L, 0L);
        DataType relocEntryDataType = relocationRepresentative.toDataType();
        return new ArrayDataType(relocEntryDataType, (int)(this.length / this.entrySize), (int)this.entrySize);
    }

    public static enum TableFormat {
        DEFAULT,
        ANDROID,
        RELR;

    }
}

