/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LinkerOptionCommand
extends LoadCommand {
    private int count;
    private List<String> linkerOptions;

    static LinkerOptionCommand createLinkerOptionCommand(FactoryBundledWithBinaryReader reader) throws IOException {
        LinkerOptionCommand command = (LinkerOptionCommand)reader.getFactory().create(LinkerOptionCommand.class, new Object[0]);
        command.initLinkerOptionCommand(reader);
        return command;
    }

    private void initLinkerOptionCommand(FactoryBundledWithBinaryReader reader) throws IOException {
        this.initLoadCommand(reader);
        this.count = reader.readNextInt();
        this.linkerOptions = new ArrayList<String>(this.count);
        long readerIndex = reader.getPointerIndex();
        for (int i = 0; i < this.count; ++i) {
            String str = reader.readTerminatedString(readerIndex, '\u0000');
            this.linkerOptions.add(str);
            readerIndex += (long)(str.length() + 1);
        }
    }

    public List<String> getLinkerOptions() {
        return this.linkerOptions;
    }

    @Override
    public String getCommandName() {
        return "linker_option_command";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(DWORD, "count", null);
        return struct;
    }

    @Override
    public void markup(MachHeader header, FlatProgramAPI api, Address baseAddress, boolean isBinary, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        this.updateMonitor(monitor);
        try {
            if (isBinary) {
                this.createFragment(api, baseAddress, parentModule);
                Address address = baseAddress.getNewAddress(this.getStartIndex());
                api.createData(address, this.toDataType());
            }
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName());
        }
    }
}

